/*
 * Decompiled with CFR 0.152.
 */
package jnpf.onlinedev.util.onlineDevUtil;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jnpf.base.ActionResult;
import jnpf.base.entity.VisualdevEntity;
import jnpf.base.model.OnlineImport.VisualdevModelDataInfoVO;
import jnpf.base.model.datainterface.DataInterfaceActionVo;
import jnpf.base.service.DataInterfaceService;
import jnpf.base.service.DictionaryDataService;
import jnpf.base.service.ProvinceService;
import jnpf.base.service.VisualdevService;
import jnpf.base.util.DateTimeFormatConstant;
import jnpf.base.util.FormInfoUtils;
import jnpf.base.util.FormPublicUtils;
import jnpf.model.visualJson.FieLdsModel;
import jnpf.model.visualJson.analysis.FormModel;
import jnpf.model.visualJson.options.ColumnOptionModel;
import jnpf.onlinedev.model.OnlineDevEnum.MultipleControlEnum;
import jnpf.onlinedev.model.OnlineDevEnum.OnlineDataTypeEnum;
import jnpf.onlinedev.service.VisualDevInfoService;
import jnpf.onlinedev.service.VisualdevModelDataService;
import jnpf.onlinedev.util.onlineDevUtil.OnlineDevListUtils;
import jnpf.onlinedev.util.onlineDevUtil.OnlinePublicUtils;
import jnpf.permission.entity.GroupEntity;
import jnpf.permission.entity.OrganizeEntity;
import jnpf.permission.entity.PositionEntity;
import jnpf.permission.entity.RoleEntity;
import jnpf.permission.entity.UserEntity;
import jnpf.permission.service.GroupService;
import jnpf.permission.service.OrganizeService;
import jnpf.permission.service.PositionService;
import jnpf.permission.service.RoleService;
import jnpf.permission.service.UserService;
import jnpf.util.DateUtil;
import jnpf.util.JsonUtil;
import jnpf.util.RedisUtil;
import jnpf.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OnlineDevInfoUtils {
    private static final Logger log = LoggerFactory.getLogger(OnlineDevInfoUtils.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private DictionaryDataService dictionaryDataApi;
    @Autowired
    private UserService userApi;
    @Autowired
    private FormInfoUtils formInfoUtils;
    @Autowired
    private PositionService positionApi;
    @Autowired
    private OrganizeService organizeApi;
    @Autowired
    private VisualdevService visualdevService;
    @Autowired
    private VisualdevModelDataService visualdevModelDataService;
    @Autowired
    private DataInterfaceService dataInterFaceApi;
    @Autowired
    private VisualDevInfoService visualDevInfoService;
    @Autowired
    private ProvinceService areaApi;
    @Autowired
    private RoleService roleApi;
    @Autowired
    private GroupService groupApi;
    private Map<String, String> nullDatamap = new HashMap<String, String>();

    public Map<String, Object> swapChildTableDataInfo(List<FieLdsModel> modelList, Map<String, Object> dataMap, List<FormModel> codeList) {
        HashMap<String, Object> dataCopyMap = new HashMap<String, Object>();
        dataCopyMap.putAll(dataMap);
        HashMap<String, Map<String, Object>> dataDetailMap = new HashMap<String, Map<String, Object>>();
        try {
            for (FieLdsModel swapDataVo : modelList) {
                JSONArray data;
                String jnpfKey = swapDataVo.getConfig().getJnpfKey();
                String dataType = swapDataVo.getConfig().getDataType();
                String vModel = swapDataVo.getVModel();
                Object val = dataMap.get(vModel);
                String modelValue = String.valueOf(val);
                if (StringUtil.isEmpty((String)modelValue) || "null".equals(modelValue)) continue;
                if (dataType != null) {
                    String[][] dataAll;
                    LinkedHashMap actionVo;
                    String label = swapDataVo.getProps() != null ? swapDataVo.getProps().getLabel() : "";
                    String value = swapDataVo.getProps() != null ? swapDataVo.getProps().getValue() : "";
                    String Children = swapDataVo.getProps() != null ? swapDataVo.getProps().getChildren() : "";
                    ArrayList<Map<String, Object>> options = new ArrayList();
                    if (dataType.equals(OnlineDataTypeEnum.STATIC.getType())) {
                        if (StringUtil.isNotEmpty((String)swapDataVo.getOptions())) {
                            options = JsonUtil.getJsonToListMap((String)swapDataVo.getOptions());
                            data = JsonUtil.getListToJsonArray(options);
                            OnlineDevListUtils.getOptions(label, value, Children, data, options);
                        } else {
                            options = JsonUtil.getJsonToListMap((String)swapDataVo.getOptions());
                        }
                    }
                    if (dataType.equals(OnlineDataTypeEnum.DYNAMIC.getType()) && (actionVo = (LinkedHashMap)(data = this.dataInterFaceApi.infoToId(swapDataVo.getInterfaceId(), null, this.nullDatamap)).getData()) != null) {
                        List list = (List)actionVo.get("data");
                        dataAll = JsonUtil.getListToJsonArray((List)list);
                        OnlineDevInfoUtils.treeToList(label, value, Children, (JSONArray)dataAll, options);
                    }
                    if (dataType.equals(OnlineDataTypeEnum.DICTIONARY.getType())) {
                        List list = this.dictionaryDataApi.getDicList(swapDataVo.getConfig().getDictionaryType());
                        options = list.stream().map(dic -> {
                            HashMap<String, Object> dictionaryMap = new HashMap<String, Object>(16);
                            dictionaryMap.put("id", dic.getId());
                            dictionaryMap.put("enCode", dic.getEnCode());
                            dictionaryMap.put("fullName", dic.getFullName());
                            return dictionaryMap;
                        }).collect(Collectors.toList());
                    }
                    HashMap dataInterfaceMap = new HashMap(16);
                    options.stream().forEach(o -> dataInterfaceMap.put(String.valueOf(o.get(value)), String.valueOf(o.get(label))));
                    List<String> valueList = new ArrayList<String>();
                    if (OnlinePublicUtils.getMultiple(modelValue, MultipleControlEnum.MULTIPLE_JSON_TWO.getMultipleChar()).booleanValue()) {
                        String[][] stringArray;
                        dataAll = stringArray = (String[][])JsonUtil.getJsonToBean((String)modelValue, String[][].class);
                        int n = dataAll.length;
                        for (int i = 0; i < n; ++i) {
                            String[] casData;
                            for (String string : casData = dataAll[i]) {
                                valueList.add(string);
                            }
                        }
                    } else if (OnlinePublicUtils.getMultiple(modelValue, MultipleControlEnum.MULTIPLE_JSON_ONE.getMultipleChar()).booleanValue()) {
                        valueList = JsonUtil.getJsonToList((String)modelValue, String.class);
                    } else {
                        valueList.add(modelValue);
                    }
                    String string = valueList.stream().map(va -> (String)dataInterfaceMap.get(va)).collect(Collectors.joining(","));
                    dataMap.put(vModel, string);
                    continue;
                }
                switch (jnpfKey) {
                    case "organizeSelect": 
                    case "depSelect": 
                    case "currDept": {
                        dataMap.put(vModel, this.getOrgValue(modelValue));
                        break;
                    }
                    case "currOrganize": {
                        boolean isAll = "all".equals(swapDataVo.getShowLevel());
                        if (isAll) {
                            ArrayList organizeList = new ArrayList();
                            this.organizeApi.getOrganizeId(modelValue, organizeList);
                            Collections.reverse(organizeList);
                            String value = organizeList.stream().map(OrganizeEntity::getFullName).collect(Collectors.joining("/"));
                            dataMap.put(vModel, value);
                            break;
                        }
                        OrganizeEntity organizeEntity = this.organizeApi.getInfo(modelValue);
                        dataMap.put(vModel, Objects.nonNull(organizeEntity) ? organizeEntity.getFullName() : modelValue);
                        break;
                    }
                    case "posSelect": 
                    case "currPosition": {
                        dataMap.put(vModel, this.getPosValue(modelValue));
                        break;
                    }
                    case "userSelect": 
                    case "createUser": 
                    case "modifyUser": {
                        if ("admin".equals(modelValue)) {
                            dataMap.put(vModel, "\u7ba1\u7406\u5458");
                            break;
                        }
                        dataMap.put(vModel, this.getUserValue(modelValue));
                        break;
                    }
                    case "areaSelect": {
                        String value = String.valueOf(dataMap.get(vModel));
                        if (OnlinePublicUtils.getMultiple(value, MultipleControlEnum.MULTIPLE_JSON_TWO.getMultipleChar()).booleanValue()) {
                            data = (JSONArray)JsonUtil.getJsonToBean((String)value, String[][].class);
                            ArrayList<String> addList = new ArrayList<String>();
                            for (String[] AddressData : data) {
                                ArrayList<JSONArray> adList = new ArrayList<JSONArray>();
                                for (JSONArray jSONArray : AddressData) {
                                    adList.add(jSONArray);
                                }
                                addList.add(String.join((CharSequence)"/", this.areaApi.getProList(adList).stream().map(pro -> pro.getFullName()).collect(Collectors.toList())));
                            }
                            dataMap.put(vModel, String.join((CharSequence)";", addList));
                            break;
                        }
                        List proDataS = JsonUtil.getJsonToList((String)value, String.class);
                        dataMap.put(vModel, String.join((CharSequence)",", this.areaApi.getProList(proDataS).stream().map(pro -> pro.getFullName()).collect(Collectors.toList())));
                        break;
                    }
                    case "relationForm": {
                        VisualdevEntity entity = this.visualdevService.getInfo(swapDataVo.getModelId());
                        String string = String.valueOf(dataMap.get(vModel));
                        Map formDataMap = new HashMap(16);
                        VisualdevModelDataInfoVO infoVO = !StringUtil.isEmpty((String)entity.getVisualTables()) && !"[]".equals(entity.getVisualTables()) ? this.visualDevInfoService.getDetailsDataInfo(string, entity) : this.visualdevModelDataService.infoDataChange(string, entity);
                        formDataMap = JsonUtil.stringToMap((String)infoVO.getData());
                        String relationField = swapDataVo.getRelationField();
                        if (formDataMap == null || formDataMap.size() <= 0) break;
                        dataMap.put(vModel + "_id", dataMap.get(vModel));
                        dataMap.put(vModel, formDataMap.get(relationField));
                        dataDetailMap.put(vModel, formDataMap);
                        break;
                    }
                    case "popupSelect": {
                        ActionResult data3 = this.dataInterFaceApi.infoToId(swapDataVo.getInterfaceId(), null, this.nullDatamap);
                        LinkedHashMap actionVo = (LinkedHashMap)data3.getData();
                        List mapList = actionVo.get("data") != null ? (List)actionVo.get("data") : new ArrayList();
                        Map PopMap = mapList.stream().filter(map -> map.get(swapDataVo.getPropsValue()).equals(dataMap.get(vModel))).findFirst().orElse(null);
                        if (PopMap.size() <= 0) break;
                        dataMap.put(vModel + "_id", dataMap.get(vModel));
                        dataMap.put(vModel, PopMap.get(((ColumnOptionModel)swapDataVo.getColumnOptions().get(0)).getValue()));
                        dataDetailMap.put(vModel, PopMap);
                        break;
                    }
                    case "popupTableSelect": {
                        Object popData = this.dataInterFaceApi.infoToId(swapDataVo.getInterfaceId(), null, null).getData();
                        DataInterfaceActionVo dataInterfaceActionVo = (DataInterfaceActionVo)popData;
                        List popMapList = new ArrayList();
                        if (dataInterfaceActionVo.getData() instanceof List) {
                            popMapList = (List)dataInterfaceActionVo.getData();
                        }
                        String popValue = String.valueOf(dataMap.get(vModel));
                        List idList = new ArrayList<String>();
                        if (popValue.contains("[")) {
                            idList = JsonUtil.getJsonToList((String)popValue, String.class);
                        } else {
                            idList.add(popValue);
                        }
                        ArrayList swapValue = new ArrayList();
                        for (String id : idList) {
                            popMapList.stream().filter(map -> map.get(swapDataVo.getPropsValue()).equals(id)).forEach(modelMap -> swapValue.add(String.valueOf(modelMap.get(swapDataVo.getRelationField()))));
                        }
                        dataMap.put(vModel, swapValue.stream().collect(Collectors.joining(",")));
                        break;
                    }
                    case "modifyTime": 
                    case "createTime": 
                    case "datePicker": {
                        String format;
                        String dateSwapInfo;
                        String dateData = String.valueOf(dataMap.get(vModel));
                        String string = swapDataVo.getFormat() != null ? swapDataVo.getFormat() : (dateSwapInfo = swapDataVo.getType() != null && swapDataVo.getType().equals("datePicker") ? "yyyy-MM-dd" : "yyyy-MM-dd HH:mm:ss");
                        if (!dateData.contains("-") && !dateData.contains(":") && dateData.length() > 10) {
                            DateTimeFormatter ftf = DateTimeFormatter.ofPattern(dateSwapInfo);
                            format = ftf.format(LocalDateTime.ofInstant(Instant.ofEpochMilli((Long)dataMap.get(vModel)), ZoneId.of("+8")));
                        } else {
                            format = dateData;
                        }
                        if (format.contains(".")) {
                            format = format.substring(0, format.lastIndexOf("."));
                        }
                        SimpleDateFormat sdf = new SimpleDateFormat(dateSwapInfo);
                        try {
                            Date date = sdf.parse(format);
                            String outTime = sdf.format(sdf.parse(DateUtil.dateFormat((Date)date)));
                            dataMap.put(vModel, outTime);
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    case "switch": {
                        String switchValue = String.valueOf(dataMap.get(vModel)).equals("1") ? swapDataVo.getActiveTxt() : swapDataVo.getInactiveTxt();
                        dataMap.put(vModel, switchValue);
                        break;
                    }
                    case "rate": {
                        BigDecimal ratevalue = new BigDecimal(0);
                        if (dataMap.get(vModel) != null) {
                            ratevalue = new BigDecimal(dataMap.get(vModel).toString());
                        }
                        dataMap.put(vModel, ratevalue);
                        break;
                    }
                    case "slider": {
                        dataMap.put(vModel, dataMap.get(vModel) != null ? Integer.valueOf(Integer.parseInt(String.valueOf(dataMap.get(vModel)))) : null);
                        break;
                    }
                    case "uploadFile": 
                    case "uploadImg": {
                        List fileList = JsonUtil.getJsonToListMap((String)String.valueOf(dataMap.get(vModel)));
                        dataMap.put(vModel, fileList);
                        break;
                    }
                }
            }
            OnlineDevInfoUtils.swapCodeDataInfo(codeList, dataMap, dataCopyMap);
            if (dataDetailMap.size() > 0) {
                OnlineDevInfoUtils.getDataAttr(modelList, dataMap, dataDetailMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataMap;
    }

    public Map<String, Object> swapDataInfoType(List<FieLdsModel> modelList, Map<String, Object> dataMap) {
        return this.formInfoUtils.swapDataInfoType(modelList, dataMap);
    }

    public Map<String, Object> getInitLineData(List<FieLdsModel> modelList, Map<String, Object> dataMap) {
        block24: for (FieLdsModel swapDataVo : modelList) {
            String jnpfKey = swapDataVo.getConfig().getJnpfKey();
            String vModel = swapDataVo.getVModel();
            Object value = dataMap.get(vModel);
            if (value == null || ObjectUtil.isEmpty((Object)value)) continue;
            switch (jnpfKey) {
                case "rate": 
                case "slider": {
                    BigDecimal ratevalue = new BigDecimal(0);
                    if (dataMap.get(vModel) != null) {
                        ratevalue = new BigDecimal(dataMap.get(vModel).toString());
                    }
                    dataMap.put(vModel, ratevalue);
                    continue block24;
                }
                case "uploadFile": 
                case "uploadImg": {
                    List fileList = JsonUtil.getJsonToListMap((String)String.valueOf(value));
                    dataMap.put(vModel, fileList);
                    continue block24;
                }
                case "datePicker": {
                    Long dateTime = DateTimeFormatConstant.getDateObjToLong((Object)dataMap.get(vModel));
                    dataMap.put(vModel, dateTime != null ? dateTime : dataMap.get(vModel));
                    continue block24;
                }
                case "switch": {
                    dataMap.put(vModel, value != null ? Integer.valueOf(Integer.parseInt(String.valueOf(value))) : null);
                    continue block24;
                }
                case "currOrganize": 
                case "currDept": {
                    OrganizeEntity organizeEntity;
                    String orgIds = String.valueOf(dataMap.get(vModel));
                    String orgId = "";
                    String orgName = "";
                    try {
                        List jsonToList = JsonUtil.getJsonToList((String)orgIds, String.class);
                        orgId = (String)jsonToList.get(jsonToList.size() - 1);
                    }
                    catch (Exception e) {
                        orgId = orgIds;
                    }
                    OrganizeEntity organizeEntity2 = organizeEntity = StringUtil.isNotEmpty((String)orgId) ? this.organizeApi.getInfo(orgId) : null;
                    if ("all".equals(swapDataVo.getShowLevel())) {
                        if (organizeEntity != null) {
                            ArrayList organizeList = new ArrayList();
                            this.organizeApi.getOrganizeId(orgId, organizeList);
                            Collections.reverse(organizeList);
                            orgName = organizeList.stream().map(OrganizeEntity::getFullName).collect(Collectors.joining("/"));
                        }
                    } else {
                        orgName = organizeEntity != null ? organizeEntity.getFullName() : " ";
                    }
                    dataMap.put(vModel, orgName);
                    continue block24;
                }
                case "currPosition": {
                    PositionEntity positionEntity = this.positionApi.getInfo(String.valueOf(value));
                    dataMap.put(vModel, Objects.nonNull(positionEntity) ? positionEntity.getFullName() : value);
                    continue block24;
                }
                case "createUser": 
                case "modifyUser": {
                    UserEntity userEntity = this.userApi.getInfo(String.valueOf(value));
                    String userValue = Objects.nonNull(userEntity) ? userEntity.getRealName() + "/" + userEntity.getAccount() : String.valueOf(value);
                    dataMap.put(vModel, userValue);
                    continue block24;
                }
            }
            dataMap.put(vModel, FormPublicUtils.getDataConversion((Object)value));
        }
        return dataMap;
    }

    public static void swapCodeDataInfo(List<FormModel> codeList, Map<String, Object> swapDataMap, Map<String, Object> dataMap) {
        for (FormModel formModel : codeList) {
            Object relationValue;
            String relationFiled;
            String jnpfKey = formModel.getConfig().getJnpfKey();
            if (!jnpfKey.equals("qrcode") && !jnpfKey.equals("barcode")) continue;
            String codeDataType = formModel.getDataType();
            if (!OnlineDataTypeEnum.RELATION.getType().equals(codeDataType) || !StringUtil.isNotEmpty((String)(relationFiled = formModel.getRelationField())) || !ObjectUtil.isNotEmpty((Object)(relationValue = dataMap.get(relationFiled)))) continue;
            swapDataMap.put(relationFiled + "_id", relationValue);
        }
    }

    private static void treeToList(String value, String label, String children, JSONArray data, List<Map<String, Object>> result) {
        for (int i = 0; i < data.size(); ++i) {
            JSONObject ob = data.getJSONObject(i);
            HashMap<String, String> tree = new HashMap<String, String>(16);
            tree.put(value, String.valueOf(ob.get((Object)value)));
            tree.put(label, String.valueOf(ob.get((Object)label)));
            result.add(tree);
            if (ob.get((Object)children) == null) continue;
            JSONArray childArray = ob.getJSONArray(children);
            OnlineDevInfoUtils.treeToList(value, label, children, childArray, result);
        }
    }

    private static void getDataAttr(List<FieLdsModel> fieLdsModelList, Map<String, Object> dataMap, Map<String, Map<String, Object>> dataDetailMap) {
        for (FieLdsModel fieLdsModel : fieLdsModelList) {
            String jnpfKey = fieLdsModel.getConfig().getJnpfKey();
            if (!jnpfKey.equals("relationFormAttr") && !jnpfKey.equals("popupAttr")) continue;
            String relationField = fieLdsModel.getRelationField();
            String showField = fieLdsModel.getShowField();
            Map<String, Object> formDataMap = dataDetailMap.get(relationField);
            dataMap.put(relationField + "_" + showField, formDataMap.get(showField));
        }
    }

    private String getOrgValue(String modelValue) {
        String orgValue;
        if (OnlinePublicUtils.getMultiple(modelValue, MultipleControlEnum.MULTIPLE_JSON_TWO.getMultipleChar()).booleanValue()) {
            String[][] prgArray = (String[][])JsonUtil.getJsonToBean((String)modelValue, String[][].class);
            ArrayList<String> addList = new ArrayList<String>();
            for (String[] prgData : prgArray) {
                ArrayList<String> adList = new ArrayList<String>();
                for (String s : prgData) {
                    OrganizeEntity info = this.organizeApi.getInfo(s);
                    adList.add(Objects.nonNull(info) ? info.getFullName() : "");
                }
                String porData = adList.stream().collect(Collectors.joining("/"));
                addList.add(porData);
            }
            orgValue = String.join((CharSequence)";", addList);
        } else {
            String allValue;
            List valueList = OnlinePublicUtils.getMultiple(modelValue, MultipleControlEnum.MULTIPLE_JSON_ONE.getMultipleChar()) != false ? JsonUtil.getJsonToList((String)modelValue, String.class) : Stream.of(modelValue.split(",")).collect(Collectors.toList());
            orgValue = allValue = valueList.stream().map(va -> {
                OrganizeEntity organizeEntity = this.organizeApi.getInfo(va);
                return Objects.nonNull(organizeEntity) ? organizeEntity.getFullName() : va;
            }).collect(Collectors.joining(","));
        }
        return orgValue;
    }

    private String getPosValue(String modelValue) {
        String posValue;
        if (OnlinePublicUtils.getMultiple(modelValue, MultipleControlEnum.MULTIPLE_JSON_TWO.getMultipleChar()).booleanValue()) {
            String[][] prgArray = (String[][])JsonUtil.getJsonToBean((String)modelValue, String[][].class);
            ArrayList<String> addList = new ArrayList<String>();
            for (String[] prgData : prgArray) {
                ArrayList<String> adList = new ArrayList<String>();
                for (String s : prgData) {
                    PositionEntity info = this.positionApi.getInfo(s);
                    adList.add(Objects.nonNull(info) ? info.getFullName() : "");
                }
                String porData = adList.stream().collect(Collectors.joining("/"));
                addList.add(porData);
            }
            posValue = String.join((CharSequence)";", addList);
        } else {
            String allValue;
            List valueList = OnlinePublicUtils.getMultiple(modelValue, MultipleControlEnum.MULTIPLE_JSON_ONE.getMultipleChar()) != false ? JsonUtil.getJsonToList((String)modelValue, String.class) : Stream.of(modelValue.split(",")).collect(Collectors.toList());
            posValue = allValue = valueList.stream().map(va -> {
                PositionEntity positionEntity = this.positionApi.getInfo(va);
                return Objects.nonNull(positionEntity) ? positionEntity.getFullName() : va;
            }).collect(Collectors.joining(","));
        }
        return posValue;
    }

    private String getUserValue(String modelValue) {
        String userValue;
        if (OnlinePublicUtils.getMultiple(modelValue, MultipleControlEnum.MULTIPLE_JSON_TWO.getMultipleChar()).booleanValue()) {
            String[][] prgArray = (String[][])JsonUtil.getJsonToBean((String)modelValue, String[][].class);
            ArrayList<String> addList = new ArrayList<String>();
            for (String[] prgData : prgArray) {
                ArrayList<Object> adList = new ArrayList<Object>();
                for (String s : prgData) {
                    UserEntity info = this.userApi.getInfo(s);
                    adList.add(Objects.nonNull(info) ? info.getRealName() + "/" + info.getAccount() : "");
                }
                String porData = adList.stream().collect(Collectors.joining("/"));
                addList.add(porData);
            }
            userValue = String.join((CharSequence)";", addList);
        } else {
            String allValue;
            List valueList = OnlinePublicUtils.getMultiple(modelValue, MultipleControlEnum.MULTIPLE_JSON_ONE.getMultipleChar()) != false ? JsonUtil.getJsonToList((String)modelValue, String.class) : Stream.of(modelValue.split(",")).collect(Collectors.toList());
            userValue = allValue = valueList.stream().map(va -> {
                UserEntity userEntity = this.userApi.getInfo(va);
                return Objects.nonNull(userEntity) ? userEntity.getRealName() + "/" + userEntity.getAccount() : va;
            }).collect(Collectors.joining(","));
        }
        return userValue;
    }

    private String getRoleValue(String modelValue) {
        String value;
        if (OnlinePublicUtils.getMultiple(modelValue, MultipleControlEnum.MULTIPLE_JSON_TWO.getMultipleChar()).booleanValue()) {
            String[][] prgArray = (String[][])JsonUtil.getJsonToBean((String)modelValue, String[][].class);
            ArrayList<String> addList = new ArrayList<String>();
            for (String[] prgData : prgArray) {
                ArrayList<String> adList = new ArrayList<String>();
                for (String s : prgData) {
                    RoleEntity info = this.roleApi.getInfo(s);
                    adList.add(Objects.nonNull(info) ? info.getFullName() : "");
                }
                String porData = adList.stream().collect(Collectors.joining("/"));
                addList.add(porData);
            }
            value = String.join((CharSequence)";", addList);
        } else {
            String allValue;
            List valueList = OnlinePublicUtils.getMultiple(modelValue, MultipleControlEnum.MULTIPLE_JSON_ONE.getMultipleChar()) != false ? JsonUtil.getJsonToList((String)modelValue, String.class) : Stream.of(modelValue.split(",")).collect(Collectors.toList());
            value = allValue = valueList.stream().map(va -> {
                RoleEntity userEntity = this.roleApi.getInfo(va);
                return Objects.nonNull(userEntity) ? userEntity.getFullName() : va;
            }).collect(Collectors.joining(","));
        }
        return value;
    }

    private String getGroupValue(String modelValue) {
        String value;
        if (OnlinePublicUtils.getMultiple(modelValue, MultipleControlEnum.MULTIPLE_JSON_TWO.getMultipleChar()).booleanValue()) {
            String[][] prgArray = (String[][])JsonUtil.getJsonToBean((String)modelValue, String[][].class);
            ArrayList<String> addList = new ArrayList<String>();
            for (String[] prgData : prgArray) {
                ArrayList<String> adList = new ArrayList<String>();
                for (String s : prgData) {
                    GroupEntity info = this.groupApi.getInfo(s);
                    adList.add(Objects.nonNull(info) ? info.getFullName() : "");
                }
                String porData = adList.stream().collect(Collectors.joining("/"));
                addList.add(porData);
            }
            value = String.join((CharSequence)";", addList);
        } else {
            String allValue;
            List valueList = OnlinePublicUtils.getMultiple(modelValue, MultipleControlEnum.MULTIPLE_JSON_ONE.getMultipleChar()) != false ? JsonUtil.getJsonToList((String)modelValue, String.class) : Stream.of(modelValue.split(",")).collect(Collectors.toList());
            value = allValue = valueList.stream().map(va -> {
                GroupEntity info = this.groupApi.getInfo(va);
                return Objects.nonNull(info) ? info.getFullName() : va;
            }).collect(Collectors.joining(","));
        }
        return value;
    }
}

