/*
 * Decompiled with CFR 0.152.
 */
package jnpf.onlinedev.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import jnpf.base.entity.SuperBaseEntity;
import jnpf.base.service.SuperServiceImpl;
import jnpf.onlinedev.entity.VisualPersonalEntity;
import jnpf.onlinedev.mapper.VisualPersonalMapper;
import jnpf.onlinedev.model.DataInfoVO;
import jnpf.onlinedev.model.personalList.VisualPersonalInfo;
import jnpf.onlinedev.model.personalList.VisualPersonalVo;
import jnpf.onlinedev.service.VisualPersonalService;
import jnpf.util.JsonUtil;
import jnpf.util.StringUtil;
import jnpf.util.UserProvider;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class VisualPersonalServiceImpl
extends SuperServiceImpl<VisualPersonalMapper, VisualPersonalEntity>
implements VisualPersonalService {
    @Override
    public List<VisualPersonalEntity> getList(String menuId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(VisualPersonalEntity::getMenuId, (Object)menuId);
        queryWrapper.lambda().eq(SuperBaseEntity.SuperCBaseEntity::getCreatorUserId, (Object)UserProvider.getUser().getUserId());
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<VisualPersonalVo> getListVo(String menuId) {
        ArrayList<VisualPersonalVo> listVo = new ArrayList<VisualPersonalVo>();
        List<VisualPersonalEntity> list = this.getList(menuId);
        VisualPersonalEntity defaultEntity = list.stream().filter(t -> Objects.equals(1, t.getStatus())).findFirst().orElse(null);
        Integer status = ObjectUtil.isEmpty((Object)defaultEntity) ? 1 : 0;
        VisualPersonalVo vo = new VisualPersonalVo();
        vo.setId("systemId");
        vo.setFullName("\u7cfb\u7edf\u89c6\u56fe");
        vo.setStatus(status);
        vo.setType(Integer.valueOf(0));
        listVo.add(vo);
        for (VisualPersonalEntity item : list) {
            VisualPersonalVo personalVo = (VisualPersonalVo)JsonUtil.getJsonToBean((Object)item, VisualPersonalVo.class);
            listVo.add(personalVo);
        }
        return listVo;
    }

    @Override
    public VisualPersonalInfo getInfo(String id) {
        VisualPersonalEntity entity;
        VisualPersonalInfo info = null;
        if (ObjectUtil.isNotEmpty((Object)id) && !"systemId".equals(id) && (entity = (VisualPersonalEntity)this.getById((Serializable)((Object)id))) != null) {
            info = (VisualPersonalInfo)JsonUtil.getJsonToBean((Object)entity, VisualPersonalInfo.class);
        }
        return info;
    }

    @Override
    public boolean isExistByFullName(String fullName, String id, String menuId) {
        if ("\u7cfb\u7edf\u89c6\u56fe".equals(fullName)) {
            return true;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(VisualPersonalEntity::getFullName, (Object)fullName);
        if (!StringUtils.isEmpty((CharSequence)id)) {
            queryWrapper.lambda().ne(SuperBaseEntity.SuperIBaseEntity::getId, (Object)id);
        }
        queryWrapper.lambda().eq(VisualPersonalEntity::getMenuId, (Object)menuId);
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public void setDataInfoVO(String menuId, DataInfoVO dataInfoVO) {
        List<Object> listVo = StringUtil.isNotEmpty((String)menuId) ? this.getListVo(menuId) : new ArrayList();
        dataInfoVO.setPersonalList(listVo);
        VisualPersonalVo personalVo = listVo.stream().filter(t -> Objects.equals(1, t.getStatus())).findFirst().orElse(null);
        String id = ObjectUtil.isEmpty((Object)personalVo) ? null : personalVo.getId();
        VisualPersonalInfo info = this.getInfo(id);
        dataInfoVO.setDefaultView(info);
    }
}

