/*
 * Decompiled with CFR 0.152.
 */
package jnpf.onlinedev.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import jnpf.base.UserInfo;
import jnpf.base.entity.ModuleEntity;
import jnpf.base.entity.VisualdevShortLinkEntity;
import jnpf.base.mapper.FlowFormDataMapper;
import jnpf.base.model.ColumnDataModel;
import jnpf.base.model.Template6.ColumnListField;
import jnpf.base.model.VisualDevJsonModel;
import jnpf.base.model.module.PropertyJsonModel;
import jnpf.base.service.DbLinkService;
import jnpf.base.service.ModuleService;
import jnpf.base.service.SuperServiceImpl;
import jnpf.base.service.VisualdevShortLinkService;
import jnpf.base.util.FlowFormDataUtil;
import jnpf.base.util.FormPublicUtils;
import jnpf.database.model.entity.DbLinkEntity;
import jnpf.database.model.interfaces.DbSourceOrDbLink;
import jnpf.database.model.superQuery.ConditionJsonModel;
import jnpf.database.model.superQuery.SuperJsonModel;
import jnpf.database.model.superQuery.SuperQueryJsonModel;
import jnpf.database.util.ConnUtil;
import jnpf.database.util.DynamicDataSourceUtil;
import jnpf.emnus.SearchMethodEnum;
import jnpf.exception.WorkFlowException;
import jnpf.model.OnlineDevData;
import jnpf.model.visualJson.FieLdsModel;
import jnpf.model.visualJson.FormCloumnUtil;
import jnpf.model.visualJson.FormDataModel;
import jnpf.model.visualJson.TableFields;
import jnpf.model.visualJson.TableModel;
import jnpf.model.visualJson.analysis.FormAllModel;
import jnpf.model.visualJson.analysis.FormColumnModel;
import jnpf.model.visualJson.analysis.FormColumnTableModel;
import jnpf.model.visualJson.analysis.FormEnum;
import jnpf.model.visualJson.analysis.RecursionForm;
import jnpf.onlinedev.entity.VisualdevModelDataEntity;
import jnpf.onlinedev.mapper.VisualdevModelDataMapper;
import jnpf.onlinedev.model.OnlineDevListModel.VisualColumnSearchVO;
import jnpf.onlinedev.model.PaginationModel;
import jnpf.onlinedev.service.VisualDevListService;
import jnpf.onlinedev.util.onlineDevUtil.OnlineDevListUtils;
import jnpf.onlinedev.util.onlineDevUtil.OnlineProductSqlUtils;
import jnpf.onlinedev.util.onlineDevUtil.OnlinePublicUtils;
import jnpf.onlinedev.util.onlineDevUtil.OnlineSwapDataUtils;
import jnpf.onlinedev.util.onlineDevUtil.RelationFormUtils;
import jnpf.permission.model.authorize.OnlineDynamicSqlModel;
import jnpf.permission.service.AuthorizeService;
import jnpf.util.JsonUtil;
import jnpf.util.PageUtil;
import jnpf.util.RandomUtil;
import jnpf.util.StringUtil;
import jnpf.util.TableFeildsEnum;
import jnpf.util.UserProvider;
import jnpf.util.visiual.JnpfKeyConsts;
import jnpf.workflow.service.TemplateApi;
import org.apache.commons.collections4.CollectionUtils;
import org.mybatis.dynamic.sql.AndOrCriteriaGroup;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.SortSpecification;
import org.mybatis.dynamic.sql.SqlBuilder;
import org.mybatis.dynamic.sql.SqlColumn;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.render.RenderingStrategies;
import org.mybatis.dynamic.sql.select.QueryExpressionDSL;
import org.mybatis.dynamic.sql.select.SelectModel;
import org.mybatis.dynamic.sql.select.join.EqualTo;
import org.mybatis.dynamic.sql.select.join.JoinCondition;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.mybatis.dynamic.sql.util.Buildable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VisualDevListServiceImpl
extends SuperServiceImpl<VisualdevModelDataMapper, VisualdevModelDataEntity>
implements VisualDevListService {
    @Autowired
    private DbLinkService dblinkService;
    @Autowired
    private OnlineSwapDataUtils onlineSwapDataUtils;
    @Autowired
    private FlowFormDataUtil flowFormDataUtil;
    @Autowired
    private FlowFormDataMapper flowFormDataMapper;
    @Autowired
    private VisualdevShortLinkService visualdevShortLinkService;
    @Autowired
    private TemplateApi templateApi;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private AuthorizeService authorizeService;

    @Override
    public List<Map<String, Object>> getDataList(VisualDevJsonModel visualDevJsonModel, PaginationModel paginationModel) throws WorkFlowException {
        List<Map<String, Object>> realList = new ArrayList<Map<String, Object>>();
        ColumnDataModel columnDataModel = visualDevJsonModel.getColumnData();
        FormDataModel formDataModel = visualDevJsonModel.getFormData();
        List fieLdsModels = JsonUtil.getJsonToList((String)formDataModel.getFields(), FieLdsModel.class);
        List visualTables = visualDevJsonModel.getVisualTables();
        RecursionForm recursionForm = new RecursionForm(fieLdsModels, visualTables);
        ArrayList<FormAllModel> formAllModel = new ArrayList<FormAllModel>();
        FormCloumnUtil.recursionForm((RecursionForm)recursionForm, formAllModel);
        UserInfo userInfo = UserProvider.getUser();
        boolean enableFlow = false;
        if (ObjectUtil.isNotEmpty((Object)paginationModel.getMenuId())) {
            String menuId = paginationModel.getMenuId();
            ModuleEntity info = this.moduleService.getInfo(menuId);
            enableFlow = Objects.equals(info.getType(), 9);
            visualDevJsonModel.setEnableFlow(enableFlow);
            if (enableFlow) {
                PropertyJsonModel model = (PropertyJsonModel)JsonUtil.getJsonToBean((String)info.getPropertyJson(), PropertyJsonModel.class);
                List flowVersionIds = this.templateApi.getFlowIdsByTemplateId(model.getModuleId());
                visualDevJsonModel.setFlowId(model.getModuleId());
                visualDevJsonModel.setFlowVersionIds(flowVersionIds);
            }
        }
        if (visualTables.size() > 0) {
            OnlineProductSqlUtils.queryList(formAllModel, visualDevJsonModel, paginationModel);
            realList = this.getListWithTable(visualDevJsonModel, paginationModel, userInfo, null);
        }
        if (realList.size() < 1) {
            return realList;
        }
        boolean inlineEdit = StringUtil.isNotEmpty((String)paginationModel.getExtraQueryJson()) ? false : columnDataModel.getType() != null && columnDataModel.getType() == 4;
        realList.forEach(item -> item.put(columnDataModel.getParentField() + "_id", item.get(columnDataModel.getParentField())));
        ArrayList<FieLdsModel> fields = new ArrayList<FieLdsModel>();
        OnlinePublicUtils.recursionFields(fields, fieLdsModels);
        visualDevJsonModel.setFormListModels(fields);
        realList = this.onlineSwapDataUtils.getSwapList(realList, fields, visualDevJsonModel.getId(), inlineEdit);
        String pkeyId = visualDevJsonModel.getPkeyId();
        columnDataModel.setSubField(pkeyId);
        if (enableFlow) {
            this.onlineSwapDataUtils.getFlowStatus(realList);
        }
        return realList;
    }

    @Override
    public List<Map<String, Object>> getDataListLink(VisualDevJsonModel visualDevJsonModel, PaginationModel paginationModel) throws WorkFlowException {
        VisualdevShortLinkEntity shortLinkEnt = (VisualdevShortLinkEntity)this.visualdevShortLinkService.getById((Serializable)((Object)visualDevJsonModel.getId()));
        List listCondition = StringUtil.isNotEmpty((String)shortLinkEnt.getColumnCondition()) ? JsonUtil.getJsonToList((String)shortLinkEnt.getColumnCondition(), VisualColumnSearchVO.class) : new ArrayList();
        List listFields = StringUtil.isNotEmpty((String)shortLinkEnt.getColumnCondition()) ? JsonUtil.getJsonToList((String)shortLinkEnt.getColumnText(), FieLdsModel.class) : new ArrayList();
        visualDevJsonModel.setFormListModels(listFields);
        visualDevJsonModel.setIsLinkList(Boolean.valueOf(true));
        FormDataModel formDataModel = visualDevJsonModel.getFormData();
        List visualTables = visualDevJsonModel.getVisualTables();
        UserInfo userInfo = UserProvider.getUser();
        ArrayList isBetween = new ArrayList(){
            {
                this.add("datePicker");
                this.add("timePicker");
                this.add("inputNumber");
                this.add("rate");
                this.add("slider");
            }
        };
        Iterator iterator = listCondition.iterator();
        while (iterator.hasNext()) {
            VisualColumnSearchVO searchVO;
            String jnpfKey = (searchVO = (VisualColumnSearchVO)iterator.next()).getConfig().getJnpfKey();
            searchVO.setSearchType(isBetween.contains(jnpfKey) ? "3" : "2");
        }
        String menuId = paginationModel.getMenuId();
        ColumnDataModel columnDataModel = new ColumnDataModel();
        List list = JsonUtil.getJsonToList((String)shortLinkEnt.getColumnText(), ColumnListField.class);
        columnDataModel.setColumnList(JsonUtil.getListToJsonArray((List)list).toJSONString());
        columnDataModel.setSearchList(JsonUtil.getListToJsonArray(listCondition).toJSONString());
        columnDataModel.setType(Integer.valueOf(1));
        visualDevJsonModel.setColumnData(columnDataModel);
        List fieLdsModels = JsonUtil.getJsonToList((String)formDataModel.getFields(), FieLdsModel.class);
        RecursionForm recursionForm = new RecursionForm(fieLdsModels, visualTables);
        ArrayList<FormAllModel> formAllModel = new ArrayList<FormAllModel>();
        FormCloumnUtil.recursionForm((RecursionForm)recursionForm, formAllModel);
        OnlineProductSqlUtils.queryList(formAllModel, visualDevJsonModel, paginationModel);
        List<Map<String, Object>> realList = this.getListWithTable(visualDevJsonModel, paginationModel, userInfo, null);
        if (realList.size() < 1) {
            return realList;
        }
        ArrayList<FieLdsModel> fields = new ArrayList<FieLdsModel>();
        OnlinePublicUtils.recursionFields(fields, fieLdsModels);
        visualDevJsonModel.setFormListModels(fields);
        realList = this.onlineSwapDataUtils.getSwapList(realList, fields, visualDevJsonModel.getId(), false);
        return realList;
    }

    @Override
    public List<Map<String, Object>> getList(List<Map<String, Object>> noSwapDataList, List<VisualColumnSearchVO> searchVOList, PaginationModel paginationModel) {
        if (searchVOList.size() > 0) {
            noSwapDataList = OnlineDevListUtils.getNoSwapList(noSwapDataList, searchVOList);
        }
        if (noSwapDataList.size() > 0) {
            if (StringUtil.isNotEmpty((String)paginationModel.getSidx())) {
                noSwapDataList.sort((o1, o2) -> {
                    Map i1 = o1;
                    Map i2 = o2;
                    String s1 = String.valueOf(i1.get(paginationModel.getSidx()));
                    String s2 = String.valueOf(i2.get(paginationModel.getSidx()));
                    if ("desc".equalsIgnoreCase(paginationModel.getSort())) {
                        return s2.compareTo(s1);
                    }
                    return s1.compareTo(s2);
                });
            }
            long total = noSwapDataList.size();
            noSwapDataList = PageUtil.getListPage((int)((int)paginationModel.getCurrentPage()), (int)((int)paginationModel.getPageSize()), noSwapDataList);
            noSwapDataList = paginationModel.setData(noSwapDataList, total);
        }
        return noSwapDataList;
    }

    @Override
    public List<Map<String, Object>> getWithoutTableData(String modelId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(VisualdevModelDataEntity::getVisualDevId, (Object)modelId);
        List list = this.list((Wrapper)queryWrapper);
        List<Map<String, Object>> dataVoList = list.parallelStream().map(t -> {
            Map dataMap = JsonUtil.stringToMap((String)t.getData());
            dataMap.put("id", t.getId());
            return dataMap;
        }).collect(Collectors.toList());
        return dataVoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Map<String, Object>> getListWithTable(VisualDevJsonModel visualDevJsonModel, PaginationModel paginationModel, UserInfo userInfo, List<String> columnPropList) {
        columnDataModel = visualDevJsonModel.getColumnData();
        dataList = new ArrayList<Map<String, Object>>();
        ruleQuery = visualDevJsonModel.getRuleQuery();
        superQuery = visualDevJsonModel.getSuperQuery();
        query = visualDevJsonModel.getQuery();
        authorizeListAll = visualDevJsonModel.getAuthorize();
        keyQuery = visualDevJsonModel.getKeyQuery();
        extraQuery = visualDevJsonModel.getExtraQuery();
        linkEntity = this.dblinkService.getInfo(visualDevJsonModel.getDbLinkId());
        userStanding = this.authorizeService.getUserCurrentStanding(userInfo.getUserId(), Integer.valueOf(2));
        try {
            block53: {
                block54: {
                    DynamicDataSourceUtil.switchToDataSource((DbLinkEntity)linkEntity);
                    connection = ConnUtil.getConnOrDefault((DbSourceOrDbLink)linkEntity);
                    databaseProductName = connection.getMetaData().getDatabaseProductName().trim();
                    tableModelList = visualDevJsonModel.getVisualTables();
                    mainTable = tableModelList.stream().filter((Predicate<TableModel>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getListWithTable$3(jnpf.model.visualJson.TableModel ), (Ljnpf/model/visualJson/TableModel;)Z)()).findFirst().orElse(null);
                    modelList = JsonUtil.getJsonToList((String)columnDataModel.getColumnList(), ColumnListField.class);
                    formData = visualDevJsonModel.getFormData();
                    jsonToList = JsonUtil.getJsonToList((String)formData.getFields(), FieLdsModel.class);
                    allFieLds = new ArrayList<FieLdsModel>();
                    OnlinePublicUtils.recursionFields(allFieLds, jsonToList);
                    tableFieldAndTableName = new HashMap<String, String>(8);
                    tableNameAndTableField = new HashMap<K, V>(8);
                    allFieLds.stream().filter((Predicate<FieLdsModel>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getListWithTable$4(jnpf.model.visualJson.FieLdsModel ), (Ljnpf/model/visualJson/FieLdsModel;)Z)()).forEach((Consumer<FieLdsModel>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$getListWithTable$5(java.util.Map java.util.Map jnpf.model.visualJson.FieLdsModel ), (Ljnpf/model/visualJson/FieLdsModel;)V)(tableFieldAndTableName, tableNameAndTableField));
                    allTableName = OnlinePublicUtils.getAllTableName(modelList, new ArrayList(){
                        {
                            this.add(ruleQuery);
                            this.add(superQuery);
                            this.add(query);
                            this.addAll(authorizeListAll);
                        }
                    }, tableFieldAndTableName);
                    reg = "^[jnpf_]\\S*_jnpf\\S*";
                    pkeyId = this.flowFormDataUtil.getKey(mainTable, databaseProductName);
                    visualDevJsonModel.setPkeyId(pkeyId);
                    collect = new ArrayList<String>();
                    if (columnPropList != null) {
                        collect.addAll(columnPropList);
                    } else {
                        collect.addAll((Collection)modelList.stream().map((Function<ColumnListField, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getListWithTable$6(jnpf.base.model.Template6.ColumnListField ), (Ljnpf/base/model/Template6/ColumnListField;)Ljava/lang/String;)()).collect(Collectors.toList()));
                    }
                    if (OnlineDevData.COLUMNTYPE_FIVE.equals(columnDataModel.getType()) && !collect.contains(columnDataModel.getParentField())) {
                        collect.add(columnDataModel.getParentField());
                    }
                    if (StringUtil.isNotEmpty((String)paginationModel.getSidx())) {
                        split = paginationModel.getSidx().split(",");
                        for (String s : split) {
                            filedName = "";
                            filedName = s.startsWith("-") != false ? s.substring(1) : s;
                            if (collect.contains(filedName)) continue;
                            collect.add((String)filedName);
                        }
                    }
                    sqlModelList = new ArrayList<OnlineDynamicSqlModel>();
                    for (TableModel model : tableModelList) {
                        sqlModel = new OnlineDynamicSqlModel();
                        sqlModel.setSqlTable(SqlTable.of((String)model.getTable()));
                        sqlModel.setTableName(model.getTable());
                        if (model.getTypeId().equals("1")) {
                            sqlModel.setMain(true);
                        } else {
                            sqlModel.setForeign(model.getTableField());
                            sqlModel.setRelationKey(model.getRelationField());
                            sqlModel.setMain(false);
                        }
                        sqlModelList.add(sqlModel);
                    }
                    OnlineProductSqlUtils.getColumnListSql(sqlModelList, visualDevJsonModel, collect, linkEntity);
                    mainSqlModel = sqlModelList.stream().filter((Predicate<OnlineDynamicSqlModel>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isMain(), (Ljnpf/permission/model/authorize/OnlineDynamicSqlModel;)Z)()).findFirst().orElse(null);
                    dycList = sqlModelList.stream().filter((Predicate<OnlineDynamicSqlModel>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getListWithTable$7(jnpf.permission.model.authorize.OnlineDynamicSqlModel ), (Ljnpf/permission/model/authorize/OnlineDynamicSqlModel;)Z)()).collect(Collectors.toList());
                    sqlColumns = new ArrayList<E>();
                    aliasMap = new HashMap<String, String>();
                    isOracle = databaseProductName.equalsIgnoreCase("oracle");
                    isDm = databaseProductName.equalsIgnoreCase("DM DBMS");
                    for (OnlineDynamicSqlModel dynamicSqlModel : sqlModelList) {
                        basicColumns = Optional.ofNullable(dynamicSqlModel.getColumns()).orElse(new ArrayList<E>());
                        if (isOracle || isDm) {
                            for (i = 0; i < basicColumns.size(); ++i) {
                                item = (BasicColumn)basicColumns.get(i);
                                alias = item.alias().orElse(null);
                                if (!StringUtil.isNotEmpty((String)alias)) continue;
                                aliasNewName = "A" + RandomUtil.uuId();
                                aliasMap.put(aliasNewName, alias);
                                basicColumns.set(i, item.as(aliasNewName));
                            }
                        }
                        sqlColumns.addAll(basicColumns);
                    }
                    from = SqlBuilder.select(sqlColumns).from(mainSqlModel.getSqlTable());
                    subFrom = SqlBuilder.select((BasicColumn[])new BasicColumn[]{mainSqlModel.getSqlTable().column(pkeyId)}).from(mainSqlModel.getSqlTable());
                    tableFieldGroup = new HashMap<K, V>(8);
                    allFieLds.forEach((Consumer<FieLdsModel>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$getListWithTable$9(java.util.Map jnpf.model.visualJson.FieLdsModel ), (Ljnpf/model/visualJson/FieLdsModel;)V)(tableFieldGroup));
                    subSqlTableMap = new HashMap<K, V>();
                    if (dycList.size() > 0) {
                        for (OnlineDynamicSqlModel sqlModel : dycList) {
                            if (!allTableName.contains(sqlModel.getTableName())) continue;
                            relationKey = sqlModel.getRelationKey();
                            relationKeyTypeString = false;
                            for (TableModel item : tableModelList) {
                                if (!item.getTable().equals(sqlModel.getTableName())) continue;
                                foreign = sqlModel.getForeign();
                                thisfield = item.getFields().stream().filter((Predicate<TableFields>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getListWithTable$10(java.lang.String jnpf.model.visualJson.TableFields ), (Ljnpf/model/visualJson/TableFields;)Z)((String)foreign)).findFirst().orElse(null);
                                if (thisfield == null) continue;
                                relationKeyTypeString = thisfield.getDataType().toLowerCase().contains("varchar");
                            }
                            if (Objects.equals(formData.getPrimaryKeyPolicy(), 2) && "PostgreSQL".equalsIgnoreCase(databaseProductName) && relationKeyTypeString) {
                                relationKey = (String)relationKey + "::varchar";
                            }
                            if (!tableNameAndTableField.containsKey(sqlModel.getTableName())) {
                                from.leftJoin(sqlModel.getSqlTable()).on((BasicColumn)sqlModel.getSqlTable().column(sqlModel.getForeign()), (JoinCondition)new EqualTo((BasicColumn)mainSqlModel.getSqlTable().column((String)relationKey)));
                            }
                            subFrom.leftJoin(sqlModel.getSqlTable()).on((BasicColumn)sqlModel.getSqlTable().column(sqlModel.getForeign()), (JoinCondition)new EqualTo((BasicColumn)mainSqlModel.getSqlTable().column((String)relationKey)));
                            tableName = sqlModel.getTableName();
                            fieldList = (List)tableFieldGroup.get(tableName);
                            if (fieldList == null) continue;
                            fieldList.forEach((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$getListWithTable$11(java.util.Map jnpf.permission.model.authorize.OnlineDynamicSqlModel java.lang.String ), (Ljava/lang/String;)V)(subSqlTableMap, (OnlineDynamicSqlModel)sqlModel));
                        }
                    }
                    where = from.where();
                    subWhere = subFrom.where();
                    if (visualDevJsonModel.getFormData().getLogicalDelete().booleanValue()) {
                        subWhere.and((BindableColumn)mainSqlModel.getSqlTable().column(TableFeildsEnum.DELETEMARK.getField()), (VisitableCondition)SqlBuilder.isNull(), new AndOrCriteriaGroup[0]);
                    }
                    flowVersionIds = visualDevJsonModel.getFlowVersionIds();
                    if (visualDevJsonModel.isEnableFlow() && flowVersionIds.size() > 0) {
                        subWhere.and((BindableColumn)mainSqlModel.getSqlTable().column(TableFeildsEnum.FLOWID.getField()), (VisitableCondition)SqlBuilder.isIn((Collection)flowVersionIds), new AndOrCriteriaGroup[0]);
                    } else {
                        subWhere.and((BindableColumn)mainSqlModel.getSqlTable().column(TableFeildsEnum.FLOWID.getField()), (VisitableCondition)SqlBuilder.isNull(), new AndOrCriteriaGroup[0]);
                    }
                    OnlineProductSqlUtils.getSuperSql(subWhere, extraQuery, sqlModelList, databaseProductName, null, false);
                    OnlineProductSqlUtils.getSuperSql(subWhere, query, sqlModelList, databaseProductName, null, false);
                    OnlineProductSqlUtils.getSuperSql(subWhere, superQuery, sqlModelList, databaseProductName, null, false);
                    OnlineProductSqlUtils.getSuperSql(subWhere, ruleQuery, sqlModelList, databaseProductName, null, false);
                    OnlineProductSqlUtils.getSuperSql(subWhere, keyQuery, sqlModelList, databaseProductName, null, false);
                    if (columnDataModel.getUseDataPermission() != null && columnDataModel.getUseDataPermission().booleanValue() && !userInfo.getIsAdministrator().booleanValue() && !userStanding) {
                        if (authorizeListAll.size() == 0) {
                            relationKeyTypeString = new ArrayList<Map<String, Object>>();
                            return relationKeyTypeString;
                        }
                        OnlineProductSqlUtils.getSuperSql(subWhere, authorizeListAll, sqlModelList, databaseProductName, null);
                    }
                    if ((count = this.flowFormDataMapper.count(renderCount = ((SelectModel)(countSelect = SqlBuilder.select((BasicColumn[])new BasicColumn[]{countColumn /* !! */  = dycList.size() > 0 ? SqlBuilder.countDistinct((BasicColumn)mainSqlModel.getSqlTable().column(pkeyId)) : SqlBuilder.count((BasicColumn)mainSqlModel.getSqlTable().column(pkeyId))}).from((Buildable)subWhere, "tmp").where()).build()).render(RenderingStrategies.MYBATIS3))) == 0L) {
                        paginationModel.setTotal(0L);
                        var48_58 = new ArrayList<Map<String, Object>>();
                        return var48_58;
                    }
                    if (!StringUtil.isNotEmpty((String)paginationModel.getSidx())) {
                        where.orderBy(new SortSpecification[]{SqlBuilder.sortColumn((String)mainTable.getTable(), (SqlColumn)SqlTable.of((String)mainTable.getTable()).column(pkeyId)).descending()});
                    } else {
                        split = paginationModel.getSidx().split(",");
                        sidxList = new ArrayList<SortSpecification>();
                        for (String sidx : split) {
                            if (sidx.toLowerCase().contains("_jnpf_") || sidx.toLowerCase().contains("tablefield")) continue;
                            sortSpecification = sidx.startsWith("-") != false ? SqlBuilder.sortColumn((String)mainTable.getTable(), (SqlColumn)SqlTable.of((String)mainTable.getTable()).column(sidx.substring(1))).descending() : SqlBuilder.sortColumn((String)mainTable.getTable(), (SqlColumn)SqlTable.of((String)mainTable.getTable()).column(sidx));
                            sidxList.add(sortSpecification);
                        }
                        where.orderBy(sidxList);
                    }
                    v0 = hasPage = (paginationModel.getDataType() == null || "0".equals(paginationModel.getDataType()) != false) && Objects.equals(columnDataModel.getType(), 5) == false && Objects.equals(columnDataModel.getType(), 3) == false;
                    if (hasPage) {
                        PageHelper.startPage((int)((int)paginationModel.getCurrentPage()), (int)((int)paginationModel.getPageSize()), (boolean)false);
                    }
                    where.and((BindableColumn)SqlTable.of((String)mainTable.getTable()).column(pkeyId), (VisitableCondition)SqlBuilder.isIn((Buildable)subWhere), new AndOrCriteriaGroup[0]);
                    render = ((SelectModel)where.build()).render(RenderingStrategies.MYBATIS3);
                    dataList = this.flowFormDataMapper.selectManyMappedRows(render);
                    finalPkeyId = pkeyId;
                    idStringList = dataList.stream().map((Function<Map, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getListWithTable$12(java.lang.String java.util.Map ), (Ljava/util/Map;)Ljava/lang/Object;)((String)finalPkeyId)).distinct().collect(Collectors.toList());
                    if (idStringList.size() <= 0) {
                        var52_67 = new ArrayList<Map<String, Object>>();
                        return var52_67;
                    }
                    tableFields = collect.stream().filter((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getListWithTable$13(java.lang.String ), (Ljava/lang/String;)Z)()).collect(Collectors.toList());
                    childTableModels = tableModelList.stream().filter((Predicate<TableModel>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getListWithTable$14(jnpf.model.visualJson.TableModel ), (Ljnpf/model/visualJson/TableModel;)Z)()).collect(Collectors.toList());
                    tableMap = tableFields.stream().collect(Collectors.groupingBy((Function<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getListWithTable$15(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)()));
                    var55_70 = childTableModels.iterator();
lbl177:
                    // 2 sources

                    while (true) {
                        if (var55_70.hasNext()) {
                            tableModel = (TableModel)var55_70.next();
                            table = tableModel.getTable();
                            if (!allTableName.contains(table)) continue;
                            tableField = (String)tableNameAndTableField.get(table);
                            childPrimKey = this.flowFormDataUtil.getKey(tableModel, databaseProductName);
                            fogID = tableModel.getTableField();
                            mainPrimKey = tableModel.getRelationField();
                            fogValueList = dataList.stream().map((Function<Map, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getListWithTable$16(java.lang.String java.util.Map ), (Ljava/util/Map;)Ljava/lang/Object;)((String)mainPrimKey)).distinct().collect(Collectors.toList());
                            fogIdField = tableModel.getFields().stream().filter((Predicate<TableFields>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getListWithTable$17(java.lang.String jnpf.model.visualJson.TableFields ), (Ljnpf/model/visualJson/TableFields;)Z)((String)fogID)).findFirst().orElse(null);
                            v1 = fogIdTypeString = Objects.nonNull(fogIdField) != false ? fogIdField.getDataType().toLowerCase().contains("varchar") : false;
                            if (fogIdTypeString) {
                                idStringList = idStringList.stream().map((Function<Object, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getListWithTable$18(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/String;)()).collect(Collectors.toList());
                            }
                            if ((childFields = tableMap.get(tableField)) == null) continue;
                            onlineDynamicSqlModel = sqlModelList.stream().filter((Predicate<OnlineDynamicSqlModel>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getListWithTable$19(java.lang.String jnpf.permission.model.authorize.OnlineDynamicSqlModel ), (Ljnpf/permission/model/authorize/OnlineDynamicSqlModel;)Z)((String)table)).findFirst().orElse(null);
                            childSqlTable = onlineDynamicSqlModel.getSqlTable();
                            childSqlColumns = new ArrayList<SqlColumn>();
                            for (String var70_87 : childFields) {
                                childF = var70_87.substring(var70_87.lastIndexOf("-") + 1);
                                column = childSqlTable.column(childF);
                                childSqlColumns.add(column);
                            }
                            childSqlColumns.add(childSqlTable.column(childPrimKey));
                            childSqlColumns.add(childSqlTable.column(fogID));
                            childFrom = SqlBuilder.select(childSqlColumns).from(mainSqlModel.getSqlTable());
                            if (dycList.size() <= 0) break block53;
                            var70_88 = dycList.iterator();
                            break block54;
                        }
                        dataList = FormPublicUtils.addIdToList(dataList, (String)pkeyId);
                        this.setAliasKey(dataList, aliasMap);
                        paginationModel.setTotal(count);
                        return dataList;
                    }
                    finally {
                        if (Collections.singletonList(connection).get(0) != null) {
                            connection.close();
                        }
                    }
                }
                while (var70_88.hasNext()) {
                    sqlModel = (OnlineDynamicSqlModel)var70_88.next();
                    relationKey = sqlModel.getRelationKey();
                    relationKeyTypeString = false;
                    for (Object item : tableModelList) {
                        if (!item.getTable().equals(sqlModel.getTableName())) continue;
                        foreign = sqlModel.getForeign();
                        thisfield = item.getFields().stream().filter((Predicate<TableFields>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getListWithTable$20(java.lang.String jnpf.model.visualJson.TableFields ), (Ljnpf/model/visualJson/TableFields;)Z)((String)foreign)).findFirst().orElse(null);
                        if (thisfield == null) continue;
                        relationKeyTypeString = thisfield.getDataType().toLowerCase().contains("varchar");
                    }
                    if (Objects.equals(formData.getPrimaryKeyPolicy(), 2) && "PostgreSQL".equalsIgnoreCase(databaseProductName) && relationKeyTypeString) {
                        relationKey = (String)relationKey + "::varchar";
                    }
                    childFrom.leftJoin(sqlModel.getSqlTable()).on((BasicColumn)sqlModel.getSqlTable().column(sqlModel.getForeign()), (JoinCondition)new EqualTo((BasicColumn)mainSqlModel.getSqlTable().column((String)relationKey)));
                }
            }
            var70_85 = childFrom.where();
            var70_85.and((BindableColumn)childSqlTable.column(fogID), (VisitableCondition)SqlBuilder.isIn(fogValueList), new AndOrCriteriaGroup[0]);
            OnlineProductSqlUtils.getSuperSql(var70_85, query, sqlModelList, databaseProductName, null, false);
            OnlineProductSqlUtils.getSuperSql(var70_85, superQuery, sqlModelList, databaseProductName, null, false);
            OnlineProductSqlUtils.getSuperSql(var70_85, ruleQuery, sqlModelList, databaseProductName, null, false);
            OnlineProductSqlUtils.getSuperSql(var70_85, keyQuery, sqlModelList, databaseProductName, null, false);
            if (columnDataModel.getUseDataPermission() != null && columnDataModel.getUseDataPermission().booleanValue() && !userInfo.getIsAdministrator().booleanValue() && !userStanding) {
                OnlineProductSqlUtils.getSuperSql(var70_85, authorizeListAll, sqlModelList, databaseProductName, null);
            }
            childRender = ((SelectModel)var70_85.build()).render(RenderingStrategies.MYBATIS3);
            mapList = this.flowFormDataMapper.selectManyMappedRows(childRender);
            dictinctKey = new ArrayList<V>();
            newList = new ArrayList<Map>();
            item = mapList.iterator();
            while (item.hasNext()) {
                item = (Map)item.next();
                o = item.get(childPrimKey);
                if (!dictinctKey.contains(o)) {
                    newList.add(item);
                    dictinctKey.add(o);
                }
                item.put("id", o);
            }
            idMap = newList.stream().collect(Collectors.groupingBy((Function<Map, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getListWithTable$21(java.lang.String java.util.Map ), (Ljava/util/Map;)Ljava/lang/String;)((String)fogID)));
            var76_96 = dataList.iterator();
            while (true) {
                if (var76_96.hasNext()) ** break;
                ** continue;
                m = var76_96.next();
                if (!ObjectUtil.isNotEmpty((Object)m.get(mainPrimKey))) continue;
                s = m.get(mainPrimKey).toString();
                valueMap = new HashMap<String, List<Map>>();
                valueMap.put(tableField, idMap.get(s));
                m.putAll(valueMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return dataList;
        }
        finally {
            DynamicDataSourceUtil.clearSwitchDataSource();
        }
    }

    private List<ConditionJsonModel> superQueryList(List<SuperQueryJsonModel> queryJsonModels, Map<String, String> tableFieldAndTableName, String mainTable) {
        ArrayList<ConditionJsonModel> superQueryList = new ArrayList<ConditionJsonModel>();
        for (SuperQueryJsonModel jsonModel : queryJsonModels) {
            List conditionList = JsonUtil.getJsonToList((Object)jsonModel.getGroups(), FieLdsModel.class);
            for (FieLdsModel fieLdsModel : conditionList) {
                ConditionJsonModel sup = (ConditionJsonModel)JsonUtil.getJsonToBean((Object)fieLdsModel, ConditionJsonModel.class);
                sup.setTableName(fieLdsModel.getConfig().getRelationTable());
                String field = sup.getField();
                String mastKey = fieLdsModel.getConfig().getJnpfKey();
                if (field.toLowerCase().contains("tablefield")) {
                    String substring = field.substring(field.lastIndexOf("-") + 1);
                    String tableField = field.substring(0, field.indexOf("-"));
                    sup.setField(substring);
                    sup.setTableName(tableFieldAndTableName.get(tableField));
                } else if (StringUtil.isEmpty((String)sup.getTableName())) {
                    sup.setTableName(mainTable);
                }
                if (mastKey.equals("checkbox") || mastKey.equals("areaSelect") || mastKey.equals("cascader") || mastKey.equals("organizeSelect")) {
                    fieLdsModel.setMultiple(Boolean.valueOf(true));
                }
                if (fieLdsModel.getMultiple().booleanValue() && StringUtil.isEmpty((String)sup.getFieldValue())) {
                    sup.setFieldValue("[]");
                }
                superQueryList.add(sup);
            }
        }
        return superQueryList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map<String, Object>> getRelationFormList(VisualDevJsonModel visualDevJsonModel, PaginationModel paginationModel) {
        FormDataModel formData = visualDevJsonModel.getFormData();
        ArrayList collect = StringUtil.isNotEmpty((String)paginationModel.getColumnOptions()) ? Arrays.asList(paginationModel.getColumnOptions().split(",")) : new ArrayList();
        List fieLdsModels = JsonUtil.getJsonToList((String)formData.getFields(), FieLdsModel.class);
        ArrayList<FieLdsModel> mainFieldModelList = new ArrayList<FieLdsModel>();
        List<Map<String, Object>> noSwapDataList = new ArrayList<Map<String, Object>>();
        ArrayList<VisualColumnSearchVO> searchVOList = new ArrayList<VisualColumnSearchVO>();
        String reg = "^[jnpf_]\\S*_jnpf\\S*";
        String keyword = paginationModel.getKeyword();
        if (visualDevJsonModel.getVisualTables().size() > 0) {
            try {
                List tableModelList = JsonUtil.getJsonToList((Object)visualDevJsonModel.getVisualTables(), TableModel.class);
                OnlinePublicUtils.recursionFields(mainFieldModelList, fieLdsModels);
                TableModel mainTable = tableModelList.stream().filter(t -> t.getTypeId().equals("1")).findFirst().orElse(null);
                DbLinkEntity linkEntity = this.dblinkService.getInfo(visualDevJsonModel.getDbLinkId());
                ArrayList<OnlineDynamicSqlModel> sqlModelList = new ArrayList<OnlineDynamicSqlModel>();
                for (TableModel model : tableModelList) {
                    OnlineDynamicSqlModel sqlModel = new OnlineDynamicSqlModel();
                    sqlModel.setSqlTable(SqlTable.of((String)model.getTable()));
                    sqlModel.setTableName(model.getTable());
                    if (model.getTypeId().equals("1")) {
                        sqlModel.setMain(true);
                    } else {
                        sqlModel.setForeign(model.getTableField());
                        sqlModel.setRelationKey(model.getRelationField());
                        sqlModel.setMain(false);
                    }
                    sqlModelList.add(sqlModel);
                }
                Boolean isPage = paginationModel.getPageSize() <= 500L;
                ArrayList<String> allFields = new ArrayList<String>();
                for (FieLdsModel item : mainFieldModelList) {
                    if (!StringUtil.isNotEmpty((String)item.getVModel()) || item.getVModel().toLowerCase().startsWith("tablefield")) continue;
                    allFields.add(item.getVModel());
                }
                OnlineProductSqlUtils.getColumnListSql(sqlModelList, visualDevJsonModel, allFields, linkEntity);
                DynamicDataSourceUtil.switchToDataSource((DbLinkEntity)linkEntity);
                Connection connection = ConnUtil.getConnOrDefault((DbSourceOrDbLink)linkEntity);
                try {
                    String databaseProductName = connection.getMetaData().getDatabaseProductName().trim();
                    OnlineDynamicSqlModel mainSqlModel = sqlModelList.stream().filter(OnlineDynamicSqlModel::isMain).findFirst().orElse(null);
                    String pkeyId = this.flowFormDataUtil.getKey(mainTable, databaseProductName);
                    visualDevJsonModel.setPkeyId(pkeyId);
                    HashMap<String, String> tableFieldAndTableName = new HashMap<String, String>(8);
                    HashMap tableNameAndTableField = new HashMap(8);
                    mainFieldModelList.stream().filter(f -> f.getConfig().getJnpfKey().equals("table")).forEach(f -> {
                        tableFieldAndTableName.put(f.getVModel(), f.getConfig().getTableName());
                        tableNameAndTableField.put(f.getConfig().getTableName(), f.getVModel());
                    });
                    List dycList = sqlModelList.stream().filter(dyc -> !dyc.isMain()).collect(Collectors.toList());
                    ArrayList sqlColumns = new ArrayList();
                    for (OnlineDynamicSqlModel dynamicSqlModel : sqlModelList) {
                        if (tableNameAndTableField.containsKey(dynamicSqlModel.getTableName())) continue;
                        List basicColumns = Optional.ofNullable(dynamicSqlModel.getColumns()).orElse(new ArrayList());
                        sqlColumns.addAll(basicColumns);
                    }
                    QueryExpressionDSL from = SqlBuilder.select(sqlColumns).from(mainSqlModel.getSqlTable());
                    QueryExpressionDSL childFrom = SqlBuilder.select((BasicColumn[])new BasicColumn[]{mainSqlModel.getSqlTable().column(pkeyId)}).from(mainSqlModel.getSqlTable());
                    List visualTables = visualDevJsonModel.getVisualTables();
                    RecursionForm recursionForm = new RecursionForm(fieLdsModels, visualTables);
                    ArrayList<FormAllModel> formAllModel = new ArrayList<FormAllModel>();
                    FormCloumnUtil.recursionForm((RecursionForm)recursionForm, formAllModel);
                    OnlineProductSqlUtils.queryList(formAllModel, visualDevJsonModel, paginationModel);
                    final SuperJsonModel ruleQuery = visualDevJsonModel.getRuleQuery();
                    ArrayList listquery = new ArrayList(){
                        {
                            this.add(ruleQuery);
                        }
                    };
                    SuperJsonModel keyWordQuery = new SuperJsonModel();
                    if (Objects.equals(paginationModel.getQueryType(), 0) && StringUtil.isNotEmpty((String)keyword)) {
                        List keywordFields = mainFieldModelList.stream().filter(t -> t.getConfig() != null && JnpfKeyConsts.getKeyWordList().contains(t.getConfig().getJnpfKey())).collect(Collectors.toList());
                        ArrayList keywordList = new ArrayList();
                        for (FieLdsModel fieLdsModel : keywordFields) {
                            fieLdsModel.setFieldValue(keyword);
                            fieLdsModel.setSymbol(SearchMethodEnum.Like.getSymbol());
                            fieLdsModel.setId(fieLdsModel.getVModel());
                            OnlineProductSqlUtils.tabelName(fieLdsModel, formAllModel);
                            keywordList.add(fieLdsModel);
                        }
                        final SuperQueryJsonModel queryJsonModel = new SuperQueryJsonModel();
                        queryJsonModel.setLogic(SearchMethodEnum.Or.getSymbol());
                        queryJsonModel.setGroups((List)keywordList);
                        keyWordQuery.setConditionList((List)new ArrayList(){
                            {
                                this.add(queryJsonModel);
                            }
                        });
                        listquery.add(keyWordQuery);
                    }
                    List<String> allTableName = OnlinePublicUtils.getAllTableName(new ArrayList<ColumnListField>(), listquery, tableFieldAndTableName);
                    if (dycList.size() > 0) {
                        for (OnlineDynamicSqlModel sqlModel : dycList) {
                            if (tableNameAndTableField.containsKey(sqlModel.getTableName()) && !allTableName.contains(sqlModel.getTableName())) continue;
                            childFrom.leftJoin(sqlModel.getSqlTable()).on((BasicColumn)sqlModel.getSqlTable().column(sqlModel.getForeign()), (JoinCondition)new EqualTo((BasicColumn)mainSqlModel.getSqlTable().column(sqlModel.getRelationKey())));
                            if (tableNameAndTableField.containsKey(sqlModel.getTableName())) continue;
                            from.leftJoin(sqlModel.getSqlTable()).on((BasicColumn)sqlModel.getSqlTable().column(sqlModel.getForeign()), (JoinCondition)new EqualTo((BasicColumn)mainSqlModel.getSqlTable().column(sqlModel.getRelationKey())));
                        }
                    }
                    QueryExpressionDSL.QueryExpressionWhereBuilder childWhere = childFrom.where();
                    OnlineProductSqlUtils.getSuperSql(childWhere, ruleQuery, sqlModelList, databaseProductName, null, false);
                    if (Objects.equals(paginationModel.getQueryType(), 0) && StringUtil.isNotEmpty((String)keyword)) {
                        OnlineProductSqlUtils.getSuperSql(childWhere, keyWordQuery, sqlModelList, databaseProductName, null, false);
                    }
                    if (visualDevJsonModel.getFormData().getLogicalDelete().booleanValue()) {
                        childWhere.and((BindableColumn)mainSqlModel.getSqlTable().column(TableFeildsEnum.DELETEMARK.getField()), (VisitableCondition)SqlBuilder.isNull(), new AndOrCriteriaGroup[0]);
                    }
                    QueryExpressionDSL.QueryExpressionWhereBuilder whereRes = from.where();
                    whereRes.and((BindableColumn)SqlTable.of((String)mainTable.getTable()).column(pkeyId), (VisitableCondition)SqlBuilder.isIn((Buildable)childWhere), new AndOrCriteriaGroup[0]);
                    if (StringUtil.isNotEmpty((String)paginationModel.getSidx())) {
                        String[] split = paginationModel.getSidx().split(",");
                        ArrayList<SortSpecification> sidxList = new ArrayList<SortSpecification>();
                        for (String string : split) {
                            if (string.toLowerCase().contains("_jnpf_") || string.toLowerCase().contains("tablefield")) continue;
                            SortSpecification sortSpecification = string.startsWith("-") ? SqlBuilder.sortColumn((String)mainTable.getTable(), (SqlColumn)SqlTable.of((String)mainTable.getTable()).column(string.substring(1))).descending() : SqlBuilder.sortColumn((String)mainTable.getTable(), (SqlColumn)SqlTable.of((String)mainTable.getTable()).column(string));
                            sidxList.add(sortSpecification);
                        }
                        whereRes.orderBy(sidxList);
                    } else {
                        whereRes.orderBy(new SortSpecification[]{SqlBuilder.sortColumn((String)mainTable.getTable(), (SqlColumn)SqlTable.of((String)mainTable.getTable()).column(pkeyId)).descending()});
                    }
                    SelectStatementProvider renderRes = ((SelectModel)whereRes.build()).render(RenderingStrategies.MYBATIS3);
                    if (Objects.equals(paginationModel.getQueryType(), 0)) {
                        QueryExpressionDSL.QueryExpressionWhereBuilder countSelect = (QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])new BasicColumn[]{SqlBuilder.countDistinct((BasicColumn)mainSqlModel.getSqlTable().column(pkeyId))}).from(mainSqlModel.getSqlTable()).where().and((BindableColumn)SqlTable.of((String)mainTable.getTable()).column(pkeyId), (VisitableCondition)SqlBuilder.isIn((Buildable)childWhere), new AndOrCriteriaGroup[0]);
                        SelectStatementProvider renderCount = ((SelectModel)countSelect.build()).render(RenderingStrategies.MYBATIS3);
                        long count = this.flowFormDataMapper.count(renderCount);
                        paginationModel.setTotal(count);
                        if (count == 0L) {
                            ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
                            return arrayList;
                        }
                        if (isPage.booleanValue()) {
                            PageHelper.startPage((int)((int)paginationModel.getCurrentPage()), (int)((int)paginationModel.getPageSize()), (boolean)false);
                        }
                    }
                    List dataList = this.flowFormDataMapper.selectManyMappedRows(renderRes);
                    noSwapDataList = dataList.stream().map(data -> {
                        data.put("id", data.get(pkeyId));
                        return data;
                    }).collect(Collectors.toList());
                    if (Objects.equals(paginationModel.getQueryType(), 1) && StringUtil.isNotEmpty((String)keyword)) {
                        for (FieLdsModel fieldsModel : mainFieldModelList) {
                            boolean b;
                            if (fieldsModel.getVModel() == null || !(b = collect.stream().anyMatch(c -> fieldsModel.getVModel().equalsIgnoreCase((String)c)))) continue;
                            VisualColumnSearchVO visualColumnSearchVO = new VisualColumnSearchVO();
                            visualColumnSearchVO.setSearchType("2");
                            visualColumnSearchVO.setVModel(fieldsModel.getVModel());
                            visualColumnSearchVO.setValue((Object)keyword);
                            visualColumnSearchVO.setConfig(fieldsModel.getConfig());
                            Boolean multiple = fieldsModel.getMultiple();
                            visualColumnSearchVO.setMultiple(multiple);
                            searchVOList.add(visualColumnSearchVO);
                        }
                        noSwapDataList = this.onlineSwapDataUtils.getSwapList(noSwapDataList, mainFieldModelList, visualDevJsonModel.getId(), false);
                        noSwapDataList = RelationFormUtils.getRelationListByKeyword(noSwapDataList, searchVOList);
                    } else {
                        noSwapDataList = this.onlineSwapDataUtils.getSwapList(noSwapDataList, mainFieldModelList, visualDevJsonModel.getId(), false);
                    }
                    if (Objects.equals(paginationModel.getQueryType(), 1) && isPage.booleanValue() && CollectionUtils.isNotEmpty(noSwapDataList)) {
                        paginationModel.setTotal((long)noSwapDataList.size());
                        List partition = Lists.partition(noSwapDataList, (int)((int)paginationModel.getPageSize()));
                        int i = (int)paginationModel.getCurrentPage() - 1;
                        noSwapDataList = partition.size() > i ? (List)partition.get(i) : Collections.emptyList();
                    }
                }
                finally {
                    if (Collections.singletonList(connection).get(0) != null) {
                        connection.close();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                DynamicDataSourceUtil.clearSwitchDataSource();
            }
        }
        if (noSwapDataList.size() < 1) {
            return new ArrayList<Map<String, Object>>();
        }
        return noSwapDataList;
    }

    @Override
    public List<Map<String, Object>> getListWithTableList(VisualDevJsonModel visualDevJsonModel, PaginationModel paginationModel, UserInfo userInfo) {
        FormDataModel formDataModel = visualDevJsonModel.getFormData();
        List visualTables = visualDevJsonModel.getVisualTables();
        if (ObjectUtil.isEmpty((Object)visualDevJsonModel.getColumnData())) {
            ColumnDataModel columnDataModel = new ColumnDataModel();
            columnDataModel.setColumnList("[]");
            visualDevJsonModel.setColumnData(columnDataModel);
        }
        List fieLdsModels = JsonUtil.getJsonToList((String)formDataModel.getFields(), FieLdsModel.class);
        RecursionForm recursionForm = new RecursionForm(fieLdsModels, visualTables);
        ArrayList formAllModel = new ArrayList();
        FormCloumnUtil.recursionForm((RecursionForm)recursionForm, formAllModel);
        ArrayList<String> columnPropList = new ArrayList<String>();
        for (FormAllModel model : formAllModel) {
            FieLdsModel fieLdsModel;
            if (FormEnum.mast.getMessage().equals(model.getJnpfKey()) && ObjectUtil.isNotEmpty((Object)(fieLdsModel = model.getFormColumnModel().getFieLdsModel()).getVModel())) {
                columnPropList.add(fieLdsModel.getVModel());
            }
            if (FormEnum.mastTable.getMessage().equals(model.getJnpfKey()) && ObjectUtil.isNotEmpty((Object)(fieLdsModel = model.getFormMastTableModel().getMastTable().getFieLdsModel()).getVModel())) {
                columnPropList.add(fieLdsModel.getVModel());
            }
            if (!FormEnum.table.getMessage().equals(model.getJnpfKey())) continue;
            FormColumnTableModel childList = model.getChildList();
            List childListAll = childList.getChildList();
            for (FormColumnModel childModel : childListAll) {
                FieLdsModel fieLdsModel2 = childModel.getFieLdsModel();
                if (!ObjectUtil.isNotEmpty((Object)fieLdsModel2.getVModel())) continue;
                columnPropList.add(childList.getTableModel() + "-" + fieLdsModel2.getVModel());
            }
        }
        List<Map<String, Object>> dataList = this.getListWithTable(visualDevJsonModel, paginationModel, userInfo, columnPropList);
        ArrayList<FieLdsModel> fields = new ArrayList<FieLdsModel>();
        OnlinePublicUtils.recursionFields(fields, fieLdsModels);
        visualDevJsonModel.setFormListModels(fields);
        dataList = this.onlineSwapDataUtils.getSwapList(dataList, fields, visualDevJsonModel.getId(), false);
        return dataList;
    }

    private void setAliasKey(List<Map<String, Object>> dataList, Map<String, String> aliasMap) {
        if (dataList.size() > 0 && aliasMap.size() > 0) {
            for (int i = 0; i < dataList.size(); ++i) {
                Map<String, Object> objMap = dataList.get(i);
                Set<String> aliasKey = aliasMap.keySet();
                HashMap<String, Object> newObj = new HashMap<String, Object>();
                for (String key : objMap.keySet()) {
                    Object value = objMap.get(key);
                    String oldKey = aliasMap.get(key);
                    if (aliasKey.contains(key)) {
                        newObj.put(oldKey, value);
                        continue;
                    }
                    newObj.put(key, value);
                }
                dataList.remove(i);
                dataList.add(i, newObj);
            }
        }
    }

    public List<BasicColumn> orderByColumns(OnlineDynamicSqlModel mainSqlModel, String sidxs, String pkeyId) {
        ArrayList<BasicColumn> distinctColumns = new ArrayList<BasicColumn>();
        distinctColumns.add((BasicColumn)mainSqlModel.getSqlTable().column(pkeyId));
        if (StringUtil.isNotEmpty((String)sidxs)) {
            String[] split;
            for (String sidx : split = sidxs.split(",")) {
                if (sidx.toLowerCase().contains("_jnpf_") || sidx.toLowerCase().contains("tablefield") || sidx.toLowerCase().equals(pkeyId)) continue;
                SqlColumn column = mainSqlModel.getSqlTable().column(sidx);
                if (sidx.startsWith("-")) {
                    column = mainSqlModel.getSqlTable().column(sidx.substring(1));
                }
                distinctColumns.add((BasicColumn)column);
            }
        }
        return distinctColumns;
    }

    private static /* synthetic */ String lambda$getListWithTable$21(String fogID, Map m) {
        return m.get(fogID).toString();
    }

    private static /* synthetic */ boolean lambda$getListWithTable$20(String foreign, TableFields t) {
        return t.getField().equals(foreign);
    }

    private static /* synthetic */ boolean lambda$getListWithTable$19(String table, OnlineDynamicSqlModel s) {
        return s.getTableName().equalsIgnoreCase(table);
    }

    private static /* synthetic */ String lambda$getListWithTable$18(Object t) {
        return t.toString();
    }

    private static /* synthetic */ boolean lambda$getListWithTable$17(String fogID, TableFields t) {
        return t.getField().equals(fogID);
    }

    private static /* synthetic */ Object lambda$getListWithTable$16(String mainPrimKey, Map m) {
        return m.get(mainPrimKey);
    }

    private static /* synthetic */ String lambda$getListWithTable$15(String t) {
        return t.substring(0, t.lastIndexOf("-"));
    }

    private static /* synthetic */ boolean lambda$getListWithTable$14(TableModel t) {
        return t.getTypeId().equals("0");
    }

    private static /* synthetic */ boolean lambda$getListWithTable$13(String c) {
        return c.toLowerCase().contains("tablefield");
    }

    private static /* synthetic */ Object lambda$getListWithTable$12(String finalPkeyId, Map m) {
        return m.get(finalPkeyId);
    }

    private static /* synthetic */ void lambda$getListWithTable$11(Map subSqlTableMap, OnlineDynamicSqlModel sqlModel, String fieldKey) {
        subSqlTableMap.put(fieldKey, sqlModel.getSqlTable());
    }

    private static /* synthetic */ boolean lambda$getListWithTable$10(String foreign, TableFields t) {
        return t.getField().equals(foreign);
    }

    private static /* synthetic */ void lambda$getListWithTable$9(Map tableFieldGroup, FieLdsModel f) {
        tableFieldGroup.computeIfAbsent(f.getConfig().getTableName(), k -> new ArrayList()).add("table".equals(f.getConfig().getType()) ? f.getConfig().getTableName() : f.getVModel());
    }

    private static /* synthetic */ boolean lambda$getListWithTable$7(OnlineDynamicSqlModel dyc) {
        return !dyc.isMain();
    }

    private static /* synthetic */ String lambda$getListWithTable$6(ColumnListField mode) {
        return mode.getProp();
    }

    private static /* synthetic */ void lambda$getListWithTable$5(Map tableFieldAndTableName, Map tableNameAndTableField, FieLdsModel f) {
        tableFieldAndTableName.put(f.getVModel(), f.getConfig().getTableName());
        tableNameAndTableField.put(f.getConfig().getTableName(), f.getVModel());
    }

    private static /* synthetic */ boolean lambda$getListWithTable$4(FieLdsModel f) {
        return f.getConfig().getJnpfKey().equals("table");
    }

    private static /* synthetic */ boolean lambda$getListWithTable$3(TableModel t) {
        return t.getTypeId().equals("1");
    }
}

