/*
 * Decompiled with CFR 0.152.
 */
package jnpf.integrate.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import jnpf.base.ActionResult;
import jnpf.config.ConfigValueUtil;
import jnpf.constant.MsgCode;
import jnpf.database.util.TenantDataSourceUtil;
import jnpf.exception.WorkFlowException;
import jnpf.integrate.entity.IntegrateEntity;
import jnpf.integrate.model.integrate.WebHookInfoVo;
import jnpf.integrate.service.IntegrateService;
import jnpf.integrate.util.IntegrateUtil;
import jnpf.util.NoDataSourceBind;
import jnpf.util.RedisUtil;
import jnpf.util.ServletUtil;
import jnpf.util.StringUtil;
import jnpf.util.UserProvider;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="webhook\u89e6\u53d1", description="WebHook")
@RestController
@RequestMapping(value={"/api/visualdev/Hooks"})
public class WebHookController {
    @Autowired
    private IntegrateService integrateService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private IntegrateUtil integrateUtil;
    private static final String WEBHOOK_RED_KEY = "webhookencode";
    private static long DEFAULT_CACHE_TIME = 300L;

    @Operation(summary="\u6570\u636e\u63a5\u6536\u63a5\u53e3")
    @Parameters(value={@Parameter(name="id", description="base64\u8f6c\u7801id", required=true), @Parameter(name="tenantId", description="\u79df\u6237id", required=false)})
    @PostMapping(value={"/{id}"})
    @NoDataSourceBind
    public ActionResult webhookTrigger(@PathVariable(value="id") String id, @RequestParam(value="tenantId", required=false) String tenantId, @RequestBody Map<String, Object> body) throws WorkFlowException {
        String idReal = new String(Base64.decodeBase64((byte[])id.getBytes(StandardCharsets.UTF_8)));
        if (this.configValueUtil.isMultiTenancy() && StringUtil.isNotEmpty((String)tenantId)) {
            try {
                TenantDataSourceUtil.switchTenant((String)tenantId);
            }
            catch (Exception e) {
                return ActionResult.fail((String)MsgCode.LOG105.get(new Object[0]));
            }
        }
        this.integrateUtil.integrate(idReal, tenantId, body);
        return ActionResult.success();
    }

    @Operation(summary="\u83b7\u53d6webhookUrl")
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e", required=true)})
    @GetMapping(value={"/getUrl"})
    public ActionResult getWebhookUrl(@RequestParam(value="id") String id) {
        String enCodeBase64 = new String(Base64.encodeBase64((byte[])id.getBytes(StandardCharsets.UTF_8)));
        String randomStr = UUID.randomUUID().toString().substring(0, 5);
        WebHookInfoVo vo = new WebHookInfoVo();
        vo.setEnCodeStr(enCodeBase64);
        vo.setRandomStr(randomStr);
        vo.setWebhookUrl("/api/visualdev/Hooks/" + enCodeBase64);
        vo.setRequestUrl("/api/visualdev/Hooks/" + enCodeBase64 + "/params/" + randomStr);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u901a\u8fc7get\u63a5\u53e3\u83b7\u53d6\u53c2\u6570")
    @Parameters(value={@Parameter(name="id", description="base64\u8f6c\u7801id", required=true), @Parameter(name="randomStr", description="\u83b7\u53d6webhookUrl\u63d0\u4f9b\u7684\u968f\u673a\u5b57\u7b26", required=true)})
    @GetMapping(value={"/{id}/params/{randomStr}"})
    @NoDataSourceBind
    public ActionResult getWebhookParams(@PathVariable(value="id") String id, @PathVariable(value="randomStr") String randomStr) throws WorkFlowException {
        this.insertRedis(id, randomStr, new HashMap<String, Object>());
        return ActionResult.success();
    }

    @Operation(summary="\u901a\u8fc7post\u63a5\u53e3\u83b7\u53d6\u53c2\u6570")
    @Parameters(value={@Parameter(name="id", description="base64\u8f6c\u7801id", required=true), @Parameter(name="randomStr", description="\u83b7\u53d6webhookUrl\u63d0\u4f9b\u7684\u968f\u673a\u5b57\u7b26", required=true)})
    @PostMapping(value={"/{id}/params/{randomStr}"})
    @NoDataSourceBind
    public ActionResult postWebhookParams(@PathVariable(value="id") String id, @PathVariable(value="randomStr") String randomStr, @RequestBody Map<String, Object> obj) throws WorkFlowException {
        this.insertRedis(id, randomStr, new HashMap<String, Object>(obj));
        return ActionResult.success();
    }

    private void insertRedis(String id, String randomStr, Map<String, Object> resultMap) throws WorkFlowException {
        IntegrateEntity entity;
        String idReal = new String(Base64.decodeBase64((byte[])id.getBytes(StandardCharsets.UTF_8)));
        String key1 = "webhookencode_" + idReal + "_" + randomStr;
        if (!this.redisUtil.exists(key1)) {
            throw new WorkFlowException(MsgCode.VS016.get(new Object[0]));
        }
        String tenantId = this.redisUtil.getString(key1).toString();
        if (this.configValueUtil.isMultiTenancy() && StringUtil.isNotEmpty((String)tenantId)) {
            try {
                TenantDataSourceUtil.switchTenant((String)tenantId);
            }
            catch (Exception e) {
                throw new WorkFlowException(MsgCode.LOG105.get(new Object[0]));
            }
        }
        if (Objects.equals((entity = this.integrateService.getInfo(idReal)).getEnabledMark(), 0)) {
            throw new WorkFlowException(MsgCode.VS017.get(new Object[0]));
        }
        HashMap<String, Object> parameterMap = new HashMap<String, Object>(ServletUtil.getRequest().getParameterMap());
        for (String key : parameterMap.keySet()) {
            String[] parameterValues = ServletUtil.getRequest().getParameterValues(key);
            if (parameterValues.length == 1) {
                parameterMap.put(key, parameterValues[0]);
                continue;
            }
            parameterMap.put(key, parameterValues);
        }
        resultMap.putAll(parameterMap);
        if (resultMap.keySet().size() > 0) {
            this.redisUtil.insert("webhookencode_" + randomStr, resultMap, DEFAULT_CACHE_TIME);
            this.redisUtil.remove(key1);
        }
    }

    @Operation(summary="\u8bf7\u6c42\u53c2\u6570\u6dfb\u52a0\u89e6\u53d1\u63a5\u53e3")
    @Parameters(value={@Parameter(name="id", description="base64\u8f6c\u7801id", required=true), @Parameter(name="randomStr", description="\u83b7\u53d6webhookUrl\u63d0\u4f9b\u7684\u968f\u673a\u5b57\u7b26", required=true)})
    @GetMapping(value={"/{id}/start/{randomStr}"})
    public ActionResult start(@PathVariable(value="id") String id, @PathVariable(value="randomStr") String randomStr) {
        this.redisUtil.remove("webhookencode_" + randomStr);
        this.redisUtil.insert("webhookencode_" + id + "_" + randomStr, (Object)UserProvider.getUser().getTenantId(), DEFAULT_CACHE_TIME);
        return ActionResult.success();
    }

    @Operation(summary="\u83b7\u53d6\u7f13\u5b58\u7684\u63a5\u53e3\u53c2\u6570")
    @Parameters(value={@Parameter(name="randomStr", description="\u83b7\u53d6webhookUrl\u63d0\u4f9b\u7684\u968f\u673a\u5b57\u7b26", required=true)})
    @GetMapping(value={"/getParams/{randomStr}"})
    public ActionResult getRedisParams(@PathVariable(value="randomStr") String randomStr) {
        Map mapRedis = new HashMap();
        String key = "webhookencode_" + randomStr;
        if (this.redisUtil.exists(key)) {
            mapRedis = this.redisUtil.getMap(key);
        }
        ArrayList list = new ArrayList();
        for (String redisKey : mapRedis.keySet()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", redisKey);
            map.put("fullName", (String)mapRedis.get(redisKey));
            list.add(map);
        }
        return ActionResult.success(list);
    }
}

