/*
 * Decompiled with CFR 0.152.
 */
package jnpf.integrate.controller;

import cn.hutool.core.util.ObjectUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import jnpf.base.ActionResult;
import jnpf.base.controller.SuperController;
import jnpf.base.vo.DownloadVO;
import jnpf.base.vo.PageListVO;
import jnpf.base.vo.PaginationVO;
import jnpf.config.ConfigValueUtil;
import jnpf.constant.MsgCode;
import jnpf.emnus.ModuleTypeEnum;
import jnpf.exception.WorkFlowException;
import jnpf.integrate.entity.IntegrateEntity;
import jnpf.integrate.entity.IntegrateQueueEntity;
import jnpf.integrate.job.IntegrateJobUtil;
import jnpf.integrate.model.integrate.IntegrateCrForm;
import jnpf.integrate.model.integrate.IntegrateInfoVO;
import jnpf.integrate.model.integrate.IntegrateListVO;
import jnpf.integrate.model.integrate.IntegratePagination;
import jnpf.integrate.model.integrate.IntegrateUpForm;
import jnpf.integrate.model.nodeJson.IntegrateModel;
import jnpf.integrate.service.IntegrateQueueService;
import jnpf.integrate.service.IntegrateService;
import jnpf.integrate.util.IntegrateHttpModel;
import jnpf.integrate.util.IntegrateUtil;
import jnpf.permission.entity.UserEntity;
import jnpf.permission.service.UserService;
import jnpf.util.DataFileExport;
import jnpf.util.FileUtil;
import jnpf.util.JsonUtil;
import jnpf.util.RandomUtil;
import jnpf.util.RedisUtil;
import jnpf.util.UserProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="\u96c6\u6210\u52a9\u624b", description="Integrate")
@RestController
@RequestMapping(value={"/api/visualdev/Integrate"})
public class IntegrateController
extends SuperController<IntegrateService, IntegrateEntity> {
    private static final Logger log = LoggerFactory.getLogger(IntegrateController.class);
    @Autowired
    private UserService userService;
    @Autowired
    private DataFileExport fileExport;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private IntegrateService integrateService;
    @Autowired
    private IntegrateQueueService integrateQueueService;
    @Autowired
    private IntegrateUtil integrateUtil;
    @Autowired
    private RedisUtil redisUtil;

    @Operation(summary="\u5217\u8868")
    @GetMapping
    public ActionResult<PageListVO<IntegrateListVO>> list(IntegratePagination pagination) {
        List data = this.integrateService.getList(pagination);
        List userId = data.stream().map(t -> t.getCreatorUserId()).collect(Collectors.toList());
        List userEntities = this.userService.getUserName(userId);
        ArrayList<IntegrateListVO> resultList = new ArrayList<IntegrateListVO>();
        for (IntegrateEntity entity : data) {
            IntegrateListVO vo = (IntegrateListVO)JsonUtil.getJsonToBean((Object)entity, IntegrateListVO.class);
            UserEntity creatorUser = userEntities.stream().filter(t -> ((String)t.getId()).equals(entity.getCreatorUserId())).findFirst().orElse(null);
            vo.setCreatorUser((String)(creatorUser != null ? creatorUser.getRealName() + "/" + creatorUser.getAccount() : ""));
            resultList.add(vo);
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)pagination, PaginationVO.class);
        return ActionResult.page(resultList, (PaginationVO)paginationVO);
    }

    @Operation(summary="\u83b7\u53d6\u4fe1\u606f")
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e", required=true)})
    @GetMapping(value={"/{id}"})
    public ActionResult info(@PathVariable(value="id") String id) {
        IntegrateEntity entity = this.integrateService.getInfo(id);
        if (entity == null) {
            return ActionResult.fail((String)MsgCode.FA001.get(new Object[0]));
        }
        IntegrateInfoVO vo = (IntegrateInfoVO)JsonUtil.getJsonToBean((Object)entity, IntegrateInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u6dfb\u52a0")
    @Parameters(value={@Parameter(name="integrateCrForm", description="\u5b9e\u4f53\u5bf9\u8c61", required=true)})
    @PostMapping
    public ActionResult create(@RequestBody @Valid IntegrateCrForm integrateCrForm) {
        IntegrateEntity entity = (IntegrateEntity)JsonUtil.getJsonToBean((Object)integrateCrForm, IntegrateEntity.class);
        if (this.integrateService.isExistByFullName(entity.getFullName(), (String)entity.getId()).booleanValue()) {
            return ActionResult.fail((String)MsgCode.EXIST001.get(new Object[0]));
        }
        if (this.integrateService.isExistByEnCode(entity.getEnCode(), (String)entity.getId()).booleanValue()) {
            return ActionResult.fail((String)MsgCode.EXIST002.get(new Object[0]));
        }
        String id = RandomUtil.uuId();
        entity.setId((Object)id);
        this.integrateService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get(new Object[0]), (Object)id);
    }

    @Operation(summary="\u4fee\u6539")
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e\u503c", required=true), @Parameter(name="integrateUpForm", description="\u5b9e\u4f53\u5bf9\u8c61", required=true)})
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody IntegrateUpForm integrateUpForm) {
        IntegrateEntity positionEntity = this.integrateService.getInfo(id);
        if (positionEntity == null) {
            return ActionResult.fail((String)MsgCode.FA002.get(new Object[0]));
        }
        IntegrateEntity entity = (IntegrateEntity)JsonUtil.getJsonToBean((Object)integrateUpForm, IntegrateEntity.class);
        if (this.integrateService.isExistByFullName(entity.getFullName(), id).booleanValue()) {
            return ActionResult.fail((String)MsgCode.EXIST001.get(new Object[0]));
        }
        if (this.integrateService.isExistByEnCode(entity.getEnCode(), id).booleanValue()) {
            return ActionResult.fail((String)MsgCode.EXIST002.get(new Object[0]));
        }
        boolean flag = this.integrateService.update(id, entity, false);
        if (!flag) {
            return ActionResult.fail((String)MsgCode.FA002.get(new Object[0]));
        }
        return ActionResult.success((String)MsgCode.SU004.get(new Object[0]), (Object)id);
    }

    @Operation(summary="\u5220\u9664")
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e\u503c", required=true)})
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        IntegrateEntity entity = this.integrateService.getInfo(id);
        if (entity != null) {
            this.integrateService.delete(entity);
            return ActionResult.success((String)MsgCode.SU003.get(new Object[0]));
        }
        return ActionResult.fail((String)MsgCode.FA003.get(new Object[0]));
    }

    @Operation(summary="\u590d\u5236\u529f\u80fd")
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e")})
    @PostMapping(value={"/{id}/Actions/Copy"})
    public ActionResult copyInfo(@PathVariable(value="id") String id) throws Exception {
        IntegrateEntity entity = this.integrateService.getInfo(id);
        entity.setEnabledMark(Integer.valueOf(0));
        String copyNum = UUID.randomUUID().toString().substring(0, 5);
        entity.setFullName(entity.getFullName() + ".\u526f\u672c" + copyNum);
        entity.setLastModifyTime(null);
        entity.setLastModifyUserId(null);
        entity.setId((Object)RandomUtil.uuId());
        entity.setEnCode(entity.getEnCode() + copyNum);
        entity.setCreatorTime(new Date());
        entity.setEnabledMark(Integer.valueOf(0));
        entity.setCreatorUserId(UserProvider.getUser().getUserId());
        this.integrateService.create(entity);
        return ActionResult.success((String)MsgCode.SU007.get(new Object[0]));
    }

    @Operation(summary="\u66f4\u65b0\u529f\u80fd\u72b6\u6001")
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e")})
    @PutMapping(value={"/{id}/Actions/State"})
    public ActionResult update(@PathVariable(value="id") String id) {
        IntegrateEntity entity = this.integrateService.getInfo(id);
        if (entity != null) {
            if (entity.getEnabledMark() == null || "1".equals(String.valueOf(entity.getEnabledMark()))) {
                entity.setEnabledMark(Integer.valueOf(0));
            } else {
                entity.setEnabledMark(Integer.valueOf(1));
            }
            boolean flag = this.integrateService.update((String)entity.getId(), entity, true);
            if (!flag) {
                return ActionResult.fail((String)MsgCode.FA002.get(new Object[0]));
            }
        }
        return ActionResult.success((String)MsgCode.SU004.get(new Object[0]));
    }

    @Operation(summary="\u5bfc\u51fa")
    @PostMapping(value={"/{id}/Actions/Export"})
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e", required=true)})
    public ActionResult<DownloadVO> exportData(@PathVariable(value="id") String id) {
        IntegrateEntity entity = this.integrateService.getInfo(id);
        DownloadVO downloadVO = this.fileExport.exportFile((Object)entity, this.configValueUtil.getTemporaryFilePath(), entity.getFullName(), ModuleTypeEnum.BASE_INTEGRATE.getTableName());
        return ActionResult.success((Object)downloadVO);
    }

    @Operation(summary="\u5bfc\u5165")
    @PostMapping(value={"/Actions/Import"}, consumes={"multipart/form-data"})
    public ActionResult ImportData(@RequestPart(value="file") MultipartFile file, @RequestParam(value="type") Integer type) throws WorkFlowException {
        if (FileUtil.existsSuffix((MultipartFile)file, (String)ModuleTypeEnum.BASE_INTEGRATE.getTableName())) {
            return ActionResult.fail((String)MsgCode.IMP002.get(new Object[0]));
        }
        try {
            String fileContent = FileUtil.getFileContent((MultipartFile)file);
            IntegrateEntity entity = (IntegrateEntity)JsonUtil.getJsonToBean((String)fileContent, IntegrateEntity.class);
            return this.integrateService.ImportData(entity, type);
        }
        catch (Exception e) {
            throw new WorkFlowException(MsgCode.IMP004.get(new Object[0]));
        }
    }

    @PostMapping(value={"/execute"})
    public ActionResult execute(@RequestBody IntegrateHttpModel model) {
        this.integrateUtil.integrates(model.getDataInfoVOList(), model.getUserInfo());
        return ActionResult.success();
    }

    @PostMapping(value={"/executeQuery"})
    public ActionResult executeQuery(@RequestBody IntegrateHttpModel model) {
        IntegrateQueueEntity entity;
        IntegrateModel integrateModel = (IntegrateModel)JsonUtil.getJsonToBean((Object)model, IntegrateModel.class);
        if (ObjectUtil.isNotEmpty((Object)model.getId()) && ObjectUtil.isNotEmpty((Object)(entity = (IntegrateQueueEntity)this.integrateQueueService.getById((Serializable)((Object)model.getId()))))) {
            this.integrateUtil.integrate(entity, model.getUserInfo());
        }
        IntegrateJobUtil.removeIntegrate((IntegrateModel)integrateModel, (RedisUtil)this.redisUtil);
        return ActionResult.success();
    }
}

