/*
 * Decompiled with CFR 0.152.
 */
package jnpf.integrate.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jnpf.base.entity.SuperBaseEntity;
import jnpf.base.service.SuperServiceImpl;
import jnpf.integrate.entity.IntegrateTaskEntity;
import jnpf.integrate.mapper.IntegrateTaskMapper;
import jnpf.integrate.model.integrate.IntegratePageModel;
import jnpf.integrate.service.IntegrateNodeService;
import jnpf.integrate.service.IntegrateTaskService;
import jnpf.util.RandomUtil;
import jnpf.util.StringUtil;
import jnpf.util.UserProvider;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IntegrateTaskServiceImpl
extends SuperServiceImpl<IntegrateTaskMapper, IntegrateTaskEntity>
implements IntegrateTaskService {
    @Autowired
    private IntegrateNodeService integrateNodeService;

    @Override
    public List<IntegrateTaskEntity> getList(IntegratePageModel pagination) {
        String endTime;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(IntegrateTaskEntity::getIntegrateId, (Object)pagination.getIntegrateId());
        String startTime = pagination.getStartTime() != null ? pagination.getStartTime() : null;
        String string = endTime = pagination.getEndTime() != null ? pagination.getEndTime() : null;
        if (!StringUtils.isEmpty((CharSequence)startTime) && !StringUtils.isEmpty((CharSequence)endTime)) {
            Date startTimes = new Date(Long.parseLong(startTime));
            Date endTimes = new Date(Long.parseLong(endTime));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(IntegrateTaskEntity::getExecutionTime, (Object)startTimes)).le(IntegrateTaskEntity::getExecutionTime, (Object)endTimes);
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getResultType())) {
            queryWrapper.lambda().eq(IntegrateTaskEntity::getResultType, (Object)pagination.getResultType());
        }
        queryWrapper.lambda().orderByDesc(IntegrateTaskEntity::getExecutionTime);
        Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
        IPage userPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return pagination.setData(userPage.getRecords(), page.getTotal());
    }

    @Override
    public List<IntegrateTaskEntity> getList(List<String> id) {
        ArrayList<IntegrateTaskEntity> list = new ArrayList<IntegrateTaskEntity>();
        QueryWrapper queryWrapper = new QueryWrapper();
        if (id.size() > 0) {
            queryWrapper.lambda().in(IntegrateTaskEntity::getIntegrateId, id);
            list.addAll(this.list((Wrapper)queryWrapper));
        }
        return list;
    }

    @Override
    public IntegrateTaskEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SuperBaseEntity.SuperIBaseEntity::getId, (Object)id);
        return (IntegrateTaskEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(IntegrateTaskEntity entity) {
        if (StringUtil.isEmpty((String)((String)entity.getId()))) {
            entity.setId((Object)RandomUtil.uuId());
        }
        entity.setCreatorTime(new Date());
        entity.setCreatorUserId(UserProvider.getUser().getUserId());
        entity.setEnabledMark(Integer.valueOf(0));
        this.save(entity);
    }

    @Override
    public Boolean update(String id, IntegrateTaskEntity entity) {
        entity.setId((Object)id);
        entity.setLastModifyTime(new Date());
        entity.setLastModifyUserId(UserProvider.getUser().getUserId());
        return this.updateById(entity);
    }

    @Override
    public void delete(String id) {
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(SuperBaseEntity.SuperIBaseEntity::getId, (Object)id);
            this.remove((Wrapper)queryWrapper);
            this.integrateNodeService.delete(id);
        }
    }
}

