/*
 * Decompiled with CFR 0.152.
 */
package jnpf.integrate.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.UUID;
import jnpf.base.ActionResult;
import jnpf.base.entity.SuperBaseEntity;
import jnpf.base.entity.SuperExtendEntity;
import jnpf.base.service.SuperServiceImpl;
import jnpf.constant.MsgCode;
import jnpf.exception.WorkFlowException;
import jnpf.integrate.entity.IntegrateEntity;
import jnpf.integrate.job.Integrate;
import jnpf.integrate.job.IntegrateJobUtil;
import jnpf.integrate.job.QuartzUtil;
import jnpf.integrate.mapper.IntegrateMapper;
import jnpf.integrate.model.childnode.IntegrateChildNode;
import jnpf.integrate.model.childnode.IntegrateProperties;
import jnpf.integrate.model.integrate.IntegratePagination;
import jnpf.integrate.model.nodeJson.IntegrateModel;
import jnpf.integrate.service.IntegrateQueueService;
import jnpf.integrate.service.IntegrateService;
import jnpf.util.JsonUtil;
import jnpf.util.RandomUtil;
import jnpf.util.RedisUtil;
import jnpf.util.StringUtil;
import jnpf.util.UserProvider;
import org.apache.commons.lang3.StringUtils;
import org.quartz.JobDataMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IntegrateServiceImpl
extends SuperServiceImpl<IntegrateMapper, IntegrateEntity>
implements IntegrateService {
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private IntegrateQueueService integrateQueueService;

    @Override
    public List<IntegrateEntity> getList(IntegratePagination pagination) {
        return this.getList(pagination, true);
    }

    @Override
    public List<IntegrateEntity> getList(IntegratePagination pagination, boolean isPage) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtil.isNotEmpty((String)pagination.getKeyword())) {
            queryWrapper.lambda().and(t -> ((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(IntegrateEntity::getFullName, (Object)pagination.getKeyword())).or()).like(IntegrateEntity::getEnCode, (Object)pagination.getKeyword()));
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getType())) {
            queryWrapper.lambda().eq(IntegrateEntity::getType, (Object)pagination.getType());
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getFormId())) {
            queryWrapper.lambda().eq(IntegrateEntity::getFormId, (Object)pagination.getFormId());
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getTrigger())) {
            queryWrapper.lambda().eq(IntegrateEntity::getTriggerType, (Object)pagination.getTrigger());
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getEnabledMark())) {
            queryWrapper.lambda().eq(SuperExtendEntity.SuperExtendDEEntity::getEnabledMark, (Object)pagination.getEnabledMark());
        }
        if (StringUtils.isEmpty((CharSequence)pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(SuperBaseEntity.SuperCBaseEntity::getCreatorTime);
        } else {
            QueryWrapper queryWrapper2 = queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)pagination.getSidx()) : (QueryWrapper)queryWrapper.orderByDesc((Object)pagination.getSidx());
        }
        if (isPage) {
            Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
            IPage userPage = this.page((IPage)page, (Wrapper)queryWrapper);
            return pagination.setData(userPage.getRecords(), page.getTotal());
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public IntegrateEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SuperBaseEntity.SuperIBaseEntity::getId, (Object)id);
        return (IntegrateEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public Boolean isExistByFullName(String fullName, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(IntegrateEntity::getFullName, (Object)fullName);
        if (!StringUtil.isEmpty((String)id)) {
            queryWrapper.lambda().ne(SuperBaseEntity.SuperIBaseEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public Boolean isExistByEnCode(String encode, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(IntegrateEntity::getEnCode, (Object)encode);
        if (!StringUtil.isEmpty((String)id)) {
            queryWrapper.lambda().ne(SuperBaseEntity.SuperIBaseEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public void create(IntegrateEntity entity) {
        if (StringUtil.isEmpty((String)((String)entity.getId()))) {
            entity.setId((Object)RandomUtil.uuId());
        }
        entity.setCreatorTime(new Date());
        entity.setCreatorUserId(UserProvider.getUser().getUserId());
        this.formId(entity);
        this.save(entity);
    }

    @Override
    @DSTransactional
    public ActionResult ImportData(IntegrateEntity entity, Integer type) throws WorkFlowException {
        if (entity != null) {
            StringJoiner errList = new StringJoiner("\u3001");
            String copyNum = UUID.randomUUID().toString().substring(0, 5);
            if (this.getInfo((String)entity.getId()) != null) {
                if (Objects.equals(type, 0)) {
                    errList.add("ID");
                } else {
                    entity.setId((Object)RandomUtil.uuId());
                }
            }
            if (this.isExistByEnCode(entity.getEnCode(), null).booleanValue()) {
                if (Objects.equals(type, 0)) {
                    errList.add(MsgCode.IMP009.get(new Object[0]));
                } else {
                    entity.setEnCode(entity.getEnCode() + copyNum);
                }
            }
            if (this.isExistByFullName(entity.getFullName(), null).booleanValue()) {
                if (Objects.equals(type, 0)) {
                    errList.add(MsgCode.IMP008.get(new Object[0]));
                } else {
                    entity.setFullName(entity.getFullName() + ".\u526f\u672c" + copyNum);
                }
            }
            if (Objects.equals(type, 0) && errList.length() > 0) {
                return ActionResult.fail((String)(String.valueOf(errList) + MsgCode.IMP007.get(new Object[0])));
            }
            try {
                this.setIgnoreLogicDelete().removeById((Serializable)entity.getId());
                entity.setCreatorTime(new Date());
                entity.setCreatorUserId(UserProvider.getLoginUserId());
                entity.setLastModifyTime(null);
                entity.setLastModifyUserId(null);
                entity.setEnabledMark(Integer.valueOf(0));
                this.setIgnoreLogicDelete().saveOrUpdate((Object)entity);
                this.clearIgnoreLogicDelete();
            }
            catch (Exception e) {
                throw new WorkFlowException(MsgCode.IMP003.get(new Object[0]), (Throwable)e);
            }
            return ActionResult.success((String)MsgCode.IMP001.get(new Object[0]));
        }
        return ActionResult.fail((String)MsgCode.IMP006.get(new Object[0]));
    }

    @Override
    public Boolean update(String id, IntegrateEntity entity, boolean state) {
        entity.setId((Object)id);
        IntegrateEntity info = this.getInfo(id);
        if (Objects.equals(entity.getEnabledMark(), 0) || !Objects.equals(info.getTemplateJson(), entity.getTemplateJson())) {
            this.deleteJob(entity);
        }
        if (ObjectUtil.isEmpty((Object)entity.getEnabledMark())) {
            entity.setEnabledMark(info.getEnabledMark());
        }
        if (ObjectUtil.isEmpty((Object)entity.getType())) {
            entity.setType(info.getType());
        }
        if ((!Objects.equals(info.getTemplateJson(), entity.getTemplateJson()) || state) && Objects.equals(entity.getEnabledMark(), 1)) {
            this.formId(entity);
        }
        entity.setLastModifyTime(new Date());
        entity.setLastModifyUserId(UserProvider.getUser().getUserId());
        return this.updateById(entity);
    }

    @Override
    public void delete(IntegrateEntity entity) {
        this.deleteJob(entity);
        this.removeById((Serializable)entity.getId());
    }

    private void formId(IntegrateEntity entity) {
        Integer enabledMark = entity.getEnabledMark();
        String templateJson = entity.getTemplateJson();
        if (StringUtil.isNotEmpty((String)templateJson)) {
            IntegrateChildNode childNode = (IntegrateChildNode)JsonUtil.getJsonToBean((String)templateJson, IntegrateChildNode.class);
            IntegrateProperties properties = childNode.getProperties();
            String formId = properties.getFormId();
            entity.setFormId(formId);
            entity.setTriggerType(properties.getTriggerEvent());
            if (Objects.equals(enabledMark, 1) && Objects.equals(entity.getType(), 2)) {
                boolean isAdd;
                IntegrateModel model = new IntegrateModel();
                model.setId((String)entity.getId());
                IntegrateJobUtil.removeModel(model, this.redisUtil);
                IntegrateModel integrateModel = (IntegrateModel)JsonUtil.getJsonToBean((Object)properties, IntegrateModel.class);
                integrateModel.setUserInfo(UserProvider.getUser());
                integrateModel.setId((String)entity.getId());
                integrateModel.setState(Integer.valueOf(0));
                JobDataMap jobDataMap = new JobDataMap();
                Date startTime = ObjectUtil.isNotEmpty((Object)properties.getStartTime()) ? new Date(properties.getStartTime()) : new Date();
                Date endTime = Objects.equals(properties.getEndTimeType(), 2) ? new Date(properties.getEndTime()) : null;
                integrateModel.setEndTime(endTime != null ? Long.valueOf(endTime.getTime()) : null);
                integrateModel.setStartTime(Long.valueOf(startTime.getTime()));
                jobDataMap.putAll(JsonUtil.entityToMap((Object)integrateModel));
                this.redisUtil.removeHash("idgenerator_IntegrateModel", (String)entity.getId());
                boolean bl = ObjectUtil.isNotEmpty((Object)endTime) ? endTime.getTime() > System.currentTimeMillis() : (isAdd = true);
                if (isAdd) {
                    QuartzUtil.addJob((String)entity.getId(), properties.getCron(), Integrate.class, jobDataMap, startTime, endTime);
                }
            }
        }
    }

    private void deleteJob(IntegrateEntity entity) {
        QuartzUtil.deleteJob((String)entity.getId());
        this.integrateQueueService.delete((String)entity.getId());
        IntegrateModel model = new IntegrateModel();
        model.setId((String)entity.getId());
        IntegrateJobUtil.removeModel(model, this.redisUtil);
    }
}

