/*
 * Decompiled with CFR 0.152.
 */
package jnpf.integrate.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jnpf.base.entity.SuperBaseEntity;
import jnpf.base.entity.SuperExtendEntity;
import jnpf.base.service.SuperServiceImpl;
import jnpf.integrate.entity.IntegrateNodeEntity;
import jnpf.integrate.mapper.IntegrateNodeMapper;
import jnpf.integrate.service.IntegrateNodeService;
import jnpf.util.RandomUtil;
import jnpf.util.StringUtil;
import jnpf.util.UserProvider;
import org.springframework.stereotype.Service;

@Service
public class IntegrateNodeServiceImpl
extends SuperServiceImpl<IntegrateNodeMapper, IntegrateNodeEntity>
implements IntegrateNodeService {
    @Override
    public List<IntegrateNodeEntity> getList(List<String> id, String nodeCode) {
        return this.getList(id, nodeCode, null);
    }

    @Override
    public List<IntegrateNodeEntity> getList(List<String> id, String nodeCode, Integer resultType) {
        ArrayList<IntegrateNodeEntity> list = new ArrayList<IntegrateNodeEntity>();
        QueryWrapper queryWrapper = new QueryWrapper();
        if (id.size() > 0) {
            queryWrapper.lambda().in(IntegrateNodeEntity::getTaskId, id);
            if (StringUtil.isNotEmpty((String)nodeCode)) {
                queryWrapper.lambda().eq(IntegrateNodeEntity::getNodeCode, (Object)nodeCode);
            }
            if (ObjectUtil.isNotEmpty((Object)resultType)) {
                queryWrapper.lambda().eq(IntegrateNodeEntity::getResultType, (Object)resultType);
            }
            queryWrapper.lambda().orderByAsc(SuperExtendEntity::getSortCode);
            queryWrapper.lambda().orderByAsc(IntegrateNodeEntity::getStartTime);
            list.addAll(this.list((Wrapper)queryWrapper));
        }
        return list;
    }

    @Override
    public IntegrateNodeEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SuperBaseEntity.SuperIBaseEntity::getId, (Object)id);
        return (IntegrateNodeEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(IntegrateNodeEntity entity) {
        if (StringUtil.isEmpty((String)((String)entity.getId()))) {
            entity.setId((Object)RandomUtil.uuId());
        }
        entity.setIsRetry(Integer.valueOf(1));
        entity.setCreatorTime(new Date());
        entity.setCreatorUserId(UserProvider.getUser().getUserId());
        entity.setEnabledMark(Integer.valueOf(1));
        this.save(entity);
    }

    @Override
    public void update(String taskId, String nodeCode) {
        UpdateWrapper queryWrapper = new UpdateWrapper();
        queryWrapper.lambda().eq(IntegrateNodeEntity::getTaskId, (Object)taskId);
        queryWrapper.lambda().eq(IntegrateNodeEntity::getNodeCode, (Object)nodeCode);
        queryWrapper.lambda().set(IntegrateNodeEntity::getIsRetry, (Object)0);
        this.update((Wrapper)queryWrapper);
    }

    @Override
    public Boolean update(String id, IntegrateNodeEntity entity) {
        entity.setId((Object)id);
        entity.setLastModifyTime(new Date());
        entity.setLastModifyUserId(UserProvider.getUser().getUserId());
        return this.updateById(entity);
    }

    @Override
    public void delete(IntegrateNodeEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)entity.getId());
        }
    }

    @Override
    public void delete(String taskId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(IntegrateNodeEntity::getTaskId, (Object)taskId);
        this.remove((Wrapper)queryWrapper);
    }
}

