/*
 * Decompiled with CFR 0.152.
 */
package jnpf.integrate.job;

import java.util.Date;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzUtil {
    private static final Logger log = LoggerFactory.getLogger(QuartzUtil.class);
    private static final SchedulerFactory schedulerFactory = new StdSchedulerFactory();

    public static void addJob(String jobName, String cron, Class<? extends Job> jobClass, JobDataMap jobDataMap, Date startDate, Date endDate) {
        if (jobDataMap == null) {
            jobDataMap = new JobDataMap();
        }
        JobDetail jobDetail = JobBuilder.newJob(jobClass).withIdentity(jobName).setJobData(jobDataMap).build();
        Trigger trigger = TriggerBuilder.newTrigger().forJob(jobDetail).withIdentity(jobName).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).startAt(startDate == null ? new Date() : startDate).endAt(endDate != null ? endDate : null).build();
        try {
            Scheduler scheduler = QuartzUtil.getScheduler();
            scheduler.scheduleJob(jobDetail, trigger);
            if (!scheduler.isShutdown()) {
                scheduler.start();
            }
        }
        catch (SchedulerException e) {
            log.error("\u65b0\u589e\u8c03\u5ea6\u5931\u8d25:" + e.getMessage());
        }
    }

    private static Scheduler getScheduler() {
        try {
            return schedulerFactory.getScheduler();
        }
        catch (SchedulerException e) {
            e.getMessage();
            return null;
        }
    }

    public static void deleteJob(String jobName) {
        try {
            TriggerKey triggerKey = TriggerKey.triggerKey((String)jobName);
            Scheduler scheduler = QuartzUtil.getScheduler();
            scheduler.pauseTrigger(triggerKey);
            scheduler.unscheduleJob(triggerKey);
            scheduler.deleteJob(JobKey.jobKey((String)jobName));
        }
        catch (SchedulerException e) {
            log.error("\u5220\u9664\u8c03\u5ea6\u5931\u8d25:" + e.getMessage());
        }
    }

    private static boolean isTriKey(String jobName) {
        boolean flag = false;
        try {
            Scheduler sched = schedulerFactory.getScheduler();
            TriggerKey triggerKey = TriggerKey.triggerKey((String)jobName);
            CronTrigger trigger = (CronTrigger)sched.getTrigger(triggerKey);
            flag = trigger != null;
        }
        catch (Exception e) {
            e.getMessage();
        }
        return flag;
    }
}

