/*
 * Decompiled with CFR 0.152.
 */
package jnpf.integrate.job;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import jnpf.base.UserInfo;
import jnpf.config.ConfigValueUtil;
import jnpf.database.util.TenantDataSourceUtil;
import jnpf.exception.TenantInvalidException;
import jnpf.integrate.entity.IntegrateQueueEntity;
import jnpf.integrate.job.IntegrateJobUtil;
import jnpf.integrate.model.nodeJson.IntegrateModel;
import jnpf.integrate.service.IntegrateQueueService;
import jnpf.integrate.util.IntegrateHttpModel;
import jnpf.util.AuthUtil;
import jnpf.util.JsonUtil;
import jnpf.util.RedisUtil;
import jnpf.util.StringUtil;
import jnpf.util.UserProvider;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.quartz.QuartzJobBean;

@DisallowConcurrentExecution
public class IntegrateQueryJobUtil
extends QuartzJobBean {
    private static final Logger log = LoggerFactory.getLogger(IntegrateQueryJobUtil.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private IntegrateQueueService integrateQueueService;
    public static Map<String, ScheduledFuture> futureList = new HashMap<String, ScheduledFuture>();
    private static ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = null;

    IntegrateQueryJobUtil(ThreadPoolTaskExecutor threadPoolTaskExecutor) {
        if (scheduledThreadPoolExecutor == null) {
            scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(20, threadPoolTaskExecutor.getThreadPoolExecutor().getThreadFactory());
        }
    }

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        List hashValues = this.redisUtil.getHashValues("idgenerator_IntegrateList");
        for (String id : hashValues) {
            String tenantId;
            UserInfo userInfo = (UserInfo)JsonUtil.getJsonToBean((String)id, UserInfo.class);
            String string = tenantId = StringUtil.isNotEmpty((String)userInfo.getTenantId()) ? userInfo.getTenantId() : "jnpf";
            boolean useSuccess = this.redisTemplate.opsForValue().setIfAbsent((Object)("idgenerator_IntegrateList_key:" + tenantId), (Object)System.currentTimeMillis(), 3600L, TimeUnit.SECONDS);
            if (!useSuccess || futureList.get(tenantId) != null) continue;
            ScheduledFuture<?> scheduledFuture = scheduledThreadPoolExecutor.scheduleAtFixedRate(new Task(userInfo), 0L, 1L, TimeUnit.SECONDS);
            futureList.put(tenantId, scheduledFuture);
        }
    }

    class Task
    implements Runnable {
        private UserInfo userInfo;

        public Task(UserInfo userInfo) {
            this.userInfo = userInfo;
        }

        @Override
        public void run() {
            List<IntegrateQueueEntity> list;
            String tenantId;
            block5: {
                String string = tenantId = StringUtil.isNotEmpty((String)this.userInfo.getTenantId()) ? this.userInfo.getTenantId() : "jnpf";
                if (IntegrateQueryJobUtil.this.configValueUtil.isMultiTenancy()) {
                    try {
                        TenantDataSourceUtil.switchTenant((String)this.userInfo.getTenantId());
                    }
                    catch (TenantInvalidException e) {
                        log.error("Task, \u79df\u6237\u65e0\u6548, \u5220\u9664\u4efb\u52a1\uff1a{}", (Object)this.userInfo.getTenantId());
                        IntegrateJobUtil.removeTenant(this.userInfo.getTenantId(), IntegrateQueryJobUtil.this.redisUtil);
                        ScheduledFuture scheduledFuture = futureList.get(this.userInfo.getTenantId());
                        if (scheduledFuture == null) break block5;
                        scheduledFuture.cancel(true);
                    }
                }
            }
            if ((list = IntegrateQueryJobUtil.this.integrateQueueService.getList()).size() > 0) {
                String token = AuthUtil.loginTempUser((String)this.userInfo.getUserId(), (String)this.userInfo.getTenantId(), (boolean)true);
                String url = IntegrateQueryJobUtil.this.configValueUtil.getApiDomain() + "/api/visualdev/Integrate/executeQuery";
                for (IntegrateQueueEntity entity : list) {
                    IntegrateModel model = new IntegrateModel();
                    model.setUserInfo(this.userInfo);
                    model.setId((String)entity.getId());
                    boolean integrate = IntegrateJobUtil.getIntegrate(model, IntegrateQueryJobUtil.this.redisUtil);
                    boolean useSuccess = IntegrateQueryJobUtil.this.redisTemplate.opsForValue().setIfAbsent((Object)("idgenerator_IntegrateList_key:" + (String)entity.getId()), (Object)System.currentTimeMillis(), 3600L, TimeUnit.SECONDS);
                    if (!integrate || !useSuccess) continue;
                    System.out.println("\u6267\u884c\u4e00\u7ec4\u8c03\u5ea6\u5f00\u59cb----------------------------");
                    IntegrateHttpModel httpModel = new IntegrateHttpModel();
                    httpModel.setUserInfo(UserProvider.getUser((String)token));
                    httpModel.setId((String)entity.getId());
                    HttpRequest request = HttpRequest.of((String)url).method(Method.POST).body(JsonUtil.getObjectToString((Object)httpModel));
                    request.header("Authorization", token);
                    request.execute().body();
                    System.out.println("\u6267\u884c\u4e00\u7ec4\u8c03\u5ea6\u7ed3\u675f----------------------------");
                }
            }
            IntegrateQueryJobUtil.this.redisTemplate.delete((Object)("idgenerator_IntegrateList_key:" + tenantId));
        }
    }
}

