/*
 * Decompiled with CFR 0.152.
 */
package jnpf.integrate.job;

import java.util.Date;
import java.util.Objects;
import jnpf.base.UserInfo;
import jnpf.config.ConfigValueUtil;
import jnpf.database.util.TenantDataSourceUtil;
import jnpf.exception.TenantInvalidException;
import jnpf.integrate.entity.IntegrateEntity;
import jnpf.integrate.entity.IntegrateQueueEntity;
import jnpf.integrate.job.IntegrateJobUtil;
import jnpf.integrate.job.QuartzUtil;
import jnpf.integrate.model.nodeJson.IntegrateModel;
import jnpf.integrate.service.IntegrateQueueService;
import jnpf.integrate.service.IntegrateService;
import jnpf.util.JsonUtil;
import jnpf.util.RandomUtil;
import jnpf.util.RedisUtil;
import jnpf.util.context.SpringContext;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;

@DisallowConcurrentExecution
public class Integrate
extends QuartzJobBean {
    private static final Logger log = LoggerFactory.getLogger(Integrate.class);
    private static RedisUtil redisUtil = (RedisUtil)SpringContext.getBean(RedisUtil.class);
    private static ConfigValueUtil configValueUtil = (ConfigValueUtil)SpringContext.getBean(ConfigValueUtil.class);
    private static IntegrateService integrateService = (IntegrateService)SpringContext.getBean(IntegrateService.class);
    private static IntegrateQueueService integrateQueueService = (IntegrateQueueService)SpringContext.getBean(IntegrateQueueService.class);

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        IntegrateModel integrateModel;
        JobDetail jobDetail = context.getJobDetail();
        String jobName = jobDetail.getKey().getName();
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        IntegrateModel model = IntegrateJobUtil.getModel((IntegrateModel)JsonUtil.getJsonToBean((Object)jobDataMap, IntegrateModel.class), redisUtil);
        boolean isModel = model == null;
        IntegrateModel integrateModel2 = integrateModel = isModel ? (IntegrateModel)JsonUtil.getJsonToBean((Object)jobDataMap, IntegrateModel.class) : model;
        if (integrateModel != null) {
            IntegrateEntity info;
            UserInfo userInfo = integrateModel.getUserInfo();
            if (configValueUtil.isMultiTenancy()) {
                try {
                    TenantDataSourceUtil.switchTenant((String)userInfo.getTenantId());
                }
                catch (TenantInvalidException e) {
                    log.error("Integrate, \u79df\u6237\u65e0\u6548, \u5220\u9664\u4efb\u52a1\uff1a{}", (Object)userInfo.getTenantId());
                    IntegrateJobUtil.removeModel(integrateModel, redisUtil);
                    QuartzUtil.deleteJob(jobName);
                    return;
                }
            }
            if ((info = integrateService.getInfo(integrateModel.getId())) != null) {
                integrateModel.setTime(Long.valueOf(System.currentTimeMillis()));
                Integer num = integrateModel.getNum();
                Integer endTimeType = integrateModel.getEndTimeType();
                Integer endLimit = integrateModel.getEndLimit();
                boolean isNext = Objects.equals(endTimeType, 1) ? num + 1 <= endLimit : (Objects.equals(endTimeType, 2) ? integrateModel.getTime() <= integrateModel.getEndTime() : true);
                num = num + 1;
                integrateModel.setNum(num);
                if (isNext) {
                    IntegrateJobUtil.insertModel(integrateModel, redisUtil);
                    IntegrateQueueEntity entity = new IntegrateQueueEntity();
                    entity.setState(Integer.valueOf(0));
                    entity.setId((Object)RandomUtil.uuId());
                    entity.setIntegrateId(integrateModel.getId());
                    entity.setExecutionTime(new Date());
                    entity.setFullName(info.getFullName());
                    IntegrateModel integrate = new IntegrateModel();
                    integrate.setId((String)entity.getId());
                    integrate.setUserInfo(userInfo);
                    IntegrateJobUtil.insertIntegrate(integrate, redisUtil);
                    integrateQueueService.create(entity);
                } else {
                    IntegrateJobUtil.removeModel(integrateModel, redisUtil);
                    QuartzUtil.deleteJob(jobName);
                }
            } else {
                IntegrateJobUtil.removeModel(integrateModel, redisUtil);
                QuartzUtil.deleteJob(jobName);
            }
        }
    }
}

