/*
 * Decompiled with CFR 0.152.
 */
package jnpf.generater.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jnpf.base.UserInfo;
import jnpf.base.entity.VisualdevEntity;
import jnpf.base.mapper.VisualdevMapper;
import jnpf.base.model.DownloadCodeForm;
import jnpf.base.model.VisualWebTypeEnum;
import jnpf.base.service.DbLinkService;
import jnpf.base.service.SuperServiceImpl;
import jnpf.base.service.SysconfigService;
import jnpf.base.service.VisualAliasService;
import jnpf.base.util.VisualUtils;
import jnpf.base.util.common.AliasModel;
import jnpf.base.util.common.GenerateCommon;
import jnpf.base.util.common.GenerateParamModel;
import jnpf.base.util.custom.VelocityEnum;
import jnpf.config.ConfigValueUtil;
import jnpf.database.model.entity.DbLinkEntity;
import jnpf.database.model.interfaces.DbSourceOrDbLink;
import jnpf.database.util.DataSourceUtil;
import jnpf.generater.factory.CodeGenerateFactoryV3;
import jnpf.generater.model.FormDesign.TemplateMethodEnum;
import jnpf.generater.service.VisualdevGenService;
import jnpf.model.FileListVO;
import jnpf.model.OnlineDevData;
import jnpf.model.visualJson.TableModel;
import jnpf.util.DateUtil;
import jnpf.util.FileUploadUtils;
import jnpf.util.JsonUtil;
import jnpf.util.StringUtil;
import jnpf.util.UserProvider;
import org.apache.velocity.app.Velocity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VisualdevGenServiceImpl
extends SuperServiceImpl<VisualdevMapper, VisualdevEntity>
implements VisualdevGenService {
    @Autowired
    private DataSourceUtil dataSourceUtil;
    @Autowired
    private DbLinkService dataSourceApi;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private CodeGenerateFactoryV3 GenerateFactoryV3;
    @Autowired
    private SysconfigService sysconfigService;
    @Autowired
    private VisualAliasService aliasService;

    @Override
    public String codeGengerateV3(VisualdevEntity entity, DownloadCodeForm downloadCodeForm) throws Exception {
        UserInfo userInfo = UserProvider.getUser();
        DbLinkEntity linkEntity = null;
        if (entity != null) {
            Velocity.reset();
            VelocityEnum.init.initVelocity(GenerateCommon.getLocalBasePath() + this.configValueUtil.getTemplateCodePathVue3());
            if (VisualWebTypeEnum.DATA_VIEW.getType().equals(entity.getWebType())) {
                String fileName = entity.getFullName() + "_" + DateUtil.nowDateTime();
                String mainClass = "St" + entity.getEnCode();
                downloadCodeForm.setMainClassName(mainClass);
                new GenerateParamModel();
                GenerateParamModel generateParamModel = GenerateParamModel.builder().path(GenerateCommon.getLocalBasePath() + this.configValueUtil.getTemplateCodePathVue3()).fileName(fileName).downloadCodeForm(downloadCodeForm).entity(entity).userInfo(userInfo).configValueUtil(this.configValueUtil).className(mainClass).templatesPath(TemplateMethodEnum.T6.getMethod()).template7Model(GenerateCommon.getTemplate7Model((List)this.sysconfigService.getList("SysConfig"))).build();
                this.GenerateFactoryV3.runGenerator(TemplateMethodEnum.T6.getMethod(), generateParamModel);
                return fileName;
            }
            if (StringUtil.isNotEmpty((String)entity.getDbLinkId())) {
                linkEntity = this.dataSourceApi.getInfo(entity.getDbLinkId());
            }
            if (StringUtil.isNotEmpty((String)entity.getVisualTables())) {
                String fileName = entity.getFullName() + "_" + DateUtil.nowDateTime();
                List list = JsonUtil.getJsonToList((String)entity.getVisualTables(), TableModel.class);
                Map tableAliasMap = this.aliasService.getAllFiledsAlias((String)entity.getId());
                String mainTable = ((TableModel)list.stream().filter(t -> "1".equals(t.getTypeId())).findFirst().orElse(null)).getTable();
                Map fieldsMap = ((AliasModel)tableAliasMap.get(mainTable)).getFieldsMap();
                String pKeyName = VisualUtils.getpKey((DbSourceOrDbLink)linkEntity, (String)mainTable);
                String modulePackageName = StringUtil.isNotEmpty((String)downloadCodeForm.getModulePackageName()) ? downloadCodeForm.getModulePackageName() : "jnpf";
                downloadCodeForm.setModulePackageName(modulePackageName);
                downloadCodeForm.setMainClassName(((AliasModel)tableAliasMap.get(mainTable)).getAliasName());
                HashMap<String, String> childpKeyMap = new HashMap<String, String>(16);
                for (TableModel tableModel : list) {
                    String childKey = VisualUtils.getpKey((DbSourceOrDbLink)linkEntity, (String)tableModel.getTable());
                    if (childKey.length() > 2 && "f_".equals(childKey.substring(0, 2).toLowerCase())) {
                        childKey = childKey.substring(2);
                    }
                    childpKeyMap.put(tableModel.getTable(), childKey);
                }
                String templatesPath = null;
                if (OnlineDevData.FORM_TYPE_DEV.equals(entity.getType())) {
                    switch (entity.getWebType()) {
                        case 1: {
                            templatesPath = downloadCodeForm.getEnableFlow() == 1 ? TemplateMethodEnum.T5.getMethod() : TemplateMethodEnum.T4.getMethod();
                            break;
                        }
                        case 2: {
                            templatesPath = downloadCodeForm.getEnableFlow() == 1 ? TemplateMethodEnum.T3.getMethod() : TemplateMethodEnum.T2.getMethod();
                            break;
                        }
                    }
                }
                if (!FileUploadUtils.getDefaultPlatform().startsWith("local")) {
                    ArrayList fileList = new ArrayList();
                    fileList.addAll(FileUploadUtils.getDefaultFileList((String)this.configValueUtil.getTemplateCodePathVue3()));
                    String basePath = FileUploadUtils.getBasePath();
                    for (FileListVO fileListVO : fileList) {
                        String eachFileName = fileListVO.getFileName();
                        int index = eachFileName.lastIndexOf("/");
                        String floderName = eachFileName.substring(0, index + 1);
                        if (StringUtil.isNotEmpty((String)basePath) && floderName.contains(basePath)) {
                            floderName = floderName.substring(basePath.length());
                        }
                        String filePath = FileUploadUtils.getLocalBasePath() + floderName;
                        String objectName = eachFileName.substring(index + 1);
                        FileUploadUtils.downLocal((String)floderName, (String)filePath, (String)objectName);
                    }
                }
                new GenerateParamModel();
                GenerateParamModel generateParamModel = GenerateParamModel.builder().dataSourceUtil(this.dataSourceUtil).path(GenerateCommon.getLocalBasePath() + this.configValueUtil.getTemplateCodePathVue3()).fileName(fileName).templatesPath(templatesPath).downloadCodeForm(downloadCodeForm).entity(entity).userInfo(userInfo).configValueUtil(this.configValueUtil).linkEntity(linkEntity).pKeyNameOriginal(pKeyName).pKeyName((String)fieldsMap.get(pKeyName)).template7Model(GenerateCommon.getTemplate7Model((List)this.sysconfigService.getList("SysConfig"))).tableAliseMap(tableAliasMap).build();
                this.GenerateFactoryV3.runGenerator(templatesPath, generateParamModel);
                return fileName;
            }
        }
        return null;
    }
}

