/*
 * Decompiled with CFR 0.152.
 */
package jnpf.base.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import cn.dev33.satoken.annotation.SaMode;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.stream.Collectors;
import jnpf.base.ActionResult;
import jnpf.base.UserInfo;
import jnpf.base.controller.SuperController;
import jnpf.base.entity.DataInterfaceEntity;
import jnpf.base.entity.DictionaryDataEntity;
import jnpf.base.entity.VisualdevEntity;
import jnpf.base.entity.VisualdevReleaseEntity;
import jnpf.base.model.FormDataField;
import jnpf.base.model.PaginationVisualdev;
import jnpf.base.model.Template6.BtnData;
import jnpf.base.model.VisualDevCrForm;
import jnpf.base.model.VisualDevInfoVO;
import jnpf.base.model.VisualDevListVO;
import jnpf.base.model.VisualDevPubModel;
import jnpf.base.model.VisualDevUpForm;
import jnpf.base.model.VisualFunctionModel;
import jnpf.base.model.VisualWebTypeEnum;
import jnpf.base.model.VisualdevTreeChildModel;
import jnpf.base.model.VisualdevTreeVO;
import jnpf.base.model.module.ModuleNameVO;
import jnpf.base.model.online.VisualMenuModel;
import jnpf.base.service.DataInterfaceService;
import jnpf.base.service.DictionaryDataService;
import jnpf.base.service.FilterService;
import jnpf.base.service.ModuleService;
import jnpf.base.service.VisualAliasService;
import jnpf.base.service.VisualdevReleaseService;
import jnpf.base.service.VisualdevService;
import jnpf.base.util.VisualUtil;
import jnpf.base.util.visualUtil.PubulishUtil;
import jnpf.base.vo.ListVO;
import jnpf.base.vo.PageListVO;
import jnpf.base.vo.PaginationVO;
import jnpf.constant.GenerateConstant;
import jnpf.constant.MsgCode;
import jnpf.exception.DataException;
import jnpf.exception.WorkFlowException;
import jnpf.flowable.model.template.FlowByFormModel;
import jnpf.model.OnlineDevData;
import jnpf.model.visualJson.FieLdsModel;
import jnpf.model.visualJson.FormCloumnUtil;
import jnpf.model.visualJson.FormDataModel;
import jnpf.model.visualJson.TableModel;
import jnpf.model.visualJson.analysis.RecursionForm;
import jnpf.onlinedev.model.PaginationModel;
import jnpf.onlinedev.service.VisualdevModelDataService;
import jnpf.onlinedev.util.onlineDevUtil.OnlinePublicUtils;
import jnpf.permission.entity.UserEntity;
import jnpf.permission.service.UserService;
import jnpf.util.JsonUtil;
import jnpf.util.JsonUtilEx;
import jnpf.util.RandomUtil;
import jnpf.util.StringUtil;
import jnpf.util.UserProvider;
import jnpf.util.enums.DictionaryDataEnum;
import jnpf.workflow.service.TemplateApi;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u53ef\u89c6\u5316\u57fa\u7840\u6a21\u5757", description="Base")
@RestController
@RequestMapping(value={"/api/visualdev/Base"})
public class VisualdevController
extends SuperController<VisualdevService, VisualdevEntity> {
    @Autowired
    private VisualdevService visualdevService;
    @Autowired
    private VisualdevReleaseService visualdevReleaseService;
    @Autowired
    private UserService userService;
    @Autowired
    private DictionaryDataService dictionaryDataApi;
    @Autowired
    private VisualdevModelDataService visualdevModelDataService;
    @Autowired
    private PubulishUtil pubulishUtil;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private DataInterfaceService dataInterFaceApi;
    @Autowired
    private FilterService filterService;
    @Autowired
    private VisualAliasService aliasService;
    @Autowired
    private TemplateApi templateApi;

    @Operation(summary="\u83b7\u53d6\u529f\u80fd\u5217\u8868")
    @GetMapping
    @SaCheckPermission(value={"onlineDev.webDesign", "generator.webForm", "generator.flowForm"}, mode=SaMode.OR)
    public ActionResult<PageListVO<VisualFunctionModel>> list(PaginationVisualdev paginationVisualdev) {
        List data = this.visualdevService.getList(paginationVisualdev);
        List userId = data.stream().map(t -> t.getCreatorUserId()).collect(Collectors.toList());
        List lastUserId = data.stream().map(t -> t.getLastModifyUserId()).collect(Collectors.toList());
        List userEntities = this.userService.getUserName(userId);
        List lastUserIdEntities = this.userService.getUserName(lastUserId);
        List dictionList = this.dictionaryDataApi.getListByTypeDataCode(DictionaryDataEnum.VISUALDEV.getDictionaryTypeId());
        LinkedList<VisualFunctionModel> modelAll = new LinkedList<VisualFunctionModel>();
        for (VisualdevEntity entity : data) {
            VisualFunctionModel model = (VisualFunctionModel)JsonUtil.getJsonToBean((Object)entity, VisualFunctionModel.class);
            DictionaryDataEntity dataEntity = dictionList.stream().filter(t -> ((String)t.getId()).equals(entity.getCategory())).findFirst().orElse(null);
            model.setCategory(dataEntity != null ? dataEntity.getFullName() : null);
            UserEntity creatorUser = userEntities.stream().filter(t -> ((String)t.getId()).equals(model.getCreatorUserId())).findFirst().orElse(null);
            model.setCreatorUser((String)(creatorUser != null ? creatorUser.getRealName() + "/" + creatorUser.getAccount() : ""));
            UserEntity lastmodifyuser = lastUserIdEntities.stream().filter(t -> ((String)t.getId()).equals(model.getLastModifyUserId())).findFirst().orElse(null);
            model.setLastModifyUser((String)(lastmodifyuser != null ? lastmodifyuser.getRealName() + "/" + lastmodifyuser.getAccount() : ""));
            model.setIsRelease(entity.getState());
            model.setHasPackage(true);
            modelAll.add(model);
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)paginationVisualdev, PaginationVO.class);
        return ActionResult.page(modelAll, (PaginationVO)paginationVO);
    }

    @Operation(summary="\u83b7\u53d6\u529f\u80fd\u5217\u8868")
    @GetMapping(value={"/list"})
    public ActionResult<PageListVO<VisualDevListVO>> getList(PaginationVisualdev paginationVisualdev) {
        List data = this.visualdevService.getPageList(paginationVisualdev);
        List modelAll = JsonUtil.getJsonToList((Object)data, VisualDevListVO.class);
        if (paginationVisualdev.getFlowStart().booleanValue()) {
            List flowFormStart = this.templateApi.getFormList();
            for (VisualDevListVO item : modelAll) {
                if (!Objects.equals(item.getType(), 2)) continue;
                boolean contains = flowFormStart.contains(item.getId());
                item.setIsQuote(Integer.valueOf(contains ? 1 : 0));
            }
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)paginationVisualdev, PaginationVO.class);
        return ActionResult.page((List)modelAll, (PaginationVO)paginationVO);
    }

    @Operation(summary="\u83b7\u53d6\u529f\u80fd\u5217\u8868\u4e0b\u62c9\u6846")
    @Parameters(value={@Parameter(name="type", description="\u7c7b\u578b(1-\u8868\u5355\u8bbe\u8ba1\uff0c2-\u7cfb\u7edf\u8868\u5355)"), @Parameter(name="isRelease", description="\u662f\u5426\u53d1\u5e03"), @Parameter(name="webType", description="\u9875\u9762\u7c7b\u578b\uff081\u3001\u7eaf\u8868\u5355\uff0c2\u3001\u8868\u5355\u52a0\u5217\u8868\uff0c3\u3001\u8868\u5355\u5217\u8868\u5de5\u4f5c\u6d41\u30014\u3001\u6570\u636e\u89c6\u56fe\uff09"), @Parameter(name="enableFlow", description="\u662f\u5426\u542f\u7528\u6d41\u7a0b")})
    @GetMapping(value={"/Selector"})
    public ActionResult selectorList(Integer type, Integer isRelease, String webType, Integer enableFlow) {
        List allList;
        List<Object> list = new ArrayList();
        if (isRelease != null) {
            List releaseEntities = this.visualdevReleaseService.selectorList();
            allList = JsonUtil.getJsonToList((Object)releaseEntities, VisualdevEntity.class);
        } else {
            allList = this.visualdevService.selectorList();
        }
        if (webType != null) {
            String[] webTypes;
            for (String string : webTypes = webType.split(",")) {
                List collect = allList.stream().filter(l -> l.getWebType().equals(Integer.valueOf(wbType))).collect(Collectors.toList());
                list.addAll(collect);
            }
        } else {
            list = allList;
        }
        List dataEntityList = new ArrayList();
        ArrayList<VisualdevTreeVO> voList = new ArrayList<VisualdevTreeVO>();
        HashSet<String> cate = new HashSet<String>(16);
        if (type != null) {
            list = list.stream().filter(t -> type.equals(t.getType())).collect(Collectors.toList());
            dataEntityList = this.dictionaryDataApi.getListByTypeDataCode(DictionaryDataEnum.getTypeId((Integer)type));
            for (DictionaryDataEntity dictionaryDataEntity : dataEntityList) {
                List num = list.stream().filter(t -> ((String)dataEntity.getId()).equals(t.getCategory())).collect(Collectors.toList());
                if (num.size() <= 0) continue;
                i = cate.size();
                cate.add((String)dictionaryDataEntity.getId());
                if (cate.size() != i + 1) continue;
                VisualdevTreeVO visualdevTreeVO = new VisualdevTreeVO();
                visualdevTreeVO.setId((String)dictionaryDataEntity.getId());
                visualdevTreeVO.setFullName(dictionaryDataEntity.getFullName());
                visualdevTreeVO.setHasChildren(Boolean.valueOf(true));
                voList.add(visualdevTreeVO);
            }
        } else {
            for (VisualdevEntity visualdevEntity : list) {
                DictionaryDataEntity dataEntity = this.dictionaryDataApi.getInfo(visualdevEntity.getCategory());
                if (dataEntity == null) continue;
                i = cate.size();
                cate.add((String)dataEntity.getId());
                if (cate.size() != i + 1) continue;
                VisualdevTreeVO visualdevTreeVO = new VisualdevTreeVO();
                visualdevTreeVO.setId(visualdevEntity.getCategory());
                visualdevTreeVO.setFullName(dataEntity.getFullName());
                visualdevTreeVO.setHasChildren(Boolean.valueOf(true));
                voList.add(visualdevTreeVO);
            }
        }
        for (VisualdevTreeVO visualdevTreeVO : voList) {
            ArrayList<VisualdevTreeChildModel> visualdevTreeChildModelList = new ArrayList<VisualdevTreeChildModel>();
            for (VisualdevEntity visualdevEntity : list) {
                if (!visualdevTreeVO.getId().equals(visualdevEntity.getCategory())) continue;
                VisualdevTreeChildModel model = (VisualdevTreeChildModel)JsonUtil.getJsonToBean((Object)visualdevEntity, VisualdevTreeChildModel.class);
                visualdevTreeChildModelList.add(model);
            }
            visualdevTreeVO.setChildren(visualdevTreeChildModelList);
        }
        ListVO listVO = new ListVO();
        listVO.setList(voList);
        return ActionResult.success((Object)listVO);
    }

    @Operation(summary="\u83b7\u53d6\u529f\u80fd\u4fe1\u606f")
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e")})
    @GetMapping(value={"/{id}"})
    @SaCheckPermission(value={"onlineDev.webDesign", "generator.webForm", "generator.flowForm"}, mode=SaMode.OR)
    public ActionResult info(@PathVariable(value="id") String id) throws DataException {
        DataInterfaceEntity info;
        UserInfo userInfo = UserProvider.getUser();
        VisualdevEntity entity = this.visualdevService.getInfo(id);
        VisualDevInfoVO vo = (VisualDevInfoVO)JsonUtilEx.getJsonToBeanEx((Object)entity, VisualDevInfoVO.class);
        if (StringUtil.isNotEmpty((String)entity.getInterfaceId()) && (info = this.dataInterFaceApi.getInfo(entity.getInterfaceId())) != null) {
            vo.setInterfaceName(info.getFullName());
        }
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u83b7\u53d6\u8868\u5355\u4e3b\u8868\u5c5e\u6027\u4e0b\u62c9\u6846")
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e"), @Parameter(name="filterType", description="\u8fc7\u6ee4\u7c7b\u578b\uff1a1-\u6309\u952e\u4e8b\u4ef6\u9009\u62e9\u5b57\u6bb5\u5217\u8868\u8fc7\u6ee4")})
    @GetMapping(value={"/{id}/FormDataFields"})
    @SaCheckPermission(value={"onlineDev.webDesign"})
    public ActionResult<ListVO<FormDataField>> getFormData(@PathVariable(value="id") String id, @RequestParam(value="filterType", required=false) Integer filterType) {
        List fieldList = this.visualdevModelDataService.fieldList(id, filterType);
        ListVO listVO = new ListVO();
        listVO.setList(fieldList);
        return ActionResult.success((Object)listVO);
    }

    @Operation(summary="\u5173\u8054\u6570\u636e\u5206\u9875\u6570\u636e")
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e")})
    @GetMapping(value={"/{id}/FieldDataSelect"})
    public ActionResult getFormData(@PathVariable(value="id") String id, PaginationModel paginationModel) {
        VisualdevEntity entity = this.visualdevService.getReleaseInfo(id);
        List realList = this.visualdevModelDataService.getPageList(entity, paginationModel);
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)paginationModel, PaginationVO.class);
        return ActionResult.page((List)realList, (PaginationVO)paginationVO);
    }

    @Operation(summary="\u590d\u5236\u529f\u80fd")
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e")})
    @PostMapping(value={"/{id}/Actions/Copy"})
    @SaCheckPermission(value={"onlineDev.webDesign", "generator.webForm", "generator.flowForm"}, mode=SaMode.OR)
    public ActionResult copyInfo(@PathVariable(value="id") String id) throws WorkFlowException {
        VisualdevEntity entity;
        VisualdevReleaseEntity releaseEntity = (VisualdevReleaseEntity)this.visualdevReleaseService.getById((Serializable)((Object)id));
        boolean b = releaseEntity != null;
        String uuid = RandomUtil.uuId();
        if (b) {
            entity = (VisualdevEntity)JsonUtil.getJsonToBean((Object)releaseEntity, VisualdevEntity.class);
            this.aliasService.copy((String)releaseEntity.getId(), uuid);
        } else {
            entity = this.visualdevService.getInfo(id);
        }
        String copyNum = UUID.randomUUID().toString().substring(0, 5);
        entity.setFullName(entity.getFullName() + ".\u526f\u672c" + copyNum);
        entity.setLastModifyTime(null);
        entity.setLastModifyUserId(null);
        entity.setCreatorTime(null);
        entity.setId((Object)uuid);
        entity.setEnCode(entity.getEnCode() + copyNum);
        VisualdevEntity entity1 = (VisualdevEntity)JsonUtil.getJsonToBean((Object)entity, VisualdevEntity.class);
        if (entity1.getEnCode().length() > 50 || entity1.getFullName().length() > 50) {
            return ActionResult.fail((String)MsgCode.PRI006.get(new Object[0]));
        }
        this.visualdevService.create(entity1);
        return ActionResult.success((String)MsgCode.SU007.get(new Object[0]));
    }

    @Operation(summary="\u66f4\u65b0\u529f\u80fd\u72b6\u6001")
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e")})
    @PutMapping(value={"/{id}/Actions/State"})
    @SaCheckPermission(value={"onlineDev.webDesign", "generator.webForm", "generator.flowForm"}, mode=SaMode.OR)
    public ActionResult update(@PathVariable(value="id") String id) throws Exception {
        boolean flag;
        VisualdevEntity entity = this.visualdevService.getInfo(id);
        if (entity != null && !(flag = this.visualdevService.update((String)entity.getId(), entity))) {
            return ActionResult.fail((String)MsgCode.FA002.get(new Object[0]));
        }
        return ActionResult.success((String)MsgCode.SU004.get(new Object[0]));
    }

    @Operation(summary="\u65b0\u5efa\u529f\u80fd")
    @PostMapping
    @SaCheckPermission(value={"onlineDev.webDesign", "generator.webForm", "generator.flowForm"}, mode=SaMode.OR)
    public ActionResult create(@RequestBody VisualDevCrForm visualDevCrForm) throws Exception {
        VisualdevEntity entity = (VisualdevEntity)JsonUtil.getJsonToBean((String)JsonUtilEx.getObjectToString((Object)visualDevCrForm), VisualdevEntity.class);
        if (GenerateConstant.containKeyword((String)entity.getFullName())) {
            return ActionResult.fail((String)("\u8868\u5355\u540d\u79f0" + MsgCode.SYS128.get(new Object[]{entity.getFullName()})));
        }
        if (this.visualdevService.getObjByEncode(entity.getEnCode(), entity.getType()) > 0) {
            return ActionResult.fail((String)MsgCode.EXIST002.get(new Object[0]));
        }
        if (this.visualdevService.getCountByName(entity.getFullName(), entity.getType()) > 0) {
            return ActionResult.fail((String)MsgCode.EXIST001.get(new Object[0]));
        }
        if (!VisualWebTypeEnum.DATA_VIEW.getType().equals(entity.getWebType()) && !OnlineDevData.FORM_TYPE_SYS.equals(entity.getType())) {
            List tableModelList = JsonUtil.getJsonToList((String)entity.getVisualTables(), TableModel.class);
            FormDataModel formData = (FormDataModel)JsonUtil.getJsonToBean((String)entity.getFormData(), FormDataModel.class);
            RecursionForm recursionForm = new RecursionForm();
            if (ObjectUtil.isNotNull((Object)formData)) {
                if (tableModelList.size() > 0) {
                    boolean isIncre = Objects.equals(formData.getPrimaryKeyPolicy(), 2);
                    String strategy = !isIncre ? "[\u96ea\u82b1ID]" : "[\u81ea\u589e\u957fid]";
                    for (TableModel tableModel : tableModelList) {
                        Boolean isAutoIncre = this.visualdevService.getPrimaryDbField(entity.getDbLinkId(), tableModel.getTable());
                        if (isAutoIncre == null) {
                            return ActionResult.fail((String)MsgCode.FM011.get(new Object[]{tableModel.getTable()}));
                        }
                        if (isIncre == isAutoIncre) continue;
                        return ActionResult.fail((String)MsgCode.FM012.get(new Object[]{strategy, tableModel.getTable()}));
                    }
                }
                List list = JsonUtil.getJsonToList((String)formData.getFields(), FieLdsModel.class);
                recursionForm.setList(list);
                recursionForm.setTableModelList(tableModelList);
                if (FormCloumnUtil.repetition((RecursionForm)recursionForm, new ArrayList())) {
                    return ActionResult.fail((String)MsgCode.FM003.get(new Object[0]));
                }
                ArrayList fields = new ArrayList();
                OnlinePublicUtils.getAllFields(fields, (List)list);
                StringJoiner sj = new StringJoiner(",");
                for (FieLdsModel item : fields) {
                    if (!StringUtil.isNotEmpty((String)item.getVModel()) || !GenerateConstant.containKeyword((String)item.getVModel())) continue;
                    sj.add(item.getConfig().getLabel() + "-" + item.getVModel());
                }
                if (StringUtil.isNotEmpty((String)sj.toString())) {
                    return ActionResult.fail((String)MsgCode.SYS128.get(new Object[]{sj}));
                }
            }
        }
        if (StringUtil.isEmpty((String)((String)entity.getId()))) {
            entity.setId((Object)RandomUtil.uuId());
        }
        this.visualdevService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get(new Object[0]), (Object)((String)entity.getId()));
    }

    @Operation(summary="\u4fee\u6539\u529f\u80fd")
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e")})
    @PutMapping(value={"/{id}"})
    @SaCheckPermission(value={"onlineDev.webDesign", "generator.webForm", "generator.flowForm"}, mode=SaMode.OR)
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody VisualDevUpForm visualDevUpForm) throws Exception {
        boolean flag;
        VisualdevEntity visualdevEntity = this.visualdevService.getInfo(id);
        String enCode = visualdevEntity.getEnCode();
        String fullName = visualdevEntity.getFullName();
        VisualdevEntity entity = (VisualdevEntity)JsonUtil.getJsonToBean((String)JsonUtilEx.getObjectToString((Object)visualDevUpForm), VisualdevEntity.class);
        entity.setState(visualdevEntity.getState());
        if (GenerateConstant.containKeyword((String)entity.getFullName())) {
            return ActionResult.fail((String)("\u8868\u5355\u540d\u79f0" + MsgCode.SYS128.get(new Object[]{entity.getFullName()})));
        }
        if (!enCode.equals(visualDevUpForm.getEnCode()) && this.visualdevService.getObjByEncode(entity.getEnCode(), entity.getType()) > 0) {
            return ActionResult.fail((String)MsgCode.EXIST002.get(new Object[0]));
        }
        if (!fullName.equals(visualDevUpForm.getFullName()) && this.visualdevService.getCountByName(entity.getFullName(), entity.getType()) > 0) {
            return ActionResult.fail((String)MsgCode.EXIST001.get(new Object[0]));
        }
        VisualdevReleaseEntity releaseEntity = (VisualdevReleaseEntity)this.visualdevReleaseService.getById((Serializable)((Object)id));
        if (!VisualWebTypeEnum.DATA_VIEW.getType().equals(entity.getWebType()) && !OnlineDevData.FORM_TYPE_SYS.equals(entity.getType())) {
            Map tableMap = this.visualdevService.getTableMap(entity.getFormData());
            this.filterService.updateRuleList(id, entity, Integer.valueOf(1), Integer.valueOf(1), tableMap);
            List tableModelList = JsonUtil.getJsonToList((String)entity.getVisualTables(), TableModel.class);
            if (releaseEntity != null && !VisualWebTypeEnum.DATA_VIEW.getType().equals(releaseEntity.getWebType()) && tableModelList.size() == 0) {
                return ActionResult.fail((String)MsgCode.VS408.get(new Object[0]));
            }
            if (ObjectUtil.isNotNull((Object)entity.getFormData())) {
                FormDataModel formData = (FormDataModel)JsonUtil.getJsonToBean((String)entity.getFormData(), FormDataModel.class);
                List list = JsonUtil.getJsonToList((String)formData.getFields(), FieLdsModel.class);
                if (tableModelList.size() > 0) {
                    RecursionForm recursionForm = new RecursionForm();
                    recursionForm.setList(list);
                    recursionForm.setTableModelList(tableModelList);
                    if (FormCloumnUtil.repetition((RecursionForm)recursionForm, new ArrayList())) {
                        return ActionResult.fail((String)MsgCode.FM003.get(new Object[0]));
                    }
                }
                ArrayList fields = new ArrayList();
                OnlinePublicUtils.getAllFields(fields, (List)list);
                StringJoiner sj = new StringJoiner(",");
                for (FieLdsModel item : fields) {
                    if (!StringUtil.isNotEmpty((String)item.getVModel()) || !GenerateConstant.containKeyword((String)item.getVModel())) continue;
                    sj.add(item.getConfig().getLabel() + "-" + item.getVModel());
                }
                if (StringUtil.isNotEmpty((String)sj.toString())) {
                    return ActionResult.fail((String)MsgCode.SYS128.get(new Object[]{sj}));
                }
            }
        }
        boolean released = Objects.equals(visualdevEntity.getState(), 1);
        if (visualdevEntity != null && released) {
            entity.setState(Integer.valueOf(2));
        }
        if (!(flag = this.visualdevService.update(id, entity))) {
            return ActionResult.fail((String)MsgCode.FA002.get(new Object[0]));
        }
        return ActionResult.success((String)MsgCode.SU004.get(new Object[0]));
    }

    @Operation(summary="\u5220\u9664\u529f\u80fd")
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e")})
    @DeleteMapping(value={"/{id}"})
    @SaCheckPermission(value={"onlineDev.webDesign", "generator.webForm", "generator.flowForm"}, mode=SaMode.OR)
    public ActionResult delete(@PathVariable(value="id") String id) throws WorkFlowException {
        VisualdevEntity entity = this.visualdevService.getInfo(id);
        if (entity != null) {
            FlowByFormModel flowByFormId = this.templateApi.getFlowByFormId(id, Boolean.valueOf(false));
            if (flowByFormId != null && flowByFormId.getIsConfig().booleanValue()) {
                return ActionResult.fail((String)MsgCode.FM005.get(new Object[0]));
            }
            this.visualdevService.removeById((Serializable)((Object)id));
            this.visualdevReleaseService.removeById((Serializable)((Object)id));
            this.aliasService.removeByVisualId(id);
            return ActionResult.success((String)MsgCode.SU003.get(new Object[0]));
        }
        return ActionResult.fail((String)MsgCode.FA003.get(new Object[0]));
    }

    @Operation(summary="\u83b7\u53d6\u6a21\u677f\u6309\u94ae\u548c\u5217\u8868\u5b57\u6bb5")
    @Parameters(value={@Parameter(name="moduleId", description="\u6a21\u677fid")})
    @GetMapping(value={"/ModuleBtn"})
    @SaCheckPermission(value={"onlineDev.webDesign", "generator.webForm", "generator.flowForm"}, mode=SaMode.OR)
    public ActionResult getModuleBtn(String moduleId) {
        VisualdevEntity visualdevEntity = this.visualdevService.getInfo(moduleId);
        VisualUtil.delfKey((VisualdevEntity)visualdevEntity);
        ArrayList btnData = new ArrayList();
        Map column = JsonUtil.stringToMap((String)visualdevEntity.getColumnData());
        if (column.get("columnBtnsList") != null) {
            btnData.addAll(JsonUtil.getJsonToList((Object)JsonUtil.getJsonToListMap((String)column.get("columnBtnsList").toString()), BtnData.class));
        }
        if (column.get("btnsList") != null) {
            btnData.addAll(JsonUtil.getJsonToList((Object)JsonUtil.getJsonToListMap((String)column.get("btnsList").toString()), BtnData.class));
        }
        return ActionResult.success(btnData);
    }

    @Operation(summary="\u53d1\u5e03\u6a21\u677f")
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e")})
    @PostMapping(value={"/{id}/Actions/Release"})
    @SaCheckPermission(value={"onlineDev.webDesign", "generator.webForm", "generator.flowForm"}, mode=SaMode.OR)
    @DSTransactional(rollbackFor={Exception.class})
    public ActionResult publish(@PathVariable(value="id") String id) throws Exception {
        VisualdevEntity visualdevEntity = this.visualdevService.getInfo(id);
        if (GenerateConstant.containKeyword((String)visualdevEntity.getFullName())) {
            return ActionResult.fail((String)("\u8868\u5355\u540d\u79f0" + MsgCode.SYS128.get(new Object[]{visualdevEntity.getFullName()})));
        }
        List tableModels = JsonUtil.getJsonToList((String)visualdevEntity.getVisualTables(), TableModel.class);
        String s = VisualUtil.checkPublishVisualModel((VisualdevEntity)visualdevEntity, (String)MsgCode.VS004.get(new Object[0]));
        if (s != null) {
            return ActionResult.fail((String)s);
        }
        if (!VisualWebTypeEnum.DATA_VIEW.getType().equals(visualdevEntity.getWebType()) && !OnlineDevData.FORM_TYPE_SYS.equals(visualdevEntity.getType())) {
            if (ObjectUtil.isNotNull((Object)visualdevEntity.getFormData())) {
                FormDataModel formData = (FormDataModel)JsonUtil.getJsonToBean((String)visualdevEntity.getFormData(), FormDataModel.class);
                List list = JsonUtil.getJsonToList((String)formData.getFields(), FieLdsModel.class);
                ArrayList fields = new ArrayList();
                OnlinePublicUtils.getAllFields(fields, (List)list);
                StringJoiner sj = new StringJoiner(",");
                for (FieLdsModel item : fields) {
                    if (!StringUtil.isNotEmpty((String)item.getVModel()) || !GenerateConstant.containKeyword((String)item.getVModel())) continue;
                    sj.add(item.getConfig().getLabel() + "-" + item.getVModel());
                }
                if (StringUtil.isNotEmpty((String)sj.toString())) {
                    return ActionResult.fail((String)MsgCode.SYS128.get(new Object[]{sj}));
                }
            }
            if (tableModels.size() == 0) {
                try {
                    this.visualdevService.createTable(visualdevEntity);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                    throw new WorkFlowException(MsgCode.VS003.get(new Object[0]));
                }
            }
            Map tableMap = this.visualdevService.getTableMap(visualdevEntity.getFormData());
            this.filterService.updateRuleList(id, visualdevEntity, Integer.valueOf(1), Integer.valueOf(1), tableMap);
        }
        visualdevEntity.setState(Integer.valueOf(1));
        visualdevEntity.setEnabledMark(Integer.valueOf(1));
        this.visualdevService.updateById((Object)visualdevEntity);
        VisualdevReleaseEntity newRelease = new VisualdevReleaseEntity();
        newRelease.setVisualTables(visualdevEntity.getVisualTables());
        newRelease.setFormData(visualdevEntity.getFormData());
        newRelease.setColumnData(visualdevEntity.getColumnData());
        newRelease.setAppColumnData(visualdevEntity.getAppColumnData());
        newRelease.setWebType(visualdevEntity.getWebType());
        newRelease.setDbLinkId(visualdevEntity.getDbLinkId());
        String newContent = JsonUtil.getObjectToString((Object)newRelease);
        VisualdevReleaseEntity byId = (VisualdevReleaseEntity)this.visualdevReleaseService.getById((Serializable)visualdevEntity.getId());
        if (byId != null) {
            VisualdevReleaseEntity oldRelease = new VisualdevReleaseEntity();
            oldRelease.setVisualTables(byId.getVisualTables());
            oldRelease.setFormData(byId.getFormData());
            oldRelease.setColumnData(byId.getColumnData());
            oldRelease.setAppColumnData(byId.getAppColumnData());
            oldRelease.setWebType(byId.getWebType());
            oldRelease.setDbLinkId(byId.getDbLinkId());
            String oldContent = JsonUtil.getObjectToString((Object)oldRelease);
            newContent = oldContent.equals(newContent) ? byId.getOldContent() : oldContent;
        }
        VisualdevEntity clone = new VisualdevEntity();
        BeanUtil.copyProperties((Object)visualdevEntity, (Object)clone, (String[])new String[0]);
        VisualdevReleaseEntity releaseEntity = (VisualdevReleaseEntity)JsonUtil.getJsonToBean((Object)clone, VisualdevReleaseEntity.class);
        releaseEntity.setOldContent(newContent);
        this.visualdevReleaseService.setIgnoreLogicDelete().saveOrUpdate((Object)releaseEntity);
        this.visualdevReleaseService.clearIgnoreLogicDelete();
        return ActionResult.success((String)MsgCode.SU011.get(new Object[0]));
    }

    @Operation(summary="\u751f\u6210\u83dc\u5355")
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e")})
    @PostMapping(value={"/{id}/Actions/Module"})
    @SaCheckPermission(value={"onlineDev.webDesign", "generator.webForm", "generator.flowForm"}, mode=SaMode.OR)
    @Transactional(rollbackFor={Exception.class})
    public ActionResult createModule(@PathVariable(value="id") String id, @RequestBody VisualDevPubModel visualDevPubModel) throws Exception {
        VisualdevEntity visualdevEntity = this.visualdevService.getInfo(id);
        if (visualdevEntity == null) {
            ActionResult.fail((String)MsgCode.FA001.get(new Object[0]));
        }
        visualdevEntity.setPlatformRelease(visualDevPubModel.getPlatformRelease());
        this.visualdevService.updateById((Object)visualdevEntity);
        VisualdevEntity clone = (VisualdevEntity)BeanUtil.copyProperties((Object)visualdevEntity, VisualdevEntity.class, (String[])new String[0]);
        VisualMenuModel visual = VisualUtil.getVisual((VisualdevEntity)clone, (VisualDevPubModel)visualDevPubModel);
        visual.setApp(visualDevPubModel.getApp());
        visual.setPc(visualDevPubModel.getPc());
        visual.setPcModuleParentId(visualDevPubModel.getPcModuleParentId());
        visual.setAppModuleParentId(visualDevPubModel.getAppModuleParentId());
        visual.setType(Integer.valueOf(3));
        visual.setWebType(visualdevEntity.getWebType());
        this.pubulishUtil.publishMenu(visual);
        return ActionResult.success((String)MsgCode.VS007.get(new Object[0]));
    }

    @Operation(summary="\u56de\u6eda\u6a21\u677f")
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e")})
    @GetMapping(value={"/{id}/Actions/RollbackTemplate"})
    @SaCheckPermission(value={"onlineDev.webDesign", "generator.webForm", "generator.flowForm"}, mode=SaMode.OR)
    public ActionResult RollbackTemplate(@PathVariable(value="id") String id) {
        boolean b;
        VisualdevReleaseEntity releaseEntity = (VisualdevReleaseEntity)this.visualdevReleaseService.getById((Serializable)((Object)id));
        boolean bl = b = releaseEntity == null;
        if (b) {
            return ActionResult.fail((String)MsgCode.VS008.get(new Object[0]));
        }
        VisualdevEntity visualdevEntity = (VisualdevEntity)JsonUtil.getJsonToBean((Object)releaseEntity, VisualdevEntity.class);
        this.visualdevService.updateById((Object)visualdevEntity);
        return ActionResult.success((String)MsgCode.SU020.get(new Object[0]));
    }

    @Operation(summary="\u83b7\u53d6\u5df2\u53d1\u5e03\u83dc\u5355")
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e")})
    @GetMapping(value={"/{id}/getReleaseMenu"})
    @SaCheckPermission(value={"onlineDev.webDesign", "generator.webForm", "generator.flowForm"}, mode=SaMode.OR)
    public ActionResult<VisualFunctionModel> getReleaseMenu(@PathVariable(value="id") String id) {
        VisualdevEntity entity = (VisualdevEntity)this.visualdevService.getById((Serializable)((Object)id));
        if (entity != null) {
            VisualFunctionModel model = (VisualFunctionModel)JsonUtil.getJsonToBean((Object)entity, VisualFunctionModel.class);
            model.setAppIsRelease(Integer.valueOf(0));
            model.setPcIsRelease(Integer.valueOf(0));
            ModuleNameVO moduleNameVO = this.moduleService.getModuleNameList((String)entity.getId());
            if (moduleNameVO != null) {
                if (StringUtil.isNotEmpty((String)moduleNameVO.getPcNames())) {
                    model.setPcIsRelease(Integer.valueOf(1));
                    model.setPcReleaseName(moduleNameVO.getPcNames());
                }
                if (StringUtil.isNotEmpty((String)moduleNameVO.getAppNames())) {
                    model.setAppIsRelease(Integer.valueOf(1));
                    model.setAppReleaseName(moduleNameVO.getAppNames());
                }
            }
            return ActionResult.success((Object)model);
        }
        return ActionResult.fail((String)MsgCode.FA012.get(new Object[0]));
    }
}

