/*
 * Decompiled with CFR 0.152.
 */
package jnpf.util;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import jnpf.base.ActionResult;
import jnpf.base.UserInfo;
import jnpf.exception.LoginException;
import jnpf.model.LoginVO;
import jnpf.service.AuthService;
import jnpf.util.Constants;
import jnpf.util.TenantHolder;
import jnpf.util.UserProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuthUtil {
    private static final Logger log = LoggerFactory.getLogger(AuthUtil.class);
    public static AuthService authApi;

    @Autowired
    public void setAuthApi(AuthService authApi) {
        AuthUtil.authApi = authApi;
    }

    public static String loginTempUser(String userId, String tenantId) {
        return AuthUtil.loginTempUser(userId, tenantId, false);
    }

    public static String loginTempUser(String userId, String tenantId, boolean limited) {
        ImmutableMap loginInfo = ImmutableMap.of((Object)"grant_type", (Object)"tempuser", (Object)"token", (Object)UserProvider.getInnerAuthToken(), (Object)"userId", (Object)userId, (Object)"tenantId", (Object)Optional.ofNullable(tenantId).orElse(""), (Object)"limited", (Object)String.valueOf(limited));
        ActionResult<LoginVO> result = authApi.login((Map<String, String>)loginInfo);
        if (Constants.SUCCESS.equals(result.getCode())) {
            return ((LoginVO)result.getData()).getToken();
        }
        log.error("\u767b\u5f55\u4e34\u65f6\u7528\u6237\u5931\u8d25: {}", (Object)result.getMsg());
        throw new LoginException(result.getMsg());
    }

    public static void kickoutByToken(String ... tokens) {
        authApi.kickoutByToken(tokens);
    }

    public static void kickoutByUserId(String userId) {
        String tenantId = TenantHolder.getDatasourceId();
        if (tenantId == null) {
            UserInfo userInfo = UserProvider.getUser();
            if (userInfo.getUserId() == null) {
                throw new RuntimeException("\u8bf7\u8bbe\u7f6eUserInfo");
            }
            tenantId = userInfo.getTenantId();
        }
        authApi.kickoutByUserId(userId, tenantId);
    }
}

