/*
 * Decompiled with CFR 0.152.
 */
package jnpf.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import jnpf.base.ActionResult;
import jnpf.base.Pagination;
import jnpf.base.controller.SuperController;
import jnpf.base.vo.PageListVO;
import jnpf.base.vo.PaginationVO;
import jnpf.constant.MsgCode;
import jnpf.entity.ContractEntity;
import jnpf.model.ContractForm;
import jnpf.model.ContractInfoVO;
import jnpf.model.ContractListVO;
import jnpf.service.ContractService;
import jnpf.util.JsonUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="\u793a\u4f8b\u63a5\u53e3", description="Contract")
@RequestMapping(value={"/Contract"})
public class ContractController
extends SuperController<ContractService, ContractEntity> {
    @Autowired
    private ContractService contractService;

    @Operation(summary="\u83b7\u53d6\u5217\u8868")
    @GetMapping(value={"/List"})
    public ActionResult<PageListVO<ContractListVO>> list(Pagination pagination) {
        List entity = this.contractService.getlist(pagination);
        List listVo = JsonUtil.getJsonToList((String)JsonUtil.getObjectToStringDateFormat((Object)entity, (String)"yyyy-MM-dd HH:mm:ss"), ContractListVO.class);
        PaginationVO vo = (PaginationVO)JsonUtil.getJsonToBean((Object)pagination, PaginationVO.class);
        return ActionResult.page((List)listVo, (PaginationVO)vo);
    }

    @Operation(summary="\u83b7\u53d6\u8be6\u60c5")
    @GetMapping(value={"/{id}"})
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e", required=true)})
    public ActionResult<ContractInfoVO> info(@PathVariable(value="id") String id) {
        ContractEntity entity = this.contractService.getInfo(id);
        ContractInfoVO vo = (ContractInfoVO)JsonUtil.getJsonToBean((Object)entity, ContractInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u65b0\u5efa")
    @PostMapping
    @Parameters(value={@Parameter(name="contractForm", description="\u793a\u4f8b\u6a21\u578b", required=true)})
    public ActionResult create(@RequestBody @Valid ContractForm contractForm) {
        ContractEntity entity = (ContractEntity)JsonUtil.getJsonToBean((Object)contractForm, ContractEntity.class);
        this.contractService.create(entity);
        return ActionResult.success((String)MsgCode.SU002.get(new Object[0]));
    }

    @Operation(summary="\u4fee\u6539")
    @PutMapping(value={"/{id}"})
    @Parameters(value={@Parameter(name="contractForm", description="\u793a\u4f8b\u6a21\u578b", required=true), @Parameter(name="id", description="\u4e3b\u952e", required=true)})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid ContractForm contractForm) {
        ContractEntity entity = (ContractEntity)JsonUtil.getJsonToBean((Object)contractForm, ContractEntity.class);
        this.contractService.update(id, entity);
        return ActionResult.success((String)MsgCode.SU004.get(new Object[0]));
    }

    @Operation(summary="\u5220\u9664")
    @DeleteMapping(value={"/{id}"})
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e", required=true)})
    public ActionResult delete(@PathVariable(value="id") String id) {
        ContractEntity entity = this.contractService.getInfo(id);
        this.contractService.delete(entity);
        return ActionResult.success((String)MsgCode.SU003.get(new Object[0]));
    }
}

