package jnpf;

import com.fasterxml.jackson.core.StreamReadConstraints;
import org.dromara.x.file.storage.spring.EnableFileStorage;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;


@SpringBootApplication
@EnableFileStorage
public class ReportUniverApplication {

    public static void main(String[] args) {
        StreamReadConstraints.overrideDefaultStreamReadConstraints(
                StreamReadConstraints.builder().maxStringLength(100000000).build()
        );
        SpringApplication springApplication = new SpringApplication(ReportUniverApplication.class);
        springApplication.run(args);
        System.out.println("报表启动完成");
    }

}
