/*
 * Decompiled with CFR 0.152.
 */
package winter.com.ideaaedi.classwinter.util;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.Bytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ExceptionTable;
import javassist.bytecode.annotation.Annotation;
import javassist.compiler.CompileError;
import javassist.compiler.Javac;
import winter.com.ideaaedi.classwinter.exception.ClassWinterException;
import winter.com.ideaaedi.classwinter.util.Constant;
import winter.com.ideaaedi.classwinter.util.EncryptClassArgs;
import winter.com.ideaaedi.classwinter.util.IOUtil;
import winter.com.ideaaedi.classwinter.util.Logger;
import winter.com.ideaaedi.classwinter.util.StrUtil;

public final class JavassistUtil {
    public static byte[] clearMethodBody(ClassPool classPool, String className, EncryptClassArgs encryptClassArgs) throws CannotCompileException, NotFoundException {
        try {
            CtMethod[] methods;
            CtClass ctClass = classPool.getCtClass(className);
            if (ctClass.isFrozen()) {
                Logger.debug(JavassistUtil.class, "defrost class " + className);
                ctClass.defrost();
            }
            boolean cleanOverCLass = encryptClassArgs.isCleanAnnotationOverClazz();
            boolean cleanOverMethod = encryptClassArgs.isCleanAnnotationOverMethod();
            boolean cleanOverField = encryptClassArgs.isCleanAnnotationOverField();
            String toCleanAnnotationPrefix = encryptClassArgs.getToCleanAnnotationPrefix();
            if (cleanOverCLass || cleanOverMethod || cleanOverField) {
                try {
                    JavassistUtil.clearAnnotation(ctClass, cleanOverCLass, cleanOverMethod, cleanOverField, toCleanAnnotationPrefix);
                }
                catch (Exception ignore) {
                    Logger.warn(JavassistUtil.class, "clean className [" + className + "] annotation fail. ignore.");
                }
            }
            boolean keepOriginArgsName = encryptClassArgs.isKeepOriginArgsName();
            for (CtMethod ctMethod : methods = ctClass.getDeclaredMethods()) {
                if (!ctMethod.getLongName().startsWith(className) || ctMethod.getName().contains("<")) continue;
                if (keepOriginArgsName) {
                    CodeAttribute codeAttribute = ctMethod.getMethodInfo().getCodeAttribute();
                    if (codeAttribute != null && codeAttribute.getCodeLength() != 1 && codeAttribute.getCode()[0] != 79) {
                        JavassistUtil.clearMethodBodyKeepOriginArgName(ctMethod);
                    }
                } else {
                    ctMethod.setBody(null);
                }
                try {
                    ctMethod.insertBefore("System.out.println(\"\\n " + Constant.TIPS + " \\n\");\nSystem.out.println(\" Located in " + className + " \");\nSystem.out.println(\" " + Constant.SEAL + " \");\nSystem.exit(-1);");
                }
                catch (CannotCompileException e) {
                    if ("no method body".equals(e.getMessage())) {
                        Logger.debug(JavassistUtil.class, "[" + ctMethod.getLongName() + "] no method body. ignore to add tips info.");
                        continue;
                    }
                    throw e;
                }
            }
            return ctClass.toBytecode();
        }
        catch (IOException e) {
            throw new ClassWinterException(e);
        }
    }

    private static void clearAnnotation(CtClass ctClass, boolean cleanOverCLass, boolean cleanOverMethod, boolean cleanOverField, String toCleanAnnotationPrefix) {
        if (cleanOverCLass) {
            JavassistUtil.removeAnnotationsAttribute(ctClass.getClassFile().getAttributes(), toCleanAnnotationPrefix);
        }
        if (cleanOverMethod) {
            CtMethod[] methods = ctClass.getDeclaredMethods();
            for (CtMember ctMember : methods) {
                JavassistUtil.removeAnnotationsAttribute(((CtBehavior)ctMember).getMethodInfo().getAttributes(), toCleanAnnotationPrefix);
            }
        }
        if (cleanOverField) {
            CtField[] fields = ctClass.getDeclaredFields();
            for (CtMember ctMember : fields) {
                JavassistUtil.removeAnnotationsAttribute(((CtField)ctMember).getFieldInfo().getAttributes(), toCleanAnnotationPrefix);
            }
        }
    }

    private static boolean removeAnnotationsAttribute(List<AttributeInfo> attributeInfoList, String toCleanAnnotationPrefix) {
        if (attributeInfoList == null || attributeInfoList.size() == 0) {
            return true;
        }
        if (StrUtil.isBlank(toCleanAnnotationPrefix)) {
            return attributeInfoList.removeIf(x -> {
                try {
                    return x instanceof AnnotationsAttribute;
                }
                catch (Exception e) {
                    return false;
                }
            });
        }
        StrUtil.strToSet(toCleanAnnotationPrefix, "\\|").forEach(x -> attributeInfoList.forEach(y -> {
            if (y instanceof AnnotationsAttribute) {
                AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)y;
                Annotation[] annotations = annotationsAttribute.getAnnotations();
                Annotation[] newAnnotations = (Annotation[])Arrays.stream(annotations).filter(annotation -> !annotation.getTypeName().startsWith((String)x)).toArray(Annotation[]::new);
                annotationsAttribute.setAnnotations(newAnnotations);
            }
        }));
        return true;
    }

    public static void loadJar(ClassPool classPool, String ... paths) throws NotFoundException {
        if (paths == null) {
            return;
        }
        for (String path : paths) {
            JavassistUtil.loadJar(classPool, new File(path));
        }
    }

    public static void loadClass(ClassPool classPool, String ... paths) throws NotFoundException {
        if (paths == null) {
            return;
        }
        for (String path : paths) {
            JavassistUtil.loadClasses(classPool, new File(path));
        }
    }

    private static boolean isMain(CtMethod ctMethod) throws NotFoundException {
        boolean returnValueValid = "void".equalsIgnoreCase(ctMethod.getReturnType().getName());
        boolean nameArgTypeValid = ctMethod.getLongName().endsWith(".main(java.lang.String[])");
        boolean accessFlag = ctMethod.getMethodInfo().getAccessFlags() == 9;
        return returnValueValid && nameArgTypeValid && accessFlag;
    }

    private static void clearMethodBodyKeepOriginArgName(CtMethod ctMethod) throws CannotCompileException, NotFoundException {
        CtClass ctClass = ctMethod.getDeclaringClass();
        if (ctClass.isFrozen()) {
            throw new ClassWinterException(ctClass.getName() + " class is frozen.");
        }
        CodeAttribute codeAttribute = ctMethod.getMethodInfo().getCodeAttribute();
        if (codeAttribute == null) {
            throw new ClassWinterException("no method body.");
        }
        CodeIterator iterator = codeAttribute.iterator();
        Javac jv = new Javac(ctClass);
        try {
            int maxLocals;
            Bytecode bytecode = jv.compileBody(ctMethod, null);
            int maxStack = bytecode.getMaxStack();
            if (maxStack > codeAttribute.getMaxStack()) {
                codeAttribute.setMaxStack(maxStack);
            }
            if ((maxLocals = bytecode.getMaxLocals()) > codeAttribute.getMaxLocals()) {
                codeAttribute.setMaxLocals(maxLocals);
            }
            iterator.insertEx(bytecode.get());
            ExceptionTable exceptionTable = codeAttribute.getExceptionTable();
            if (exceptionTable != null) {
                int size = exceptionTable.size();
                for (int i = size - 1; i >= 0; --i) {
                    exceptionTable.remove(i);
                }
            }
            ctMethod.getMethodInfo().rebuildStackMapIf6(ctClass.getClassPool(), ctClass.getClassFile2());
        }
        catch (CompileError compileError) {
            throw new CannotCompileException(compileError);
        }
        catch (BadBytecode badBytecode) {
            throw new CannotCompileException(badBytecode);
        }
    }

    private static void loadJar(ClassPool pool, File dirOrFile) throws NotFoundException {
        if (dirOrFile == null || !dirOrFile.exists()) {
            return;
        }
        List jars = IOUtil.listFileOnly(dirOrFile, ".jar");
        for (File jar : jars) {
            pool.insertClassPath(jar.getAbsolutePath());
        }
    }

    private static void loadClasses(ClassPool pool, File dirOrFile) throws NotFoundException {
        if (dirOrFile == null || !dirOrFile.exists()) {
            return;
        }
        Set classesRootDirSet = IOUtil.listFileOnly(dirOrFile, ".class").stream().map(x -> JavassistUtil.resolveClassName(x.getAbsolutePath(), false)).collect(Collectors.toSet());
        for (String rootDir : classesRootDirSet) {
            pool.insertClassPath(rootDir);
        }
    }

    public static String resolveClassName(String fileName, boolean classOrPath) {
        String nonSuffixFileName = fileName.substring(0, fileName.length() - ".class".length());
        String classesFlag = File.separator + "classes" + File.separator;
        String libFlag = File.separator + "lib" + File.separator;
        int libFlagIndex = nonSuffixFileName.indexOf(libFlag, nonSuffixFileName.indexOf("__temp__"));
        int classesFlagIndex = nonSuffixFileName.indexOf(classesFlag, nonSuffixFileName.indexOf("__temp__"));
        String className = libFlagIndex >= 0 ? nonSuffixFileName.substring(nonSuffixFileName.indexOf("__temp__", libFlagIndex) + "__temp__".length() + 1) : (classesFlagIndex >= 0 ? nonSuffixFileName.substring(classesFlagIndex + classesFlag.length()) : nonSuffixFileName.substring(nonSuffixFileName.indexOf("__temp__") + "__temp__".length() + 1));
        String classPath = nonSuffixFileName.substring(0, nonSuffixFileName.length() - className.length() - 1);
        return classOrPath ? className.replace(File.separator, ".") : classPath;
    }
}

