package jnpf.config;

import jnpf.consts.ApiConst;
import jnpf.properties.GatewayWhite;
import jnpf.properties.GatewayWhiteProperties;
import jnpf.properties.ReportProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods = false)
public class ReportAutoConfiguration {


    @Bean
    @ConfigurationProperties(prefix = GatewayWhite.PREFIX)
    public GatewayWhite getGateWhite(){
        return new GatewayWhiteProperties();
    }


    @Bean
    @ConfigurationProperties(prefix = ReportProperties.PREFIX)
    public ReportProperties getReportProperties(){
        return new ReportProperties();
    }


    @Bean
    public ApiConst initReportApiConst(JnpfOauthConfig jnpfOauthConfig){
        ApiConst.ME = jnpfOauthConfig.getJnpfDomain() + "/api/oauth/me";
        ApiConst.DATASET_LIST = jnpfOauthConfig.getJnpfDomain() + "/api/system/DataSet/getList";
        ApiConst.DATASET_SAVE = jnpfOauthConfig.getJnpfDomain() + "/api/system/DataSet/save";
        ApiConst.DATASET_DATA = jnpfOauthConfig.getJnpfDomain() + "/api/system/DataSet/Data";
        ApiConst.SAVE_MENU = jnpfOauthConfig.getJnpfDomain() + "/api/system/Menu/saveReportMenu";
        ApiConst.GET_MENU = jnpfOauthConfig.getJnpfDomain() + "/api/system/Menu/getReportMenu";
        ApiConst.PARAMETER_DATA = jnpfOauthConfig.getJnpfDomain() + "/api/system/DataSet/parameterData";
        return new ApiConst();
    }

}
