/*
 * Decompiled with CFR 0.152.
 */
package winter.com.ideaaedi.classwinter.plugin;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import winter.com.ideaaedi.classwinter.executor.EncryptExecutor;
import winter.com.ideaaedi.classwinter.util.ExceptionUtil;
import winter.com.ideaaedi.classwinter.util.Logger;

@Mojo(name="class-winter", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class ClassWinterPlugin
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter
    private String originJarOrWar;
    @Parameter(required=true)
    private String includePrefix;
    @Parameter
    private String finalName;
    @Parameter
    private String password;
    @Parameter
    private String excludePrefix;
    @Parameter
    private String includeXmlPrefix;
    @Parameter
    private String excludeXmlPrefix;
    @Parameter
    private String toCleanXmlChildElementName;
    @Parameter
    private String includeLibs;
    @Parameter
    private String alreadyProtectedRootDir;
    @Parameter
    private String alreadyProtectedLibs;
    @Parameter
    private String supportFile;
    @Parameter
    private String jvmArgCheck;
    @Parameter
    private String tips;
    @Parameter(defaultValue="false")
    private Boolean debug;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Logger.simpleInfo((String)"-----------------< class-winter-plugin start >-----------------");
        Logger.ENABLE_DEBUG.set(this.debug != null && this.debug != false);
        Logger.debug((String)("You config arg originJarOrWar -> " + this.originJarOrWar));
        Logger.debug((String)("You config arg includePrefix -> " + this.includePrefix));
        Logger.debug((String)("You config arg excludePrefix -> " + this.excludePrefix));
        Logger.debug((String)("You config arg includeXmlPrefix -> " + this.includeXmlPrefix));
        Logger.debug((String)("You config arg excludeXmlPrefix -> " + this.excludeXmlPrefix));
        Logger.debug((String)("You config arg toCleanXmlChildElementName -> " + this.toCleanXmlChildElementName));
        Logger.debug((String)("You config arg finalName -> " + this.finalName));
        Logger.debug((String)("You config arg password -> " + this.password));
        Logger.debug((String)("You config arg includeLibs -> " + this.includeLibs));
        Logger.debug((String)("You config arg alreadyProtectedRootDir -> " + this.alreadyProtectedRootDir));
        Logger.debug((String)("You config arg alreadyProtectedLibs -> " + this.alreadyProtectedLibs));
        Logger.debug((String)("You config arg supportFile -> " + this.supportFile));
        Logger.debug((String)("You config arg jvmArgCheck -> " + this.jvmArgCheck));
        Logger.debug((String)("You config arg tips -> " + this.tips));
        Logger.debug((String)("You config arg debug -> " + this.debug));
        Build build = this.project.getBuild();
        if (StringUtils.isBlank((CharSequence)this.originJarOrWar)) {
            this.originJarOrWar = build.getDirectory() + File.separator + build.getFinalName() + "." + this.project.getPackaging();
            Logger.debug((String)("Determine originJarOrWar -> " + this.originJarOrWar));
        }
        EncryptExecutor encryptExecutor = EncryptExecutor.builder().originJarOrWar(this.originJarOrWar).finalName(this.finalName).password(this.password).includePrefix(this.includePrefix).excludePrefix(this.excludePrefix).includeXmlPrefix(this.includeXmlPrefix).excludeXmlPrefix(this.excludeXmlPrefix).toCleanXmlChildElementName(this.toCleanXmlChildElementName).includeLibs(this.includeLibs).alreadyProtectedRootDir(this.alreadyProtectedRootDir).alreadyProtectedLibs(this.alreadyProtectedLibs).supportFile(this.supportFile).jvmArgCheck(this.jvmArgCheck).debug(this.debug).tips(this.tips).build();
        Logger.debug((String)("The encrypted executor generated based on your configuration is -> " + encryptExecutor));
        try {
            encryptExecutor.invokerIsPlugin = true;
            String encryptedJarOrWar = encryptExecutor.process();
            Logger.simpleInfo((String)("The absolute path of the obfuscated jar is [" + encryptedJarOrWar + "]"));
        }
        catch (Exception e) {
            Logger.error(ClassWinterPlugin.class, (String)ExceptionUtil.getStackTraceMessage((Throwable)e));
            throw e;
        }
        Logger.simpleInfo((String)"-----------------< class-winter-plugin  end  >-----------------");
    }
}

