package jnpf.onlinedev.model.log;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

/**
 * 数据日志查询参数
 *
 * @author JNPF开发平台组
 * @version v5.1.0
 * @copyright 引迈信息技术有限公司
 * @date 2024/8/29 14:51:39
 */
@Data
@Schema(description = "数据日志查询参数")
public class VisualLogVo {

    @Schema(description = "模板id")
    private String modelId;

    @Schema(description = "数据id")
    private String dataId;

    @Schema(description = "日志类型：0-新建，1-编辑")
    private Integer type;

    @Schema(description = "日志内容")
    private String dataLog;

    @Schema(description = "创建时间")
    private String creatorTime;
    @Schema(description = "创建人名称")
    private String creatorUserName;
    @Schema(description = "创建人id")
    private String creatorUserId;
    @Schema(description = "创建人头像")
    private String headIcon;
}
