package jnpf.onlinedev.model.log;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jnpf.base.Pagination;
import lombok.Data;

/**
 * 数据日志查询参数
 *
 * @author JNPF开发平台组
 * @version v5.1.0
 * @copyright 引迈信息技术有限公司
 * @date 2024/8/29 14:51:39
 */
@Data
@Schema(description = "数据日志查询参数")
public class VisualLogPage extends Pagination {
    @NotBlank
    @Schema(description = "功能Id")
    private String modelId;

    @NotBlank
    @Schema(description = "数据id")
    private String dataId;
}
