package jnpf.onlinedev.model.log;

import io.swagger.v3.oas.annotations.media.Schema;
import jnpf.base.model.VisualLogModel;
import lombok.Builder;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * 日志存储模型
 *
 * @author JNPF开发平台组
 * @version v5.1.0
 * @copyright 引迈信息技术有限公司
 * @date 2024/8/27 16:05:28
 */
@Data
@Schema(description = "控件类型")
@Builder
public class VisualLogForm {
    @Schema(description = "功能id")
    private String modelId;
    @Schema(description = "数据id")
    private String dataId;
    @Schema(description = "旧数据")
    private Map<String, Object> oldData;
    @Schema(description = "新数据")
    private Map<String, Object> newData;
    @Schema(description = "动作类型：0-新增，1-修改")
    private Integer type;
    @Schema(description = "修改内容")
    List<VisualLogModel> listLog;
}
