package jnpf.onlinedev.controller;

import jnpf.base.ActionResult;
import jnpf.base.UserInfo;
import jnpf.base.entity.VisualdevEntity;
import jnpf.base.entity.VisualdevReleaseEntity;
import jnpf.base.model.OnlineImport.VisualdevModelDataInfoVO;
import jnpf.base.model.VisualDevJsonModel;
import jnpf.base.model.flow.DataModel;
import jnpf.base.model.flow.FlowFormDataModel;
import jnpf.base.model.flow.FlowStateModel;
import jnpf.base.service.DbLinkService;
import jnpf.base.service.FlowFormRelationService;
import jnpf.base.service.VisualdevReleaseService;
import jnpf.base.service.VisualdevService;
import jnpf.base.util.FlowFormDataUtil;
import jnpf.base.util.FlowFormHttpReqUtils;
import jnpf.database.model.entity.DbLinkEntity;
import jnpf.exception.DataException;
import jnpf.onlinedev.model.OnlineInfoModel;
import jnpf.onlinedev.model.PaginationModel;
import jnpf.onlinedev.model.VisualParamModel;
import jnpf.onlinedev.service.VisualDevInfoService;
import jnpf.onlinedev.service.VisualDevListService;
import jnpf.onlinedev.service.VisualdevModelDataService;
import jnpf.onlinedev.util.onlineDevUtil.FlowFormCustomUtils;
import jnpf.onlinedev.util.onlineDevUtil.OnlinePublicUtils;
import jnpf.util.*;
import jnpf.visual.service.VisualdevApi;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class VisualdevForFlowController implements VisualdevApi {

    @Autowired
    private VisualdevReleaseService visualdevReleaseService;
    @Autowired
    private VisualdevService visualdevService;
    @Autowired
    private VisualDevListService visualDevListService;
    @Autowired
    private VisualDevInfoService visualDevInfoService;
    @Autowired
    private FlowFormHttpReqUtils flowFormHttpReqUtils;
    @Autowired
    private FlowFormCustomUtils flowFormCustomUtils;
    @Autowired
    private FlowFormDataUtil flowDataUtil;
    @Autowired
    private DbLinkService dblinkService;
    @Autowired
    private FlowFormRelationService flowFormRelationService;
    @Autowired
    private VisualdevModelDataService visualdevModelDataService;

    @Override
    public ActionResult saveOrUpdate(FlowFormDataModel flowFormDataModel) {
        DataModel dataModel = null;
        try {
            String id = flowFormDataModel.getId();
            String formId = flowFormDataModel.getFormId();
            String flowId = flowFormDataModel.getFlowId();
            Map<String, Object> map = flowFormDataModel.getMap();
            List<Map<String, Object>> formOperates = flowFormDataModel.getFormOperates();
            VisualdevReleaseEntity entity = visualdevReleaseService.getById(formId);
            VisualdevEntity visualdevEntity = JsonUtil.getJsonToBean(entity, VisualdevEntity.class);

            map.put(FlowFormConstant.FLOWID, flowId);
            if (map.get(TableFeildsEnum.VERSION.getField().toUpperCase()) != null) {//针对Oracle数据库大小写敏感，出现大写字段补充修复
                map.put(TableFeildsEnum.VERSION.getField(), map.get(TableFeildsEnum.VERSION.getField().toUpperCase()));
            }

            //系统表单
            if (entity.getType() == 2) {
                map.put("formOperates", formOperates);
                flowFormHttpReqUtils.saveOrUpdate(visualdevEntity, id, UserProvider.getToken(), map);
            } else {
                try {
                    dataModel = flowFormCustomUtils.saveOrUpdate(visualdevEntity, flowFormDataModel);
                } catch (SQLException sqlException) {
                    sqlException.printStackTrace();
                } catch (DataException e) {
                    e.printStackTrace();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            return ActionResult.fail(e.getMessage());
        }
        return ActionResult.success(dataModel);
    }

    @Override
    public boolean delete(String formId, String id) {
        try {
            VisualdevReleaseEntity entity = visualdevReleaseService.getById(formId);
            VisualdevEntity visualdevEntity = JsonUtil.getJsonToBean(entity, VisualdevEntity.class);
            //系统表单
            if (entity.getType() == 2) {
                flowFormHttpReqUtils.delete(visualdevEntity, id, UserProvider.getToken());
            } else {
                VisualDevJsonModel visualJsonModel = OnlinePublicUtils.getVisualJsonModel(visualdevEntity);
                DbLinkEntity linkEntity = StringUtil.isNotEmpty(visualdevEntity.getDbLinkId()) ? dblinkService.getInfo(visualdevEntity.getDbLinkId()) : null;
                flowDataUtil.deleteTable(id, visualJsonModel, linkEntity);
            }
        } catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public ActionResult info(String formId, String id) {
        ActionResult result = new ActionResult();
        Map<String, Object> allDataMap = new HashMap();
        VisualdevReleaseEntity entity = visualdevReleaseService.getById(formId);
        VisualdevEntity visualdevEntity = JsonUtil.getJsonToBean(entity, VisualdevEntity.class);
        result.setCode(visualdevEntity == null ? 400 : 200);
        result.setMsg(visualdevEntity == null ? "表单信息不存在" : "");
        if (visualdevEntity != null) {
            //判断是否为系统表单
            boolean b = visualdevEntity.getType() == 2;
            if (b) {
                allDataMap.putAll(flowFormHttpReqUtils.info(visualdevEntity, id, UserProvider.getToken()));
            } else {
                allDataMap.putAll(flowFormCustomUtils.info(visualdevEntity, id));
            }
        }
        result.setData(allDataMap);
        return result;
    }

    @Override
    public VisualdevEntity getFormConfig(String formId) {
        VisualdevReleaseEntity entity = visualdevReleaseService.getById(formId);
        VisualdevEntity visualdevEntity = JsonUtil.getJsonToBean(entity, VisualdevEntity.class);
        return visualdevEntity;
    }

    @Override
    public List<VisualdevEntity> getFormConfigList(List<String> formIds) {
        List<VisualdevReleaseEntity> list = visualdevReleaseService.selectByIds(formIds,
                VisualdevReleaseEntity::getId,
                VisualdevReleaseEntity::getEnCode,
                VisualdevReleaseEntity::getFullName,
                VisualdevReleaseEntity::getWebType,
                VisualdevReleaseEntity::getType);
        return CollectionUtils.isNotEmpty(list) ? JsonUtil.getJsonToList(list, VisualdevEntity.class) : new ArrayList<>();
    }

    @Override
    public void saveFlowIdByFormIds(String flowId, List<String> formIds) {
        flowFormRelationService.saveFlowIdByFormIds(flowId, formIds);
    }

    @Override
    public VisualdevEntity getReleaseInfo(String formId) {
        return visualdevService.getReleaseInfo(formId);
    }

    @Override
    public List<Map<String, Object>> getListWithTableList(VisualDevJsonModel visualDevJsonModel, PaginationModel pagination, UserInfo userInfo) {
        return visualDevListService.getListWithTableList(visualDevJsonModel, pagination, userInfo);
    }

    @Override
    public VisualdevModelDataInfoVO getEditDataInfo(String id, VisualdevEntity visualdevEntity) {
        return visualDevInfoService.getEditDataInfo(id, visualdevEntity, OnlineInfoModel.builder().build());
    }

    @Override
    public DataModel visualCreate(VisualParamModel model) throws Exception {
        return visualdevModelDataService.visualCreate(VisualParamModel.builder().visualdevEntity(model.getVisualdevEntity()).data(model.getData()).build());
    }

    @Override
    public DataModel visualUpdate(VisualParamModel model) throws Exception {
        return visualdevModelDataService.visualUpdate(model);
    }

    @Override
    public void visualDelete(VisualParamModel model) throws Exception {
        visualdevModelDataService.visualDelete(model.getVisualdevEntity(), model.getDataList());
    }

    @Override
    public void deleteByTableName(FlowFormDataModel model) throws Exception {
        visualdevModelDataService.deleteByTableName(model);
    }

    @Override
    public void saveState(FlowStateModel model) {
        List<String> formIds = model.getFormIds();
        String flowTaskId = model.getFlowTaskId();
        Integer flowState = model.getFlowState();
        for (String formId : formIds) {
            VisualdevReleaseEntity entity = visualdevReleaseService.getById(formId);
            if (entity == null) continue;
            VisualdevEntity visualdevEntity = JsonUtil.getJsonToBean(entity, VisualdevEntity.class);
            //系统表单
            if (entity.getType() == 2) {
                flowFormHttpReqUtils.saveState(visualdevEntity, flowTaskId, flowState);
            } else {
                flowDataUtil.saveState(visualdevEntity, flowTaskId, flowState);
            }
        }
    }
}
