package jnpf.base.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import cn.dev33.satoken.annotation.SaMode;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import jnpf.base.ActionResult;
import jnpf.base.Pagination;
import jnpf.base.model.ai.VisualAiModel;
import jnpf.base.service.impl.VisualAiServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 在线开发ai模块
 *
 * @author JNPF开发平台组
 * @version v5.2.0
 * @copyright 引迈信息技术有限公司
 * @date 2024/12/2 9:57:13
 */
@Tag(name = "在线开发ai模块", description = "ai")
@RestController
@RequestMapping("/api/visualdev/ai")
public class VisualAiController {

    @Autowired
    private VisualAiServiceImpl visualAiService;

    @Operation(summary = "ai生成表单")
    @Parameters({
            @Parameter(name = "keyword", description = "需求描述"),
    })
    @PostMapping("/form")
    @SaCheckPermission(value = {"onlineDev.formDesign", "generator.webForm", "generator.flowForm"}, mode = SaMode.OR)
    public ActionResult form(@RequestBody Pagination pagination) {
        VisualAiModel visualAiModel = visualAiService.form(pagination.getKeyword());
        return ActionResult.success(visualAiModel);
    }
}
