package jnpf.flowable.model.util;

import jnpf.util.JsonUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FlowOperatorHolder {

    // 审批人
    private static final ThreadLocal<List<FlowOperatorModel>> LIST = new ThreadLocal<>();


    /**
     * 获取审批人
     */
    public static List<FlowOperatorModel> getOperatorList() {
        List<FlowOperatorModel> list = LIST.get() != null ? LIST.get() : new ArrayList<>();
        return list;
    }

    /**
     * 添加审批人
     */
    public static void addOperator(FlowOperatorModel model, Map<String, Map<String, Object>> allData) {
        Map<String, Map<String, Object>> data = new HashMap<>();
        for (String key : allData.keySet()) {
            Map<String, Object> dataValue = JsonUtil.entityToMap(allData.get(key));
            data.put(key, dataValue);
        }
        model.setAllData(data);
        List<FlowOperatorModel> list = LIST.get() != null ? LIST.get() : new ArrayList<>();
        list.add(model);
        LIST.set(list);
    }


    /**
     * 清除数据
     */
    public static void clear() {
        LIST.remove();
    }


}
