package jnpf.flowable.model.util;

import lombok.Data;

/**
 * 在线工作流开发
 *
 * @author JNPF开发平台组
 * @version V3.1.0
 * @copyright 引迈信息技术有限公司
 * @date 2019年9月27日 上午9:18
 */
@Data
public class FlowNature {

    /**
     * 子表数据标识
     */
    public static String SUB_TABLE = "@subTable";
    /**
     * 数据传递 全局参数
     */
    public static String GLOBAL_PARAMETER = "globalParameter";
    /**
     * 撤销流水号编码
     */
    public static String REVOKE_BILL_CODE = "workflow_revoke";
    /**
     * 撤销表单编码
     */
    public static String REVOKE_FORM_CODE = "revoke";

    /**
     * 结束编码、名称
     */
    public static String END_CODE = "end";
    public static String END_NAME = "结束";
    /**
     * 开始编码、名称
     */
    public static String START_CODE = "start";
    public static String START_NAME = "开始";

    /**
     * 表单字段后缀
     */
    public static String FORM_FIELD_SUFFIX = "_jnpfId";

    /**
     * 系统编码
     */
    public static String SYSTEM_CODE = "jnpf";
    /**
     * 系统名称
     */
    public static String SYSTEM_NAME = "系统";
    /**
     * 系统头像
     */
    public static String SYSTEM_HEAD_ICON = "001.png";

    /**
     * 流程标题
     */
    public static Integer TitleType = 0;

    /**
     * 发起权限
     **/
    public static Integer LaunchPermission = 1;

    /**
     * 流程父节点
     **/
    public static String ParentId = "0";

    //----------------------记录、审批状态--------------------
    /**
     * 正常状态
     */
    public static Integer Normal = 0;
    /**
     * 作废状态（记录）
     */
    public static Integer Invalid = -1;
    /**
     * 有操作（如加签、同意等）变1 (审批)
     */
    public static Integer Action = 1;

    //----------------------驳回类型--------------------
    /**
     * 驳回开始
     **/
    public static String Start = "0";

    /**
     * 驳回上一节点
     **/
    public static String Up = "1";

    /**
     * 自选节点
     **/
    public static String Reject = "2";

    //----------------------办理类型--------------------

    /**
     * 不是办理节点
     **/
    public static Integer NotProcessing = 0;

    /**
     * 办理节点
     **/
    public static Integer Processing = 1;

    //----------------------发起类型--------------------

    /**
     * 任务发起
     **/
    public static Integer TaskInitiation = 1;

    /**
     * 逐级发起
     **/
    public static Integer StepInitiation = 2;

    //----------------------审批人类型--------------------

    /**
     * 候选人
     **/
    public static Integer Candidates = 1;

    /**
     * 异常人
     **/
    public static Integer CandidatesError = 2;

    //----------------------外部事件状态--------------------

    /**
     * 成功
     **/
    public static Integer Success = 0;

    /**
     * 失败
     **/
    public static Integer Lose = 1;

    //----------------------审批方式--------------------

    /**
     * 选择分支
     **/
    public static Integer Branch = 3;

    /**
     * 重新审批
     **/
    public static Integer RestartType = 1;

    /**
     * 当前审批
     **/
    public static Integer PresentType = 2;

    //-------------------------审批类型---------------------------

    /**
     * 或签
     **/
    public static Integer FixedApprover = 0;

    /**
     * 会签
     **/
    public static Integer FixedJointlyApprover = 1;

    /**
     * 依次
     **/
    public static Integer ImproperApprover = 2;

    //-------------------------会签审批方式---------------------------

    /**
     * 会签计算方式，1.实时计算  2.延后计算
     */
    public static Integer CALCULATE_TYPE_DELAY = 2;

    /**
     * 百分比
     **/
    public static Integer Percent = 1;

    /**
     * 人数
     **/
    public static Integer Number = 2;

    //-------------------------审批状态---------------------------

    /**
     * 通过
     **/
    public static Integer AuditCompletion = 1;

    /**
     * 拒绝
     **/
    public static Integer RejectCompletion = 0;

    //-------------------------子流程类型---------------------------

    /**
     * 子流程同步
     **/
    public static Integer ChildSync = 0;

    /**
     * 子流程异步
     **/
    public static Integer ChildAsync = 1;

    //-------------------------加签类型---------------------------

    /**
     * 加签前
     */
    public static Integer Before = 1;

    /**
     * 加签后
     */
    public static Integer Later = 2;

    //-------------------------消息类型---------------------------

    /**
     * 发起消息
     */
    public static Integer StartMsg = 0;

    /**
     * 审批消息
     */
    public static Integer ApproveMsg = 1;

    /**
     * 结束消息
     */
    public static Integer EndMsg = 2;

    //-------------------------逐级审批---------------------------

    /**
     * 发起人
     */
    public static Integer Initiator = 1;

    /**
     * 上节点审批人
     */
    public static Integer Previously = 2;

    /**
     * 组织
     */
    public static Integer Organization = 3;

    //---------------------流程撤回---------------------------
    /**
     * 不允许撤回
     */
    public static Integer NotAllowed = 1;

    /**
     * 发起节点允许撤回
     */
    public static Integer StartAllowed = 2;

    /**
     * 所有节点允许撤回
     */
    public static Integer Allowed = 3;


    //---------------------撤回标识--------------------------
    /**
     * 发起撤回
     */
    public static Integer InitiateFlag = 1;

    /**
     * 审批撤回
     */
    public static Integer ApprovalFlag = 2;


    //---------------------归档---------------------------
    /**
     * 流程所有人
     */
    public static Integer FlowAll = 1;

    /**
     * 流程发起人
     */
    public static Integer FlowInitiator = 2;

    /**
     * 最后节点审批人
     */
    public static Integer FlowLast = 3;

    //---------------------流程是否恢复---------------------------

    /**
     * 能恢复
     */
    public static Integer Restore = 0;

    /**
     * 不能恢复
     */
    public static Integer NotRestore = 1;


    //---------------------流程显示类型---------------------------
    /**
     * 全局
     */
    public static Integer AllShowType = 0;

    /**
     * 流程
     */
    public static Integer FlowShowType = 1;

    /**
     * 菜单
     */
    public static Integer MenuShowType = 2;

    //---------------------流程权限类型---------------------------

    /**
     * 全局
     */
    public static Integer All = 1;

    /**
     * 权限
     */
    public static Integer Authority = 2;

    //---------------------流程类型---------------------------

    /**
     * 标准
     */
    public static Integer Standard = 0;

    /**
     * 简流
     */
    public static Integer Simple = 1;

    /**
     * 任务
     */
    public static Integer Quest = 2;


}
