package jnpf.flowable.model.trigger;

import jnpf.base.UserInfo;
import jnpf.flowable.entity.*;
import jnpf.flowable.model.templatenode.nodejson.NodeModel;
import jnpf.flowable.model.util.FlowNature;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 类的描述
 *
 * @author JNPF@YinMai Info. Co., Ltd
 * @version 5.0.x
 * @since 2024/9/10 20:44
 */
@Data
public class ExecuteModel {
    private String flowId;
    private String taskId;
    private String nodeCode;
    private String nodeId;
    private String groupId;
    private List<Map<String, Object>> dataList = new ArrayList<>();
    private UserInfo userInfo = new UserInfo();
    private String parentId = FlowNature.ParentId;
    private List<TemplateNodeEntity> nodeEntityList = new ArrayList<>();
    private String instanceId;

    private TemplateJsonEntity jsonEntity = new TemplateJsonEntity();
    private TaskEntity taskEntity = new TaskEntity();

    private TriggerTaskEntity triggerTask = new TriggerTaskEntity();
    private List<TriggerRecordEntity> recordList = new ArrayList<>();

    private NodeModel nodeModel = new NodeModel();

    /**
     * 当前执行节点，用于获取最后的执行节点引擎id
     */
    private String currentNodeId;

    private String triggerKey;

    private Integer isAsync;
}
