package jnpf.flowable.enums;

import lombok.Getter;

@Getter
public enum TemplateStatueEnum {

    /**
     * 未上架
     */
    none(0, "未上架"),
    /**
     * 上架
     */
    up(1, "上架"),
    /**
     * 下架-继续审批
     */
    downContinue(2, "下架-继续审批"),
    /**
     * 下架-隐藏审批
     */
    downHidden(3, "下架-隐藏审批"),
    ;

    private final Integer code;
    private final String message;

    TemplateStatueEnum(int code, String message) {
        this.code = code;
        this.message = message;
    }
}
