package jnpf.flowable.enums;

import lombok.Getter;

/**
 * 类的描述
 *
 * @author JNPF@YinMai Info. Co., Ltd
 * @version 5.0.x
 * @since 2024/4/26 17:32
 */
@Getter
public enum RecordEnum {
    //拒绝
    reject(0, "拒绝"),
    //同意
    audit(1, "同意"),
    //提交
    submit(2, "提交"),
    //退回
    back(3, "退回"),
    //撤回
    recall(4, "撤回"),
    //加签
    addSign(5, "加签"),
    //减签
    subtractSign(6, "减签"),
    //转审
    transfer(7, "转审"),
    //暂停
    pause(8, "暂停"),
    //重启
    reboot(9, "重启"),
    //复活
    activate(10, "复活"),
    //指派
    assign(11, "指派"),
    //催办
    press(12, "催办"),
    //协办
    assist(13, "协办"),
    //撤销
    revoke(14, "撤销"),
    //终止
    cancel(15, "终止"),

    auditRevoke(16, "同意撤销"),

    rejectRevoke(17, "拒绝撤销"),

    transferProcessing(18, "转办");

    private final Integer code;
    private final String message;

    RecordEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
