package jnpf.flowable.enums;

import lombok.Getter;

/**
 * 经办类型
 *
 * @author JNPF@YinMai Info. Co., Ltd
 * @version 5.0.x
 * @since 2024/4/23 17:23
 */
@Getter
public enum OperatorStateEnum {

    // 待去除
    WaitSign(0, "待签收"),

    Runing(1, "流转中"),

    AddSign(2, "加签"),

    Transfer(3, "转审"),

    Assigned(4, "指派"),

    Back(5, "退回"),

    Recall(6, "撤回"),

    Assist(7, "协办"),

    Revoke(8, "撤销"),

    TransferProcessing(9, "转办"),

    //无用节点
    Futility(-1, "无用节点"),
    // 用于嵌入的任务流程
    Waiting(-2, "未激活")
    ;

    private final Integer code;
    private final String message;

    OperatorStateEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

}
