package jnpf.flowable.enums;

import lombok.Getter;

@Getter
public enum OpTypeEnum {

    /**
     * 我发起的新建/编辑
     */
    LaunchCreate("-1", "我发起的新建/编辑"),
    /**
     * 我发起的详情
     */
    LaunchDetail("0", "我发起的详情"),
    /**
     * 待签事宜
     */
    Sign("1", "待签事宜"),
    /**
     * 待办事宜
     */
    Todo("2", "待办事宜"),
    /**
     * 在办事宜
     */
    Doing("3", "在办事宜"),
    /**
     * 已办事宜
     */
    Done("4", "已办事宜"),
    /**
     * 抄送事宜
     */
    Circulate("5", "抄送事宜"),
    /**
     * 流程监控
     */
    Monitor("6", "流程监控"),

    ;

    private final String type;
    private final String message;

    OpTypeEnum(String type, String message) {
        this.type = type;
        this.message = message;
    }

    /**
     * 根据状态code获取枚举名称
     *
     * @return
     */
    public static OpTypeEnum getType(String type) {
        for (OpTypeEnum status : OpTypeEnum.values()) {
            if (status.getType().equals(type)) {
                return status;
            }
        }
        return OpTypeEnum.LaunchCreate;
    }
}
