package jnpf.flowable.enums;

import lombok.Getter;


@Getter
public enum NodeStateEnum {
    /**
     * 已提交
     */
    submit(1, "已提交"),
    /**
     * 已通过
     */
    pass(2, "已通过"),
    /**
     * 已拒绝
     */
    reject(3, "已拒绝"),
    /**
     * 审批中
     */
    approval(4, "审批中"),
    /**
     * 已退回
     */
    back(5, "已退回"),
    /**
     * 已撤回
     */
    recall(6, "已撤回"),
    /**
     * 等待中
     */
    wait(7, "等待中"),
    /**
     * 待办理
     */
    transact(8, "待办理");

    private final Integer code;
    private final String message;

    NodeStateEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
