package jnpf.flowable.enums;

import lombok.Getter;

@Getter
public enum NodeEnum {
    /**
     * 开始
     */
    start("start"),
    /**
     * 结束
     */
    end("end"),
    /**
     * 全局
     */
    global("global"),
    /**
     * 子流程
     */
    subFlow("subFlow"),
    /**
     * 线
     */
    connect("connect"),
    /**
     * 审批
     */
    approver("approver"),
    /**
     * 办理
     */
    processing("processing"),
    /**
     * 外部
     */
    outside("outside"),
    /**
     * 触发事件
     */
    trigger("trigger"),
    /**
     * 事件触发
     */
    eventTrigger("eventTrigger"),
    /**
     * 定时触发
     */
    timeTrigger("timeTrigger"),
    /**
     * 通知触发
     */
    noticeTrigger("noticeTrigger"),
    /**
     * webhook触发
     */
    webhookTrigger("webhookTrigger"),
    /**
     * 获取数据
     */
    getData("getData"),
    /**
     * 新增数据
     */
    addData("addData"),
    /**
     * 更新数据
     */
    updateData("updateData"),
    /**
     * 删除数据
     */
    deleteData("deleteData"),
    /**
     * 数据接口
     */
    dataInterface("dataInterface"),
    /**
     * 消息通知
     */
    message("message"),
    /**
     * 发起审批
     */
    launchFlow("launchFlow"),
    /**
     * 创建日程
     */
    schedule("schedule");

    private final String type;

    NodeEnum(String type) {
        this.type = type;
    }

    /**
     * 根据状态code获取枚举名称
     *
     * @return
     */
    public static NodeEnum getNode(String code) {
        for (NodeEnum status : NodeEnum.values()) {
            if (status.getType().equals(code)) {
                return status;
            }
        }
        return NodeEnum.start;
    }
}
