package jnpf.flowable.enums;

import lombok.Getter;

/**
 * 附件条件
 *
 * @author ：JNPF开发平台组
 * @version: V3.1.0
 * @copyright 引迈信息技术有限公司
 * @date ：2022/6/14 16:50
 */
@Getter
public enum ExtraRuleEnum {
    /**
     * 无条件
     */
    none(1, "无条件"),
    /**
     * 同一部门
     */
    organize(2, "同一部门"),
    /**
     * 同一岗位
     */
    position(3, "同一岗位"),
    /**
     * 发起人上级
     */
    manager(4, "发起人上级"),
    /**
     * 发起人下属
     */
    subordinate(5, "发起人下属"),
    /**
     * 同一公司
     */
    department(6, "同一公司"),
    /**
     * 同一角色
     */
    role(7, "同一角色"),
    /**
     * 同一分组
     */
    group(8, "同一分组");

    private final Integer code;
    private final String message;

    ExtraRuleEnum(int code, String message) {
        this.code = code;
        this.message = message;
    }

    /**
     * 根据状态code获取枚举名称
     *
     * @return
     */
    public static ExtraRuleEnum getByCode(Integer code) {
        for (ExtraRuleEnum status : ExtraRuleEnum.values()) {
            if (status.getCode().equals(code)) {
                return status;
            }
        }
        return ExtraRuleEnum.none;
    }

}
