package jnpf.flowable.enums;

import lombok.Getter;

@Getter
public enum EventEnum {
    /**
     * 无
     */
    None(0, "无"),
    /**
     * 发起
     */
    Init(1, "发起"),
    /**
     * 结束
     */
    End(2, "结束"),
    /**
     * 发起撤回
     */
    FlowRecall(3, "发起撤回"),
    /**
     * 同意
     */
    Approve(4, "同意"),
    /**
     * 拒绝
     */
    Reject(5, "拒绝"),
    /**
     * 节点撤回
     */
    Recall(6, "节点撤回"),
    /**
     * 超时
     */
    Overtime(7, "超时"),
    /**
     * 提醒
     */
    Notice(8, "提醒"),
    /**
     * 退回
     */
    Back(9, "退回"),


    ;

    private final Integer status;
    private final String message;

    EventEnum(int status, String message) {
        this.status = status;
        this.message = message;
    }

    /**
     * 根据状态status获取枚举名称
     *
     * @return
     */
    public static EventEnum getEventStatus(Integer status) {
        for (EventEnum eventEnum : EventEnum.values()) {
            if (eventEnum.getStatus().equals(status)) {
                return eventEnum;
            }
        }
        return EventEnum.None;
    }
}
