package jnpf.flowable.enums;


import lombok.Getter;

@Getter
public enum CategoryEnum {
    /**
     * 没有经过
     */
    none("-1", "无"),
    /**
     * 待签事宜
     */
    Sign("0", "待签事宜"),
    /**
     * 待办事宜
     */
    Todo("1", "待办事宜"),
    /**
     * 在办事宜
     */
    Doing("2", "在办事宜"),
    /**
     * 已办事宜
     */
    Done("3", "已办事宜"),
    /**
     * 抄送事宜
     */
    Circulate("4", "抄送事宜"),
    /**
     * 批量在办事宜
     */
    BatchDoing("5", "批量在办事宜"),

    ;


    private final String type;
    private final String message;

    CategoryEnum(String type, String message) {
        this.type = type;
        this.message = message;
    }


    public static CategoryEnum getType(String type) {
        for (CategoryEnum status : CategoryEnum.values()) {
            if (status.getType().equals(type)) {
                return status;
            }
        }
        return CategoryEnum.none;
    }
}
