package jnpf.base.service.impl;


import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import jnpf.base.entity.SignatureUserEntity;
import jnpf.base.mapper.SignatureUserMapper;
import jnpf.base.service.SignatureUserService;
import jnpf.base.service.SuperServiceImpl;
import jnpf.util.RandomUtil;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 电子签章
 *
 * @author JNPF开发平台组
 * @copyright 引迈信息技术有限公司
 * @date 2022年9月2日 上午9:18
 */
@Service
public class SignatureUserServiceImpl extends SuperServiceImpl<SignatureUserMapper, SignatureUserEntity> implements SignatureUserService {

    @Override
    public List<SignatureUserEntity> getList(List<String> signatureId, List<String> userId) {
        QueryWrapper<SignatureUserEntity> queryWrapper = new QueryWrapper<>();
        if (ObjectUtil.isNotEmpty(signatureId)) {
            queryWrapper.lambda().in(SignatureUserEntity::getSignatureId, signatureId);
        }
        if (ObjectUtil.isNotEmpty(userId)) {
            queryWrapper.lambda().in(SignatureUserEntity::getUserId, userId);
        }
        return this.list(queryWrapper);
    }

    @Override
    public List<SignatureUserEntity> getList(String signatureId) {
        QueryWrapper<SignatureUserEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(SignatureUserEntity::getSignatureId, signatureId);
        return this.list(queryWrapper);
    }

    @Override
    public List<SignatureUserEntity> getListByUserId(String userId) {
        QueryWrapper<SignatureUserEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(SignatureUserEntity::getUserId, userId);
        return this.list(queryWrapper);
    }

    @Override
    public void create(SignatureUserEntity entity) {
        entity.setId(RandomUtil.uuId());
        this.save(entity);
    }

    @Override
    public void delete(String signatureId) {
        QueryWrapper<SignatureUserEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(SignatureUserEntity::getSignatureId, signatureId);
        this.remove(queryWrapper);
    }
}
