package jnpf.base.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import jnpf.base.entity.DataSetEntity;
import jnpf.base.entity.PrintVersionEntity;
import jnpf.base.mapper.PrintVersionMapper;
import jnpf.base.model.dataset.DataSetForm;
import jnpf.base.model.dataset.DataSetPagination;
import jnpf.base.model.print.PrintDevFormDTO;
import jnpf.base.service.DataSetService;
import jnpf.base.service.PrintVersionService;
import jnpf.base.service.SuperServiceImpl;
import jnpf.emnus.DataSetTypeEnum;
import jnpf.util.RandomUtil;
import jnpf.util.UserProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

/**
 * @author JNPF开发平台组
 * @version v5.0.0
 * @copyright 引迈信息技术有限公司
 * @date 2024/5/6 14:07:11
 */
@Service
public class PrintVersionServiceImpl extends SuperServiceImpl<PrintVersionMapper, PrintVersionEntity> implements PrintVersionService {

    @Autowired
    private DataSetService dataSetService;

    @Override
    @Transactional
    public void create(PrintDevFormDTO dto) {
        String versionId = RandomUtil.uuId();
        PrintVersionEntity entity = new PrintVersionEntity();
        entity.setId(versionId);
        entity.setTemplateId(dto.getId());
        entity.setCreatorUserId(UserProvider.getUser().getUserId());
        entity.setCreatorTime(new Date());
        entity.setPrintTemplate(dto.getPrintTemplate());
        entity.setConvertConfig(dto.getConvertConfig());
        entity.setGlobalConfig(dto.getGlobalConfig());
        List<PrintVersionEntity> verList = getList(entity.getId());
        int version = verList.stream().map(PrintVersionEntity::getVersion).max(Comparator.naturalOrder()).orElse(0) + 1;
        entity.setVersion(version);
        entity.setState(0);
        entity.setSortCode(0l);
        this.setIgnoreLogicDelete().removeById(entity.getId());
        this.setIgnoreLogicDelete().saveOrUpdate(entity);
        this.clearIgnoreLogicDelete();
        //数据集创建
        List<DataSetForm> dataSetList = dto.getDataSetList() != null ? dto.getDataSetList() : new ArrayList<>();
        dataSetService.create(dataSetList, DataSetTypeEnum.PRINT_VER.getCode(), versionId);
    }

    @Override
    public List<PrintVersionEntity> getList(String templateId) {
        QueryWrapper<PrintVersionEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(PrintVersionEntity::getTemplateId, templateId);
        queryWrapper.lambda().orderByDesc(PrintVersionEntity::getSortCode).orderByAsc(PrintVersionEntity::getState);
        return this.list(queryWrapper);
    }

    @Override
    public String copyVersion(String versionId) {
        PrintVersionEntity entity = this.getById(versionId);
        PrintVersionEntity versionEntity = BeanUtil.copyProperties(entity, PrintVersionEntity.class);
        String newVersionId = RandomUtil.uuId();
        versionEntity.setId(newVersionId);
        List<PrintVersionEntity> verList = getList(entity.getTemplateId());
        int version = verList.stream().map(PrintVersionEntity::getVersion).max(Comparator.naturalOrder()).orElse(0) + 1;
        versionEntity.setVersion(version);
        versionEntity.setState(0);
        versionEntity.setSortCode(0l);
        versionEntity.setCreatorTime(new Date());
        versionEntity.setCreatorUserId(UserProvider.getUser().getUserId());
        versionEntity.setLastModifyTime(null);
        versionEntity.setLastModifyUserId(null);
        List<DataSetEntity> dataSetList = dataSetService.getList(new DataSetPagination(DataSetTypeEnum.PRINT_VER.getCode(), versionId));
        for (DataSetEntity item : dataSetList) {
            item.setId(RandomUtil.uuId());
            item.setObjectType(DataSetTypeEnum.PRINT_VER.getCode());
            item.setObjectId(newVersionId);
            item.setCreatorTime(new Date());
            item.setCreatorUserId(UserProvider.getUser().getUserId());
            item.setLastModifyTime(null);
            item.setLastModifyUserId(null);
            dataSetService.save(item);
        }
        this.save(versionEntity);
        return newVersionId;
    }

    @Override
    public void removeByTemplateId(String templateId) {
        List<PrintVersionEntity> list = this.getList(templateId);
        for(PrintVersionEntity item :list){
            QueryWrapper<DataSetEntity> dataSetWrapper = new QueryWrapper<>();
            dataSetWrapper.lambda().eq(DataSetEntity::getObjectType, DataSetTypeEnum.PRINT_VER.getCode());
            dataSetWrapper.lambda().eq(DataSetEntity::getObjectId, templateId);
            dataSetService.remove(dataSetWrapper);
            this.removeById(item);
        }
    }
}
