package jnpf.base.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import jnpf.base.UserInfo;
import jnpf.base.entity.ModuleEntity;
import jnpf.base.entity.ModuleUserNumEntity;
import jnpf.base.entity.SystemEntity;
import jnpf.base.mapper.ModuleUseNumMapper;
import jnpf.base.model.module.MenuSelectByUseNumVo;
import jnpf.base.service.ModuleService;
import jnpf.base.service.ModuleUseNumService;
import jnpf.base.service.SuperServiceImpl;
import jnpf.base.service.SystemService;
import jnpf.constant.JnpfConst;
import jnpf.util.JsonUtil;
import jnpf.util.UserProvider;
import jnpf.util.context.RequestContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

@Service
public class ModuleUseNumServiceImpl extends SuperServiceImpl<ModuleUseNumMapper, ModuleUserNumEntity> implements ModuleUseNumService {


    @Autowired
    private ModuleService moduleService;

    @Autowired
    private SystemService systemService;

    @Override
    public Boolean insertOrUpdateUseNum(String moduleId) {
        String appCode = RequestContext.getAppCode();
        UserInfo user = UserProvider.getUser();
        LambdaQueryWrapper<ModuleUserNumEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ModuleUserNumEntity::getModuleId, moduleId);
        queryWrapper.eq(ModuleUserNumEntity::getSystemCode, appCode);
        queryWrapper.eq(ModuleUserNumEntity::getUserId, user.getUserId());
        queryWrapper.eq(ModuleUserNumEntity::getSystemCode, appCode);
        ModuleUserNumEntity userNumEntity = this.getOne(queryWrapper);
        if (userNumEntity == null) {
            userNumEntity = new ModuleUserNumEntity();
            userNumEntity.setSystemCode(appCode);
            userNumEntity.setUserId(user.getUserId());
            userNumEntity.setModuleId(moduleId);
            userNumEntity.setUseNum(1);
            userNumEntity.setLastModifyTime(new Date());
            return this.save(userNumEntity);
        }
        userNumEntity.setSystemCode(appCode);
        userNumEntity.setUseNum(userNumEntity.getUseNum() + 1);
        userNumEntity.setLastModifyTime(null);
        return this.updateById(userNumEntity);
    }

    @Override
    public Boolean deleteUseNum(String ModuleId) {

        UserInfo user = UserProvider.getUser();
        LambdaQueryWrapper<ModuleUserNumEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ModuleUserNumEntity::getModuleId, ModuleId);
        queryWrapper.eq(ModuleUserNumEntity::getUserId, user.getUserId());
        return this.remove(queryWrapper);

    }

    /**
     * 获取常用数据
     *
     * @param type 0-最近常用 1-最近使用
     * @return 返回常用数据
     */
    @Override
    public List<MenuSelectByUseNumVo> getMenuUseNum(Integer type, List<String> authMenuList, List<ModuleEntity> allMenu) {
        if (CollectionUtil.isEmpty(authMenuList)) {
            return Collections.EMPTY_LIST;
        }
        boolean isPc = RequestContext.isOrignPc();
        String category = isPc ? JnpfConst.WEB : JnpfConst.APP;
        String appCode = RequestContext.getAppCode();
        SystemEntity infoByEnCode = systemService.getInfoByEnCode(appCode);

        UserInfo user = UserProvider.getUser();
        LambdaQueryWrapper<ModuleUserNumEntity> queryWrapper = new LambdaQueryWrapper<>();

        queryWrapper.eq(ModuleUserNumEntity::getUserId, user.getUserId());
        List<ModuleUserNumEntity> moduleUserNumEntities = this.list(queryWrapper);
        if (moduleUserNumEntities == null || moduleUserNumEntities.isEmpty()) {
            return new ArrayList<MenuSelectByUseNumVo>();
        }
        List<ModuleUserNumEntity> moduleUserNumEntityList = new ArrayList<>();
        if (type.equals(0)) {
            moduleUserNumEntityList = moduleUserNumEntities.stream()
                    .sorted(Comparator.comparing(ModuleUserNumEntity::getUseNum).reversed())
                    .distinct()
                    .collect(Collectors.toList());
        } else if (type.equals(1)) {
            moduleUserNumEntityList = moduleUserNumEntities.stream()
                    .sorted(Comparator.comparing(ModuleUserNumEntity::getLastModifyTime, Comparator.nullsLast(Comparator.naturalOrder())).reversed())
                    .distinct()
                    .collect(Collectors.toList());

        }
        if (CollectionUtil.isEmpty(moduleUserNumEntityList)) {
            return new ArrayList<>();
        }

        List<MenuSelectByUseNumVo> menuSelectByUseNumVos = new ArrayList<>();
        Map<String, ModuleEntity> moduleEntityMap = allMenu.stream().collect(Collectors.toMap(ModuleEntity::getId, t -> t));

        for (ModuleUserNumEntity moduleUserNumEntity : moduleUserNumEntityList) {
            ModuleEntity info = moduleEntityMap.get(moduleUserNumEntity.getModuleId());
            if (info != null && Objects.equals(info.getEnabledMark(), 1)) {
                MenuSelectByUseNumVo vo = JsonUtil.getJsonToBean(info, MenuSelectByUseNumVo.class);
                vo.setHasChildren(false);
                vo.setSystemCode(moduleUserNumEntity.getSystemCode());
                vo.setCategory(info.getCategory());
                if (menuSelectByUseNumVos.size() > 12) break;
                if (authMenuList.contains(vo.getId()) && category.equals(vo.getCategory())) {
                    if (vo.getSystemId().equals(infoByEnCode.getId()) || JnpfConst.MAIN_SYSTEM_CODE.equals(infoByEnCode.getEnCode())) {
                        menuSelectByUseNumVos.add(vo);
                    }
                }
            }
        }
        return menuSelectByUseNumVos;
    }

    @Override
    public List<MenuSelectByUseNumVo> getMenuUseNumRecent() {
        UserInfo user = UserProvider.getUser();

        return null;
    }
}
