package jnpf.controller;

import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import jnpf.base.ActionResult;
import jnpf.util.JsonUtil;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


import java.util.List;
import java.util.Map;

/**
 * 订单收款
 *
 * @author JNPF开发平台组
 * @version V1.2.191207
 * @copyright 引迈信息技术有限公司
 * @date 2019年9月26日 上午9:18
 */
@Tag(name = "报表应用", description =  "ReportTemplate")
@RestController
@RequestMapping("/api/extend/ReportTemplate")
public class ReportTemplateController {

    /**
     * 商品采购报表
     *
     * @return
     */
    @Operation(summary = "获取商品采购报表")
    @GetMapping("/Purchase")
    public ActionResult purchaseList() {
        String json = "[{\"f_date\":\"2015-11-30\",\"f_billNo\":\"CG20151130001\",\"f_buName\":\"长林电子材料厂\",\"f_invNo\":\"110013\",\"f_invName\":\"PVC包装纸\",\"f_unit\":\"箱\",\"f_location\":\"徐泾\",\"f_qty\":\"1000\",\"f_unitPrice\":\"12\",\"f_amount\":\"12000\",\"f_description\":null},{\"f_date\":\"2015-12-07\",\"f_billNo\":\"CG20151207001\",\"f_buName\":\"长林电子材料厂\",\"f_invNo\":\"110011\",\"f_invName\":\"泡棉\",\"f_unit\":\"箱\",\"f_location\":\"徐泾\",\"f_qty\":\"100\",\"f_unitPrice\":\"20\",\"f_amount\":\"2000\",\"f_description\":null},{\"f_date\":\"2015-12-08\",\"f_billNo\":\"CG20151208001\",\"f_buName\":\"长林电子材料厂\",\"f_invNo\":\"1001\",\"f_invName\":\"无纺布\",\"f_unit\":\"箱\",\"f_location\":\"徐泾\",\"f_qty\":\"900\",\"f_unitPrice\":\"30\",\"f_amount\":\"27000\",\"f_description\":null},{\"f_date\":\"2015-12-30\",\"f_billNo\":\"CG20151230001\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"110013\",\"f_invName\":\"LED灯套\",\"f_unit\":\"箱\",\"f_location\":\"徐泾\",\"f_qty\":\"5\",\"f_unitPrice\":\"100\",\"f_amount\":\"500\",\"f_description\":null},{\"f_date\":\"2016-01-03\",\"f_billNo\":\"CG20160103001\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"1002\",\"f_invName\":\"防尘罩\",\"f_unit\":\"箱\",\"f_location\":\"张江\",\"f_qty\":\"2\",\"f_unitPrice\":\"100\",\"f_amount\":\"200\",\"f_description\":null},{\"f_date\":\"2016-01-03\",\"f_billNo\":\"CG20160103001\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"110011\",\"f_invName\":\"1号连接线\",\"f_unit\":\"箱\",\"f_location\":\"张江\",\"f_qty\":\"1\",\"f_unitPrice\":\"100\",\"f_amount\":\"100\",\"f_description\":null},{\"f_date\":\"2016-01-03\",\"f_billNo\":\"CG20160103001\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"2001\",\"f_invName\":\"12#线路板\",\"f_unit\":\"吨\",\"f_location\":\"张江\",\"f_qty\":\"1\",\"f_unitPrice\":\"9000\",\"f_amount\":\"9000\",\"f_description\":null},{\"f_date\":\"2016-01-23\",\"f_billNo\":\"CG20160123001\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"C00002\",\"f_invName\":\"防尘罩\",\"f_unit\":\"吨\",\"f_location\":\"张江\",\"f_qty\":\"3\",\"f_unitPrice\":\"9000\",\"f_amount\":\"27000\",\"f_description\":null},{\"f_date\":\"2016-02-10\",\"f_billNo\":\"CG20160210001\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"1001\",\"f_invName\":\"1号连接线\",\"f_unit\":\"吨\",\"f_location\":\"张江\",\"f_qty\":\"4\",\"f_unitPrice\":\"8000\",\"f_amount\":\"32000\",\"f_description\":null},{\"f_date\":\"2016-02-22\",\"f_billNo\":\"CG20160222001\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"A0001\",\"f_invName\":\"12#线路板\",\"f_unit\":\"箱\",\"f_location\":\"陆家嘴\",\"f_qty\":\"8\",\"f_unitPrice\":\"800\",\"f_amount\":\"6400\",\"f_description\":null},{\"f_date\":\"2016-03-02\",\"f_billNo\":\"CG20160302001\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"1001\",\"f_invName\":\"12#线路板\",\"f_unit\":\"箱\",\"f_location\":\"陆家嘴\",\"f_qty\":\"1\",\"f_unitPrice\":\"800\",\"f_amount\":\"800\",\"f_description\":null},{\"f_date\":\"2016-03-24\",\"f_billNo\":\"CG20160324001\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"A0001\",\"f_invName\":\"防尘罩\",\"f_unit\":\"箱\",\"f_location\":\"陆家嘴\",\"f_qty\":\"1\",\"f_unitPrice\":\"500\",\"f_amount\":\"500\",\"f_description\":null},{\"f_date\":\"2016-03-25\",\"f_billNo\":\"CG20160325001\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"C00004\",\"f_invName\":\"LED灯套\",\"f_unit\":\"箱\",\"f_location\":\"陆家嘴\",\"f_qty\":\"1\",\"f_unitPrice\":\"900\",\"f_amount\":\"900\",\"f_description\":null},{\"f_date\":\"2016-03-25\",\"f_billNo\":\"CG20160325001\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"1002\",\"f_invName\":\"12#线路板\",\"f_unit\":\"箱\",\"f_location\":\"陆家嘴\",\"f_qty\":\"2\",\"f_unitPrice\":\"400\",\"f_amount\":\"800\",\"f_description\":null},{\"f_date\":\"2016-03-25\",\"f_billNo\":\"CG20160325002\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"110011\",\"f_invName\":\"LED灯套\",\"f_unit\":\"箱\",\"f_location\":\"陆家嘴\",\"f_qty\":\"6\",\"f_unitPrice\":\"700\",\"f_amount\":\"42000\",\"f_description\":null},{\"f_date\":\"2016-03-25\",\"f_billNo\":\"CG20160325002\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"2001\",\"f_invName\":\"1号连接线\",\"f_unit\":\"箱\",\"f_location\":\"陆家嘴\",\"f_qty\":\"5\",\"f_unitPrice\":\"400\",\"f_amount\":\"2000\",\"f_description\":null},{\"f_date\":\"2016-04-13\",\"f_billNo\":\"CG20160413001\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"110011\",\"f_invName\":\"LED灯套\",\"f_unit\":\"箱\",\"f_location\":\"陆家嘴\",\"f_qty\":\"6\",\"f_unitPrice\":\"500\",\"f_amount\":\"3000\",\"f_description\":null},{\"f_date\":\"2016-04-13\",\"f_billNo\":\"CG20160402001\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"1001\",\"f_invName\":\"12#线路板\",\"f_unit\":\"箱\",\"f_location\":\"陆家嘴\",\"f_qty\":\"1\",\"f_unitPrice\":\"800\",\"f_amount\":\"800\",\"f_description\":null},{\"f_date\":\"2016-04-13\",\"f_billNo\":\"CG20160424001\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"A0001\",\"f_invName\":\"防尘罩\",\"f_unit\":\"箱\",\"f_location\":\"陆家嘴\",\"f_qty\":\"1\",\"f_unitPrice\":\"500\",\"f_amount\":\"500\",\"f_description\":null},{\"f_date\":\"2016-04-13\",\"f_billNo\":\"CG20160425001\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"C00004\",\"f_invName\":\"LED灯套\",\"f_unit\":\"箱\",\"f_location\":\"陆家嘴\",\"f_qty\":\"1\",\"f_unitPrice\":\"900\",\"f_amount\":\"900\",\"f_description\":null},{\"f_date\":\"2016-04-13\",\"f_billNo\":\"CG20160425001\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"1002\",\"f_invName\":\"12#线路板\",\"f_unit\":\"箱\",\"f_location\":\"陆家嘴\",\"f_qty\":\"2\",\"f_unitPrice\":\"400\",\"f_amount\":\"800\",\"f_description\":null},{\"f_date\":\"2016-04-13\",\"f_billNo\":\"CG20160425002\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"110011\",\"f_invName\":\"LED灯套\",\"f_unit\":\"箱\",\"f_location\":\"陆家嘴\",\"f_qty\":\"6\",\"f_unitPrice\":\"700\",\"f_amount\":\"42000\",\"f_description\":null},{\"f_date\":\"2016-04-13\",\"f_billNo\":\"CG20160425002\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"2001\",\"f_invName\":\"1号连接线\",\"f_unit\":\"箱\",\"f_location\":\"陆家嘴\",\"f_qty\":\"5\",\"f_unitPrice\":\"400\",\"f_amount\":\"2000\",\"f_description\":null}]";
        List<Map<String, Object>> data = JsonUtil.getJsonToListMap(json);
        return ActionResult.success(data);
    }

    /**
     * 商品采购报表 - 导出Excel
     *
     * @return
     */
    @Operation(summary = "（待定）商品采购报表 - 导出Excel")
    @GetMapping("/PurchaseToExcel")
    public void purchaseToExcel() {
        String json = "[{\"f_date\":\"2015-11-30\",\"f_billNo\":\"CG20151130001\",\"f_buName\":\"长林电子材料厂\",\"f_invNo\":\"110013\",\"f_invName\":\"PVC包装纸\",\"f_unit\":\"箱\",\"f_location\":\"徐泾\",\"f_qty\":\"1000\",\"f_unitPrice\":\"12\",\"f_amount\":\"12000\",\"f_description\":null},{\"f_date\":\"2015-12-07\",\"f_billNo\":\"CG20151207001\",\"f_buName\":\"长林电子材料厂\",\"f_invNo\":\"110011\",\"f_invName\":\"泡棉\",\"f_unit\":\"箱\",\"f_location\":\"徐泾\",\"f_qty\":\"100\",\"f_unitPrice\":\"20\",\"f_amount\":\"2000\",\"f_description\":null},{\"f_date\":\"2015-12-08\",\"f_billNo\":\"CG20151208001\",\"f_buName\":\"长林电子材料厂\",\"f_invNo\":\"1001\",\"f_invName\":\"无纺布\",\"f_unit\":\"箱\",\"f_location\":\"徐泾\",\"f_qty\":\"900\",\"f_unitPrice\":\"30\",\"f_amount\":\"27000\",\"f_description\":null},{\"f_date\":\"2015-12-30\",\"f_billNo\":\"CG20151230001\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"110013\",\"f_invName\":\"LED灯套\",\"f_unit\":\"箱\",\"f_location\":\"徐泾\",\"f_qty\":\"5\",\"f_unitPrice\":\"100\",\"f_amount\":\"500\",\"f_description\":null},{\"f_date\":\"2016-01-03\",\"f_billNo\":\"CG20160103001\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"1002\",\"f_invName\":\"防尘罩\",\"f_unit\":\"箱\",\"f_location\":\"张江\",\"f_qty\":\"2\",\"f_unitPrice\":\"100\",\"f_amount\":\"200\",\"f_description\":null},{\"f_date\":\"2016-01-03\",\"f_billNo\":\"CG20160103001\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"110011\",\"f_invName\":\"1号连接线\",\"f_unit\":\"箱\",\"f_location\":\"张江\",\"f_qty\":\"1\",\"f_unitPrice\":\"100\",\"f_amount\":\"100\",\"f_description\":null},{\"f_date\":\"2016-01-03\",\"f_billNo\":\"CG20160103001\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"2001\",\"f_invName\":\"12#线路板\",\"f_unit\":\"吨\",\"f_location\":\"张江\",\"f_qty\":\"1\",\"f_unitPrice\":\"9000\",\"f_amount\":\"9000\",\"f_description\":null},{\"f_date\":\"2016-01-23\",\"f_billNo\":\"CG20160123001\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"C00002\",\"f_invName\":\"防尘罩\",\"f_unit\":\"吨\",\"f_location\":\"张江\",\"f_qty\":\"3\",\"f_unitPrice\":\"9000\",\"f_amount\":\"27000\",\"f_description\":null},{\"f_date\":\"2016-02-10\",\"f_billNo\":\"CG20160210001\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"1001\",\"f_invName\":\"1号连接线\",\"f_unit\":\"吨\",\"f_location\":\"张江\",\"f_qty\":\"4\",\"f_unitPrice\":\"8000\",\"f_amount\":\"32000\",\"f_description\":null},{\"f_date\":\"2016-02-22\",\"f_billNo\":\"CG20160222001\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"A0001\",\"f_invName\":\"12#线路板\",\"f_unit\":\"箱\",\"f_location\":\"陆家嘴\",\"f_qty\":\"8\",\"f_unitPrice\":\"800\",\"f_amount\":\"6400\",\"f_description\":null},{\"f_date\":\"2016-03-02\",\"f_billNo\":\"CG20160302001\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"1001\",\"f_invName\":\"12#线路板\",\"f_unit\":\"箱\",\"f_location\":\"陆家嘴\",\"f_qty\":\"1\",\"f_unitPrice\":\"800\",\"f_amount\":\"800\",\"f_description\":null},{\"f_date\":\"2016-03-24\",\"f_billNo\":\"CG20160324001\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"A0001\",\"f_invName\":\"防尘罩\",\"f_unit\":\"箱\",\"f_location\":\"陆家嘴\",\"f_qty\":\"1\",\"f_unitPrice\":\"500\",\"f_amount\":\"500\",\"f_description\":null},{\"f_date\":\"2016-03-25\",\"f_billNo\":\"CG20160325001\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"C00004\",\"f_invName\":\"LED灯套\",\"f_unit\":\"箱\",\"f_location\":\"陆家嘴\",\"f_qty\":\"1\",\"f_unitPrice\":\"900\",\"f_amount\":\"900\",\"f_description\":null},{\"f_date\":\"2016-03-25\",\"f_billNo\":\"CG20160325001\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"1002\",\"f_invName\":\"12#线路板\",\"f_unit\":\"箱\",\"f_location\":\"陆家嘴\",\"f_qty\":\"2\",\"f_unitPrice\":\"400\",\"f_amount\":\"800\",\"f_description\":null},{\"f_date\":\"2016-03-25\",\"f_billNo\":\"CG20160325002\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"110011\",\"f_invName\":\"LED灯套\",\"f_unit\":\"箱\",\"f_location\":\"陆家嘴\",\"f_qty\":\"6\",\"f_unitPrice\":\"700\",\"f_amount\":\"42000\",\"f_description\":null},{\"f_date\":\"2016-03-25\",\"f_billNo\":\"CG20160325002\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"2001\",\"f_invName\":\"1号连接线\",\"f_unit\":\"箱\",\"f_location\":\"陆家嘴\",\"f_qty\":\"5\",\"f_unitPrice\":\"400\",\"f_amount\":\"2000\",\"f_description\":null},{\"f_date\":\"2016-04-13\",\"f_billNo\":\"CG20160413001\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"110011\",\"f_invName\":\"LED灯套\",\"f_unit\":\"箱\",\"f_location\":\"陆家嘴\",\"f_qty\":\"6\",\"f_unitPrice\":\"500\",\"f_amount\":\"3000\",\"f_description\":null},{\"f_date\":\"2016-04-13\",\"f_billNo\":\"CG20160402001\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"1001\",\"f_invName\":\"12#线路板\",\"f_unit\":\"箱\",\"f_location\":\"陆家嘴\",\"f_qty\":\"1\",\"f_unitPrice\":\"800\",\"f_amount\":\"800\",\"f_description\":null},{\"f_date\":\"2016-04-13\",\"f_billNo\":\"CG20160424001\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"A0001\",\"f_invName\":\"防尘罩\",\"f_unit\":\"箱\",\"f_location\":\"陆家嘴\",\"f_qty\":\"1\",\"f_unitPrice\":\"500\",\"f_amount\":\"500\",\"f_description\":null},{\"f_date\":\"2016-04-13\",\"f_billNo\":\"CG20160425001\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"C00004\",\"f_invName\":\"LED灯套\",\"f_unit\":\"箱\",\"f_location\":\"陆家嘴\",\"f_qty\":\"1\",\"f_unitPrice\":\"900\",\"f_amount\":\"900\",\"f_description\":null},{\"f_date\":\"2016-04-13\",\"f_billNo\":\"CG20160425001\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"1002\",\"f_invName\":\"12#线路板\",\"f_unit\":\"箱\",\"f_location\":\"陆家嘴\",\"f_qty\":\"2\",\"f_unitPrice\":\"400\",\"f_amount\":\"800\",\"f_description\":null},{\"f_date\":\"2016-04-13\",\"f_billNo\":\"CG20160425002\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"110011\",\"f_invName\":\"LED灯套\",\"f_unit\":\"箱\",\"f_location\":\"陆家嘴\",\"f_qty\":\"6\",\"f_unitPrice\":\"700\",\"f_amount\":\"42000\",\"f_description\":null},{\"f_date\":\"2016-04-13\",\"f_billNo\":\"CG20160425002\",\"f_buName\":\"金鑫五金厂\",\"f_invNo\":\"2001\",\"f_invName\":\"1号连接线\",\"f_unit\":\"箱\",\"f_location\":\"陆家嘴\",\"f_qty\":\"5\",\"f_unitPrice\":\"400\",\"f_amount\":\"2000\",\"f_description\":null}]";
        List<Map<String, Object>> data = JsonUtil.getJsonToListMap(json);
    }

    /**
     * 演示分组报表
     *
     * @return
     */
    @Operation(summary = "（待定）演示分组报表 - 导出Excel")
    @GetMapping("/GroupList")
    public ActionResult groupList() {
        String json = "[{\"F_DepartmentName\":\"综合部\",\"F_UserId\":\"1\",\"F_UserName\":\"申志强\",\"F_Salary\":\"15,000.00\",\"F_Position\":\"人力资源\",\"F_EntryDate\":\"20141024\",\"F_Telephone\":\"13403555190\",\"F_Address\":\"辽宁\",\"F_ZipCode\":\"047300\"},{\"F_DepartmentName\":\"综合部\",\"F_UserId\":\"111\",\"F_UserName\":\"王建国\",\"F_Salary\":\"16,000.00\",\"F_Position\":\"人力资源\",\"F_EntryDate\":\"20141113\",\"F_Telephone\":\"15364758000\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"综合部\",\"F_UserId\":\"112\",\"F_UserName\":\"张义芳\",\"F_Salary\":\"20,000.00\",\"F_Position\":\"人力资源\",\"F_EntryDate\":\"20141117\",\"F_Telephone\":\"15935538888\",\"F_Address\":\"河南\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"综合部\",\"F_UserId\":\"113\",\"F_UserName\":\"原琼\",\"F_Salary\":\"20,000.50元\",\"F_Position\":\"人力资源\",\"F_EntryDate\":\"20141208\",\"F_Telephone\":\"13333550900\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"财务部\",\"F_UserId\":\"114\",\"F_UserName\":\"马惠军\",\"F_Salary\":\"12,000.00\",\"F_Position\":\"财务经理\",\"F_EntryDate\":\"20141015\",\"F_Telephone\":\"13383458811\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"财务部\",\"F_UserId\":\"115\",\"F_UserName\":\"武继宏\",\"F_Salary\":\"13,500.00\",\"F_Position\":\"财务经理\",\"F_EntryDate\":\"20140707\",\"F_Telephone\":\"13834776068\",\"F_Address\":\"山西\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"风险部\",\"F_UserId\":\"116\",\"F_UserName\":\"宋利敏\",\"F_Salary\":\"8,000.00\",\"F_Position\":\"风控经理\",\"F_EntryDate\":\"20140707\",\"F_Telephone\":\"15234556806\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"风险部\",\"F_UserId\":\"117\",\"F_UserName\":\"王冀玲\",\"F_Salary\":\"10,000.00\",\"F_Position\":\"风控经理\",\"F_EntryDate\":\"20140707\",\"F_Telephone\":\"13333554333\",\"F_Address\":\"山东\",\"F_ZipCode\":\"047300\"},{\"F_DepartmentName\":\"资金部\",\"F_UserId\":\"118\",\"F_UserName\":\"李燕红\",\"F_Salary\":\"50,000.00\",\"F_Position\":\"资金经理\",\"F_EntryDate\":\"20140707\",\"F_Telephone\":\"13333550900\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"资金部\",\"F_UserId\":\"119\",\"F_UserName\":\"郑  强\",\"F_Salary\":\"16,000.00\",\"F_Position\":\"资金经理\",\"F_EntryDate\":\"20140707\",\"F_Telephone\":\"13383458811\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"121\",\"F_UserName\":\"冯  莅\",\"F_Salary\":\"20,000.00\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20140707\",\"F_Telephone\":\"13834776068\",\"F_Address\":\"天津\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"122\",\"F_UserName\":\"李静\",\"F_Salary\":\"20,000.50元\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20140707\",\"F_Telephone\":\"15234556806\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"总裁办\",\"F_UserId\":\"123\",\"F_UserName\":\"卫晓勤\",\"F_Salary\":\"12,000.00\",\"F_Position\":\"总助\",\"F_EntryDate\":\"20140707\",\"F_Telephone\":\"13333554333\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"风险部\",\"F_UserId\":\"124\",\"F_UserName\":\"张源\",\"F_Salary\":\"13,500.00\",\"F_Position\":\"风控经理\",\"F_EntryDate\":\"20140707\",\"F_Telephone\":\"13333550900\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"风险部\",\"F_UserId\":\"125\",\"F_UserName\":\"冯浩\",\"F_Salary\":\"8,000.00\",\"F_Position\":\"风控经理\",\"F_EntryDate\":\"20140707\",\"F_Telephone\":\"13383458811\",\"F_Address\":\"河北\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"资金部\",\"F_UserId\":\"126\",\"F_UserName\":\"张亚强\",\"F_Salary\":\"10,000.00\",\"F_Position\":\"资金经理\",\"F_EntryDate\":\"20140707\",\"F_Telephone\":\"15392555666\",\"F_Address\":\"石家庄\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"资金部\",\"F_UserId\":\"127\",\"F_UserName\":\"靳伟\",\"F_Salary\":\"50,000.00\",\"F_Position\":\"资金经理\",\"F_EntryDate\":\"20140707\",\"F_Telephone\":\"13994675055\",\"F_Address\":\"河北\",\"F_ZipCode\":\"047300\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"128\",\"F_UserName\":\"倪刚\",\"F_Salary\":\"10,000.00\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20140707\",\"F_Telephone\":\"13720964398\",\"F_Address\":\"石家庄\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"129\",\"F_UserName\":\"王泓杰\",\"F_Salary\":\"16,000.00\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20140707\",\"F_Telephone\":\"18625504986\",\"F_Address\":\"石家庄\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"130\",\"F_UserName\":\"李晓波\",\"F_Salary\":\"20,000.00\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20140707\",\"F_Telephone\":\"13935513232\",\"F_Address\":\"河北\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"131\",\"F_UserName\":\"张洋铭\",\"F_Salary\":\"20,000.50元\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20111219\",\"F_Telephone\":\"15234699068\",\"F_Address\":\"石家庄\",\"F_ZipCode\":\"046100\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"132\",\"F_UserName\":\"宋东\",\"F_Salary\":\"12,000.00\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20111219\",\"F_Telephone\":\"13453515589\",\"F_Address\":\"辽宁\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"133\",\"F_UserName\":\"李淑荣\",\"F_Salary\":\"13,500.00\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20111222\",\"F_Telephone\":\"13283557468\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"134\",\"F_UserName\":\"马垒布\",\"F_Salary\":\"8,000.00\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20111223\",\"F_Telephone\":\"18003456655\",\"F_Address\":\"河南\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"135\",\"F_UserName\":\"陈和平\",\"F_Salary\":\"10,000.00\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20111228\",\"F_Telephone\":\"18635531186\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"136\",\"F_UserName\":\"叶昌银\",\"F_Salary\":\"16,000.00\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20111229\",\"F_Telephone\":\"13203558555\",\"F_Address\":\"北京\",\"F_ZipCode\":\"047300\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"137\",\"F_UserName\":\"王增\",\"F_Salary\":\"20,000.00\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20120116\",\"F_Telephone\":\"15835557732\",\"F_Address\":\"山西\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"138\",\"F_UserName\":\"梁姝丽\",\"F_Salary\":\"20,000.50元\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20120118\",\"F_Telephone\":\"13453535388\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"139\",\"F_UserName\":\"申亚丽\",\"F_Salary\":\"12,000.00\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20120118\",\"F_Telephone\":\"18635559721\",\"F_Address\":\"山东\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"141\",\"F_UserName\":\"牛彩红\",\"F_Salary\":\"13,500.00\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20120119\",\"F_Telephone\":\"13835567286\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"142\",\"F_UserName\":\"陈玉芬\",\"F_Salary\":\"8,000.00\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20120208\",\"F_Telephone\":\"18636510130\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"143\",\"F_UserName\":\"秦虎明\",\"F_Salary\":\"10,000.00\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20120221\",\"F_Telephone\":\"15935502225\",\"F_Address\":\"天津\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"144\",\"F_UserName\":\"卢风莲\",\"F_Salary\":\"50,000.00\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20120301\",\"F_Telephone\":\"13509753890\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"风险部\",\"F_UserId\":\"145\",\"F_UserName\":\"李静\",\"F_Salary\":\"10,000.00\",\"F_Position\":\"风控经理\",\"F_EntryDate\":\"20120302\",\"F_Telephone\":\"18636518169\",\"F_Address\":\"北京\",\"F_ZipCode\":\"047300\"},{\"F_DepartmentName\":\"风险部\",\"F_UserId\":\"146\",\"F_UserName\":\"申建文\",\"F_Salary\":\"10,000.00\",\"F_Position\":\"风控经理\",\"F_EntryDate\":\"20120328\",\"F_Telephone\":\"13467048348\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"资金部\",\"F_UserId\":\"147\",\"F_UserName\":\"王慧芳\",\"F_Salary\":\"10,000.00\",\"F_Position\":\"资金经理\",\"F_EntryDate\":\"20120328\",\"F_Telephone\":\"13233363689\",\"F_Address\":\"河北\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"资金部\",\"F_UserId\":\"148\",\"F_UserName\":\"马建刚\",\"F_Salary\":\"10,000.00\",\"F_Position\":\"资金经理\",\"F_EntryDate\":\"20131017\",\"F_Telephone\":\"18235562999\",\"F_Address\":\"石家庄\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"综合部\",\"F_UserId\":\"149\",\"F_UserName\":\"孛森润\",\"F_Salary\":\"10,000.00\",\"F_Position\":\"人力资源\",\"F_EntryDate\":\"20131018\",\"F_Telephone\":\"13096666703\",\"F_Address\":\"河北\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"综合部\",\"F_UserId\":\"151\",\"F_UserName\":\"宋拴琴\",\"F_Salary\":\"10,000.00\",\"F_Position\":\"人力资源\",\"F_EntryDate\":\"20131028\",\"F_Telephone\":\"13994659670\",\"F_Address\":\"石家庄\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"综合部\",\"F_UserId\":\"152\",\"F_UserName\":\"姜旭军\",\"F_Salary\":\"10,001.50元\",\"F_Position\":\"综合部总监\",\"F_EntryDate\":\"20131030\",\"F_Telephone\":\"18636518186\",\"F_Address\":\"石家庄\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"财务部\",\"F_UserId\":\"153\",\"F_UserName\":\"丁路广\",\"F_Salary\":\"15,000.00\",\"F_Position\":\"财务部出纳\",\"F_EntryDate\":\"20130805\",\"F_Telephone\":\"15534555586\",\"F_Address\":\"辽宁\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"财务部\",\"F_UserId\":\"154\",\"F_UserName\":\"陈连胜\",\"F_Salary\":\"16,000.00\",\"F_Position\":\"财务部总监\",\"F_EntryDate\":\"20130805\",\"F_Telephone\":\"18903452550\",\"F_Address\":\"北京\",\"F_ZipCode\":\"047300\"},{\"F_DepartmentName\":\"风险部\",\"F_UserId\":\"155\",\"F_UserName\":\"苗艳芳\",\"F_Salary\":\"20,000.00\",\"F_Position\":\"风控经理\",\"F_EntryDate\":\"20130829\",\"F_Telephone\":\"13994633133\",\"F_Address\":\"河南\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"风险部\",\"F_UserId\":\"156\",\"F_UserName\":\"张俊莲\",\"F_Salary\":\"20,000.50元\",\"F_Position\":\"风控总监\",\"F_EntryDate\":\"20130829\",\"F_Telephone\":\"13994631297\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"资金部\",\"F_UserId\":\"157\",\"F_UserName\":\"陈永庆\",\"F_Salary\":\"12,000.00\",\"F_Position\":\"资金经理\",\"F_EntryDate\":\"20130917\",\"F_Telephone\":\"15534578988\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"资金部\",\"F_UserId\":\"158\",\"F_UserName\":\"李晓飞\",\"F_Salary\":\"13,500.00\",\"F_Position\":\"资金总监\",\"F_EntryDate\":\"20130917\",\"F_Telephone\":\"15935533271\",\"F_Address\":\"山西\",\"F_ZipCode\":\"046100\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"159\",\"F_UserName\":\"葛明伟\",\"F_Salary\":\"8,000.00\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20130927\",\"F_Telephone\":\"18635550586\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"160\",\"F_UserName\":\"王金才\",\"F_Salary\":\"10,000.00\",\"F_Position\":\"业务总监\",\"F_EntryDate\":\"20131010\",\"F_Telephone\":\"15035554586\",\"F_Address\":\"山东\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"总裁办\",\"F_UserId\":\"161\",\"F_UserName\":\"王炜\",\"F_Salary\":\"50,000.00\",\"F_Position\":\"总裁CEO\",\"F_EntryDate\":\"20140409\",\"F_Telephone\":\"13333550900\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"总裁办\",\"F_UserId\":\"162\",\"F_UserName\":\"张亚楠\",\"F_Salary\":\"50,000.00\",\"F_Position\":\"总助\",\"F_EntryDate\":\"20140409\",\"F_Telephone\":\"13383458811\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"163\",\"F_UserName\":\"段卫军\",\"F_Salary\":\"8,000.00\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20140409\",\"F_Telephone\":\"13513553121\",\"F_Address\":\"天津\",\"F_ZipCode\":\"047300\"}]";
        List<Map<String, Object>> data = JsonUtil.getJsonToListMap(json);
        return ActionResult.success(data);
    }

    /**
     * 演示分组报表 - 导出Excel
     *
     * @return
     */
    @Operation(summary = "（待定）演示分组报表 - 导出Excel")
    @GetMapping("/GroupToExcel")
    public void groupToExcel() {
        String json = "[{\"F_DepartmentName\":\"综合部\",\"F_UserId\":\"1\",\"F_UserName\":\"申志强\",\"F_Salary\":\"15,000.00\",\"F_Position\":\"人力资源\",\"F_EntryDate\":\"20141024\",\"F_Telephone\":\"13403555190\",\"F_Address\":\"辽宁\",\"F_ZipCode\":\"047300\"},{\"F_DepartmentName\":\"综合部\",\"F_UserId\":\"111\",\"F_UserName\":\"王建国\",\"F_Salary\":\"16,000.00\",\"F_Position\":\"人力资源\",\"F_EntryDate\":\"20141113\",\"F_Telephone\":\"15364758000\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"综合部\",\"F_UserId\":\"112\",\"F_UserName\":\"张义芳\",\"F_Salary\":\"20,000.00\",\"F_Position\":\"人力资源\",\"F_EntryDate\":\"20141117\",\"F_Telephone\":\"15935538888\",\"F_Address\":\"河南\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"综合部\",\"F_UserId\":\"113\",\"F_UserName\":\"原琼\",\"F_Salary\":\"20,000.50元\",\"F_Position\":\"人力资源\",\"F_EntryDate\":\"20141208\",\"F_Telephone\":\"13333550900\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"财务部\",\"F_UserId\":\"114\",\"F_UserName\":\"马惠军\",\"F_Salary\":\"12,000.00\",\"F_Position\":\"财务经理\",\"F_EntryDate\":\"20141015\",\"F_Telephone\":\"13383458811\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"财务部\",\"F_UserId\":\"115\",\"F_UserName\":\"武继宏\",\"F_Salary\":\"13,500.00\",\"F_Position\":\"财务经理\",\"F_EntryDate\":\"20140707\",\"F_Telephone\":\"13834776068\",\"F_Address\":\"山西\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"风险部\",\"F_UserId\":\"116\",\"F_UserName\":\"宋利敏\",\"F_Salary\":\"8,000.00\",\"F_Position\":\"风控经理\",\"F_EntryDate\":\"20140707\",\"F_Telephone\":\"15234556806\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"风险部\",\"F_UserId\":\"117\",\"F_UserName\":\"王冀玲\",\"F_Salary\":\"10,000.00\",\"F_Position\":\"风控经理\",\"F_EntryDate\":\"20140707\",\"F_Telephone\":\"13333554333\",\"F_Address\":\"山东\",\"F_ZipCode\":\"047300\"},{\"F_DepartmentName\":\"资金部\",\"F_UserId\":\"118\",\"F_UserName\":\"李燕红\",\"F_Salary\":\"50,000.00\",\"F_Position\":\"资金经理\",\"F_EntryDate\":\"20140707\",\"F_Telephone\":\"13333550900\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"资金部\",\"F_UserId\":\"119\",\"F_UserName\":\"郑  强\",\"F_Salary\":\"16,000.00\",\"F_Position\":\"资金经理\",\"F_EntryDate\":\"20140707\",\"F_Telephone\":\"13383458811\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"121\",\"F_UserName\":\"冯  莅\",\"F_Salary\":\"20,000.00\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20140707\",\"F_Telephone\":\"13834776068\",\"F_Address\":\"天津\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"122\",\"F_UserName\":\"李静\",\"F_Salary\":\"20,000.50元\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20140707\",\"F_Telephone\":\"15234556806\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"总裁办\",\"F_UserId\":\"123\",\"F_UserName\":\"卫晓勤\",\"F_Salary\":\"12,000.00\",\"F_Position\":\"总助\",\"F_EntryDate\":\"20140707\",\"F_Telephone\":\"13333554333\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"风险部\",\"F_UserId\":\"124\",\"F_UserName\":\"张源\",\"F_Salary\":\"13,500.00\",\"F_Position\":\"风控经理\",\"F_EntryDate\":\"20140707\",\"F_Telephone\":\"13333550900\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"风险部\",\"F_UserId\":\"125\",\"F_UserName\":\"冯浩\",\"F_Salary\":\"8,000.00\",\"F_Position\":\"风控经理\",\"F_EntryDate\":\"20140707\",\"F_Telephone\":\"13383458811\",\"F_Address\":\"河北\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"资金部\",\"F_UserId\":\"126\",\"F_UserName\":\"张亚强\",\"F_Salary\":\"10,000.00\",\"F_Position\":\"资金经理\",\"F_EntryDate\":\"20140707\",\"F_Telephone\":\"15392555666\",\"F_Address\":\"石家庄\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"资金部\",\"F_UserId\":\"127\",\"F_UserName\":\"靳伟\",\"F_Salary\":\"50,000.00\",\"F_Position\":\"资金经理\",\"F_EntryDate\":\"20140707\",\"F_Telephone\":\"13994675055\",\"F_Address\":\"河北\",\"F_ZipCode\":\"047300\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"128\",\"F_UserName\":\"倪刚\",\"F_Salary\":\"10,000.00\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20140707\",\"F_Telephone\":\"13720964398\",\"F_Address\":\"石家庄\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"129\",\"F_UserName\":\"王泓杰\",\"F_Salary\":\"16,000.00\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20140707\",\"F_Telephone\":\"18625504986\",\"F_Address\":\"石家庄\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"130\",\"F_UserName\":\"李晓波\",\"F_Salary\":\"20,000.00\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20140707\",\"F_Telephone\":\"13935513232\",\"F_Address\":\"河北\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"131\",\"F_UserName\":\"张洋铭\",\"F_Salary\":\"20,000.50元\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20111219\",\"F_Telephone\":\"15234699068\",\"F_Address\":\"石家庄\",\"F_ZipCode\":\"046100\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"132\",\"F_UserName\":\"宋东\",\"F_Salary\":\"12,000.00\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20111219\",\"F_Telephone\":\"13453515589\",\"F_Address\":\"辽宁\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"133\",\"F_UserName\":\"李淑荣\",\"F_Salary\":\"13,500.00\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20111222\",\"F_Telephone\":\"13283557468\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"134\",\"F_UserName\":\"马垒布\",\"F_Salary\":\"8,000.00\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20111223\",\"F_Telephone\":\"18003456655\",\"F_Address\":\"河南\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"135\",\"F_UserName\":\"陈和平\",\"F_Salary\":\"10,000.00\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20111228\",\"F_Telephone\":\"18635531186\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"136\",\"F_UserName\":\"叶昌银\",\"F_Salary\":\"16,000.00\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20111229\",\"F_Telephone\":\"13203558555\",\"F_Address\":\"北京\",\"F_ZipCode\":\"047300\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"137\",\"F_UserName\":\"王增\",\"F_Salary\":\"20,000.00\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20120116\",\"F_Telephone\":\"15835557732\",\"F_Address\":\"山西\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"138\",\"F_UserName\":\"梁姝丽\",\"F_Salary\":\"20,000.50元\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20120118\",\"F_Telephone\":\"13453535388\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"139\",\"F_UserName\":\"申亚丽\",\"F_Salary\":\"12,000.00\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20120118\",\"F_Telephone\":\"18635559721\",\"F_Address\":\"山东\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"141\",\"F_UserName\":\"牛彩红\",\"F_Salary\":\"13,500.00\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20120119\",\"F_Telephone\":\"13835567286\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"142\",\"F_UserName\":\"陈玉芬\",\"F_Salary\":\"8,000.00\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20120208\",\"F_Telephone\":\"18636510130\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"143\",\"F_UserName\":\"秦虎明\",\"F_Salary\":\"10,000.00\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20120221\",\"F_Telephone\":\"15935502225\",\"F_Address\":\"天津\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"144\",\"F_UserName\":\"卢风莲\",\"F_Salary\":\"50,000.00\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20120301\",\"F_Telephone\":\"13509753890\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"风险部\",\"F_UserId\":\"145\",\"F_UserName\":\"李静\",\"F_Salary\":\"10,000.00\",\"F_Position\":\"风控经理\",\"F_EntryDate\":\"20120302\",\"F_Telephone\":\"18636518169\",\"F_Address\":\"北京\",\"F_ZipCode\":\"047300\"},{\"F_DepartmentName\":\"风险部\",\"F_UserId\":\"146\",\"F_UserName\":\"申建文\",\"F_Salary\":\"10,000.00\",\"F_Position\":\"风控经理\",\"F_EntryDate\":\"20120328\",\"F_Telephone\":\"13467048348\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"资金部\",\"F_UserId\":\"147\",\"F_UserName\":\"王慧芳\",\"F_Salary\":\"10,000.00\",\"F_Position\":\"资金经理\",\"F_EntryDate\":\"20120328\",\"F_Telephone\":\"13233363689\",\"F_Address\":\"河北\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"资金部\",\"F_UserId\":\"148\",\"F_UserName\":\"马建刚\",\"F_Salary\":\"10,000.00\",\"F_Position\":\"资金经理\",\"F_EntryDate\":\"20131017\",\"F_Telephone\":\"18235562999\",\"F_Address\":\"石家庄\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"综合部\",\"F_UserId\":\"149\",\"F_UserName\":\"孛森润\",\"F_Salary\":\"10,000.00\",\"F_Position\":\"人力资源\",\"F_EntryDate\":\"20131018\",\"F_Telephone\":\"13096666703\",\"F_Address\":\"河北\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"综合部\",\"F_UserId\":\"151\",\"F_UserName\":\"宋拴琴\",\"F_Salary\":\"10,000.00\",\"F_Position\":\"人力资源\",\"F_EntryDate\":\"20131028\",\"F_Telephone\":\"13994659670\",\"F_Address\":\"石家庄\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"综合部\",\"F_UserId\":\"152\",\"F_UserName\":\"姜旭军\",\"F_Salary\":\"10,001.50元\",\"F_Position\":\"综合部总监\",\"F_EntryDate\":\"20131030\",\"F_Telephone\":\"18636518186\",\"F_Address\":\"石家庄\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"财务部\",\"F_UserId\":\"153\",\"F_UserName\":\"丁路广\",\"F_Salary\":\"15,000.00\",\"F_Position\":\"财务部出纳\",\"F_EntryDate\":\"20130805\",\"F_Telephone\":\"15534555586\",\"F_Address\":\"辽宁\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"财务部\",\"F_UserId\":\"154\",\"F_UserName\":\"陈连胜\",\"F_Salary\":\"16,000.00\",\"F_Position\":\"财务部总监\",\"F_EntryDate\":\"20130805\",\"F_Telephone\":\"18903452550\",\"F_Address\":\"北京\",\"F_ZipCode\":\"047300\"},{\"F_DepartmentName\":\"风险部\",\"F_UserId\":\"155\",\"F_UserName\":\"苗艳芳\",\"F_Salary\":\"20,000.00\",\"F_Position\":\"风控经理\",\"F_EntryDate\":\"20130829\",\"F_Telephone\":\"13994633133\",\"F_Address\":\"河南\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"风险部\",\"F_UserId\":\"156\",\"F_UserName\":\"张俊莲\",\"F_Salary\":\"20,000.50元\",\"F_Position\":\"风控总监\",\"F_EntryDate\":\"20130829\",\"F_Telephone\":\"13994631297\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"资金部\",\"F_UserId\":\"157\",\"F_UserName\":\"陈永庆\",\"F_Salary\":\"12,000.00\",\"F_Position\":\"资金经理\",\"F_EntryDate\":\"20130917\",\"F_Telephone\":\"15534578988\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"资金部\",\"F_UserId\":\"158\",\"F_UserName\":\"李晓飞\",\"F_Salary\":\"13,500.00\",\"F_Position\":\"资金总监\",\"F_EntryDate\":\"20130917\",\"F_Telephone\":\"15935533271\",\"F_Address\":\"山西\",\"F_ZipCode\":\"046100\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"159\",\"F_UserName\":\"葛明伟\",\"F_Salary\":\"8,000.00\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20130927\",\"F_Telephone\":\"18635550586\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"160\",\"F_UserName\":\"王金才\",\"F_Salary\":\"10,000.00\",\"F_Position\":\"业务总监\",\"F_EntryDate\":\"20131010\",\"F_Telephone\":\"15035554586\",\"F_Address\":\"山东\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"总裁办\",\"F_UserId\":\"161\",\"F_UserName\":\"王炜\",\"F_Salary\":\"50,000.00\",\"F_Position\":\"总裁CEO\",\"F_EntryDate\":\"20140409\",\"F_Telephone\":\"13333550900\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"总裁办\",\"F_UserId\":\"162\",\"F_UserName\":\"张亚楠\",\"F_Salary\":\"50,000.00\",\"F_Position\":\"总助\",\"F_EntryDate\":\"20140409\",\"F_Telephone\":\"13383458811\",\"F_Address\":\"北京\",\"F_ZipCode\":\"046000\"},{\"F_DepartmentName\":\"业务部\",\"F_UserId\":\"163\",\"F_UserName\":\"段卫军\",\"F_Salary\":\"8,000.00\",\"F_Position\":\"客户经理\",\"F_EntryDate\":\"20140409\",\"F_Telephone\":\"13513553121\",\"F_Address\":\"天津\",\"F_ZipCode\":\"047300\"}]";
        List<Map<String, Object>> data = JsonUtil.getJsonToListMap(json);
    }

    /**
     * 组合多图表报表
     *
     * @return
     */
    @Operation(summary = "获取组合多图表报表")
    @GetMapping("/Combination")
    public ActionResult combinationList() {
        String json = "[{\"F_UserName\":\"李贵宾\",\"F_Jan\":\"108\",\"F_Feb\":\"231\",\"F_Mar\":\"389\",\"F_Apr\":\"808\",\"F_May\":\"160\",\"F_Jun\":\"266\",\"F_Jul\":\"374\",\"F_Aug\":\"241\",\"F_Sep\":\"144\",\"F_Oct\":\"172\",\"F_Nov\":\"607\",\"F_Dec\":\"217\"},{\"F_UserName\":\"张琳蓉\",\"F_Jan\":\"205\",\"F_Feb\":\"249\",\"F_Mar\":\"552\",\"F_Apr\":\"71\",\"F_May\":\"511\",\"F_Jun\":\"236\",\"F_Jul\":\"795\",\"F_Aug\":\"10\",\"F_Sep\":\"31\",\"F_Oct\":\"38\",\"F_Nov\":\"107\",\"F_Dec\":\"344\"},{\"F_UserName\":\"邱杨佳\",\"F_Jan\":\"101\",\"F_Feb\":\"236\",\"F_Mar\":\"374\",\"F_Apr\":\"73\",\"F_May\":\"66\",\"F_Jun\":\"11\",\"F_Jul\":\"12\",\"F_Aug\":\"37\",\"F_Sep\":\"11\",\"F_Oct\":\"93\",\"F_Nov\":\"107\",\"F_Dec\":\"239\"},{\"F_UserName\":\"张红霞\",\"F_Jan\":\"738\",\"F_Feb\":\"451\",\"F_Mar\":\"37\",\"F_Apr\":\"404\",\"F_May\":\"336\",\"F_Jun\":\"373\",\"F_Jul\":\"715\",\"F_Aug\":\"678\",\"F_Sep\":\"437\",\"F_Oct\":\"551\",\"F_Nov\":\"101\",\"F_Dec\":\"127\"},{\"F_UserName\":\"朱鹏\",\"F_Jan\":\"256\",\"F_Feb\":\"221\",\"F_Mar\":\"104\",\"F_Apr\":\"115\",\"F_May\":\"289\",\"F_Jun\":\"654\",\"F_Jul\":\"488\",\"F_Aug\":\"225\",\"F_Sep\":\"267\",\"F_Oct\":\"127\",\"F_Nov\":\"0\",\"F_Dec\":\"314\"},{\"F_UserName\":\"张峰\",\"F_Jan\":\"488\",\"F_Feb\":\"535\",\"F_Mar\":\"115\",\"F_Apr\":\"667\",\"F_May\":\"370\",\"F_Jun\":\"379\",\"F_Jul\":\"90\",\"F_Aug\":\"437\",\"F_Sep\":\"115\",\"F_Oct\":\"267\",\"F_Nov\":\"372\",\"F_Dec\":\"438\"},{\"F_UserName\":\"王瑞\",\"F_Jan\":\"939\",\"F_Feb\":\"262\",\"F_Mar\":\"351\",\"F_Apr\":\"478\",\"F_May\":\"162\",\"F_Jun\":\"125\",\"F_Jul\":\"115\",\"F_Aug\":\"535\",\"F_Sep\":\"522\",\"F_Oct\":\"315\",\"F_Nov\":\"315\",\"F_Dec\":\"90\"},{\"F_UserName\":\"秦涛\",\"F_Jan\":\"146\",\"F_Feb\":\"488\",\"F_Mar\":\"535\",\"F_Apr\":\"127\",\"F_May\":\"906\",\"F_Jun\":\"66\",\"F_Jul\":\"607\",\"F_Aug\":\"116\",\"F_Sep\":\"93\",\"F_Oct\":\"618\",\"F_Nov\":\"66\",\"F_Dec\":\"643\"},{\"F_UserName\":\"郭强\",\"F_Jan\":\"108\",\"F_Feb\":\"268\",\"F_Mar\":\"653\",\"F_Apr\":\"314\",\"F_May\":\"481\",\"F_Jun\":\"535\",\"F_Jul\":\"132\",\"F_Aug\":\"12\",\"F_Sep\":\"336\",\"F_Oct\":\"768\",\"F_Nov\":\"244\",\"F_Dec\":\"122\"},{\"F_UserName\":\"赵丹\",\"F_Jan\":\"48\",\"F_Feb\":\"12\",\"F_Mar\":\"969\",\"F_Apr\":\"241\",\"F_May\":\"939\",\"F_Jun\":\"172\",\"F_Jul\":\"286\",\"F_Aug\":\"404\",\"F_Sep\":\"990\",\"F_Oct\":\"11\",\"F_Nov\":\"484\",\"F_Dec\":\"76\"}]";
        List<Map<String, Object>> data = JsonUtil.getJsonToListMap(json);
        return ActionResult.success(data);
    }

    /**
     * 月度工资对比表
     *
     * @return
     */
    @Operation(summary = "获取月度工资对比表")
    @GetMapping("/Month")
    public ActionResult monthList() {
        String json = "[{\"F_Item\":\"财务部\",\"F_LastMonthNumber\":\"2\",\"F_LastMonthPay\":\"9008\",\"F_ThisMonthNumber\":\"2\",\"F_ThisMonthPay\":\"12800\",\"F_ChangeNumber\":\"0\",\"F_ChangePay\":\"3792\",\"F_ChangeDescription\":\"\"},{\"F_Item\":\"企划部\",\"F_LastMonthNumber\":\"3\",\"F_LastMonthPay\":\"29280\",\"F_ThisMonthNumber\":\"3\",\"F_ThisMonthPay\":\"26235\",\"F_ChangeNumber\":\"0\",\"F_ChangePay\":\"-3045\",\"F_ChangeDescription\":\"\"},{\"F_Item\":\"招商运营部\",\"F_LastMonthNumber\":\"3\",\"F_LastMonthPay\":\"9392\",\"F_ThisMonthNumber\":\"2\",\"F_ThisMonthPay\":\"4092.31\",\"F_ChangeNumber\":\"-1\",\"F_ChangePay\":\"-5299.69\",\"F_ChangeDescription\":\"离职\"},{\"F_Item\":\"物业管理部\",\"F_LastMonthNumber\":\"4\",\"F_LastMonthPay\":\"16450\",\"F_ThisMonthNumber\":\"5\",\"F_ThisMonthPay\":\"1744.86\",\"F_ChangeNumber\":\"1\",\"F_ChangePay\":\"998.46\",\"F_ChangeDescription\":\"新招\"},{\"F_Item\":\"总经办\",\"F_LastMonthNumber\":\"0\",\"F_LastMonthPay\":\"0\",\"F_ThisMonthNumber\":\"2\",\"F_ThisMonthPay\":\"6264.23\",\"F_ChangeNumber\":\"2\",\"F_ChangePay\":\"6264.23\",\"F_ChangeDescription\":\"扩大队伍\"},{\"F_Item\":\"技术部\",\"F_LastMonthNumber\":\"3\",\"F_LastMonthPay\":\"7257\",\"F_ThisMonthNumber\":\"6\",\"F_ThisMonthPay\":\"6264.23\",\"F_ChangeNumber\":\"3\",\"F_ChangePay\":\"6061.85\",\"F_ChangeDescription\":\"业务增加\"},{\"F_Item\":\"调出\",\"F_LastMonthNumber\":\"4\",\"F_LastMonthPay\":\"10560\",\"F_ThisMonthNumber\":\"2\",\"F_ThisMonthPay\":\"7185\",\"F_ChangeNumber\":\"-2\",\"F_ChangePay\":\"-3375\",\"F_ChangeDescription\":\"\"}]";
        List<Map<String, Object>> data = JsonUtil.getJsonToListMap(json);
        return ActionResult.success(data);
    }

    /**
     * 月度工资对比表 - 导出Excel
     *
     * @return
     */
    @Operation(summary = "（待定）月度工资对比表 - 导出Excel")
    @GetMapping("/MonthToExcel")
    public void monthToExcel() {
        String json = "[{\"F_Item\":\"财务部\",\"F_LastMonthNumber\":\"2\",\"F_LastMonthPay\":\"9008\",\"F_ThisMonthNumber\":\"2\",\"F_ThisMonthPay\":\"12800\",\"F_ChangeNumber\":\"0\",\"F_ChangePay\":\"3792\",\"F_ChangeDescription\":\"\"},{\"F_Item\":\"企划部\",\"F_LastMonthNumber\":\"3\",\"F_LastMonthPay\":\"29280\",\"F_ThisMonthNumber\":\"3\",\"F_ThisMonthPay\":\"26235\",\"F_ChangeNumber\":\"0\",\"F_ChangePay\":\"-3045\",\"F_ChangeDescription\":\"\"},{\"F_Item\":\"招商运营部\",\"F_LastMonthNumber\":\"3\",\"F_LastMonthPay\":\"9392\",\"F_ThisMonthNumber\":\"2\",\"F_ThisMonthPay\":\"4092.31\",\"F_ChangeNumber\":\"-1\",\"F_ChangePay\":\"-5299.69\",\"F_ChangeDescription\":\"离职\"},{\"F_Item\":\"物业管理部\",\"F_LastMonthNumber\":\"4\",\"F_LastMonthPay\":\"16450\",\"F_ThisMonthNumber\":\"5\",\"F_ThisMonthPay\":\"1744.86\",\"F_ChangeNumber\":\"1\",\"F_ChangePay\":\"998.46\",\"F_ChangeDescription\":\"新招\"},{\"F_Item\":\"总经办\",\"F_LastMonthNumber\":\"0\",\"F_LastMonthPay\":\"0\",\"F_ThisMonthNumber\":\"2\",\"F_ThisMonthPay\":\"6264.23\",\"F_ChangeNumber\":\"2\",\"F_ChangePay\":\"6264.23\",\"F_ChangeDescription\":\"扩大队伍\"},{\"F_Item\":\"技术部\",\"F_LastMonthNumber\":\"3\",\"F_LastMonthPay\":\"7257\",\"F_ThisMonthNumber\":\"6\",\"F_ThisMonthPay\":\"6264.23\",\"F_ChangeNumber\":\"3\",\"F_ChangePay\":\"6061.85\",\"F_ChangeDescription\":\"业务增加\"},{\"F_Item\":\"调出\",\"F_LastMonthNumber\":\"4\",\"F_LastMonthPay\":\"10560\",\"F_ThisMonthNumber\":\"2\",\"F_ThisMonthPay\":\"7185\",\"F_ChangeNumber\":\"-2\",\"F_ChangePay\":\"-3375\",\"F_ChangeDescription\":\"\"}]";
        List<Map<String, Object>> data = JsonUtil.getJsonToListMap(json);
    }

    /**
     * 季度销售对比表
     *
     * @return
     */
    @Operation(summary = "获取季度销售对比表")
    @GetMapping("/Quarter")
    public ActionResult quarterList() {
        String json = "[{\"F_Year\":\"2017\",\"F_Quarter\":\"一季度\",\"F_Number\":\"100000\",\"F_Money\":\"4000000\",\"F_LastQuarter\":\"6.81\",\"F_LastYear\":\"0.992\"},{\"F_Year\":\"2017\",\"F_Quarter\":\"二季度\",\"F_Number\":\"3000000\",\"F_Money\":\"23450000\",\"F_LastQuarter\":\"7.5\",\"F_LastYear\":\"0.888\"},{\"F_Year\":\"2017\",\"F_Quarter\":\"三季度\",\"F_Number\":\"230000\",\"F_Money\":\"500000\",\"F_LastQuarter\":\"6.93\",\"F_LastYear\":\"0.777\"},{\"F_Year\":\"2017\",\"F_Quarter\":\"四季度\",\"F_Number\":\"50000000\",\"F_Money\":\"20000000\",\"F_LastQuarter\":\"23.5\",\"F_LastYear\":\"1.45\"},{\"F_Year\":\"2017\",\"F_Quarter\":\"合计\",\"F_Number\":\"53330000\",\"F_Money\":\"47950000\",\"F_LastQuarter\":\"\",\"F_LastYear\":\"\"},{\"F_Year\":\"2018\",\"F_Quarter\":\"一季度\",\"F_Number\":\"200000\",\"F_Money\":\"6000000\",\"F_LastQuarter\":\"8.81\",\"F_LastYear\":\"0.782\"},{\"F_Year\":\"2018\",\"F_Quarter\":\"二季度\",\"F_Number\":\"1500000\",\"F_Money\":\"230000\",\"F_LastQuarter\":\"4.5\",\"F_LastYear\":\"0.488\"},{\"F_Year\":\"2018\",\"F_Quarter\":\"三季度\",\"F_Number\":\"3000000\",\"F_Money\":\"532000\",\"F_LastQuarter\":\"8.93\",\"F_LastYear\":\"0.797\"},{\"F_Year\":\"2018\",\"F_Quarter\":\"四季度\",\"F_Number\":\"47000000\",\"F_Money\":\"212000\",\"F_LastQuarter\":\"12.5\",\"F_LastYear\":\"1.47\"},{\"F_Year\":\"2018\",\"F_Quarter\":\"合计\",\"F_Number\":\"51700000\",\"F_Money\":\"6974000\",\"F_LastQuarter\":\"\",\"F_LastYear\":\"\"}]";
        List<Map<String, Object>> data = JsonUtil.getJsonToListMap(json);
        return ActionResult.success(data);
    }

    /**
     * 季度销售对比表 - 导出Excel
     *
     * @return
     */
    @Operation(summary = "（待定）季度销售对比表 - 导出Excel")
    @GetMapping("/QuarterToExcel")
    public void quarterToExcel() {
        String json = "[{\"F_Year\":\"2017\",\"F_Quarter\":\"一季度\",\"F_Number\":\"100000\",\"F_Money\":\"4000000\",\"F_LastQuarter\":\"6.81\",\"F_LastYear\":\"0.992\"},{\"F_Year\":\"2017\",\"F_Quarter\":\"二季度\",\"F_Number\":\"3000000\",\"F_Money\":\"23450000\",\"F_LastQuarter\":\"7.5\",\"F_LastYear\":\"0.888\"},{\"F_Year\":\"2017\",\"F_Quarter\":\"三季度\",\"F_Number\":\"230000\",\"F_Money\":\"500000\",\"F_LastQuarter\":\"6.93\",\"F_LastYear\":\"0.777\"},{\"F_Year\":\"2017\",\"F_Quarter\":\"四季度\",\"F_Number\":\"50000000\",\"F_Money\":\"20000000\",\"F_LastQuarter\":\"23.5\",\"F_LastYear\":\"1.45\"},{\"F_Year\":\"2017\",\"F_Quarter\":\"合计\",\"F_Number\":\"53330000\",\"F_Money\":\"47950000\",\"F_LastQuarter\":\"\",\"F_LastYear\":\"\"},{\"F_Year\":\"2018\",\"F_Quarter\":\"一季度\",\"F_Number\":\"200000\",\"F_Money\":\"6000000\",\"F_LastQuarter\":\"8.81\",\"F_LastYear\":\"0.782\"},{\"F_Year\":\"2018\",\"F_Quarter\":\"二季度\",\"F_Number\":\"1500000\",\"F_Money\":\"230000\",\"F_LastQuarter\":\"4.5\",\"F_LastYear\":\"0.488\"},{\"F_Year\":\"2018\",\"F_Quarter\":\"三季度\",\"F_Number\":\"3000000\",\"F_Money\":\"532000\",\"F_LastQuarter\":\"8.93\",\"F_LastYear\":\"0.797\"},{\"F_Year\":\"2018\",\"F_Quarter\":\"四季度\",\"F_Number\":\"47000000\",\"F_Money\":\"212000\",\"F_LastQuarter\":\"12.5\",\"F_LastYear\":\"1.47\"},{\"F_Year\":\"2018\",\"F_Quarter\":\"合计\",\"F_Number\":\"51700000\",\"F_Money\":\"6974000\",\"F_LastQuarter\":\"\",\"F_LastYear\":\"\"}]";
        List<Map<String, Object>> data = JsonUtil.getJsonToListMap(json);
    }
}
