/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.util;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Properties;

public final class Debug {
    public static final int INFO = 1;
    public static final int ERROR = 2;
    public static final int TRACE = 4;
    private static final boolean SET = true;
    private static int flags = 0;
    private static PrintWriter writer = null;

    private Debug() {
    }

    private static void setOutput(String str) {
        if (writer == null) {
            if (str.equals("System.out")) {
                Debug.setOutput(System.out);
            } else if (str.equals("System.err")) {
                Debug.setOutput(System.err);
            } else {
                try {
                    Debug.setOutput(new FileWriter(str));
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    private static void setOutput(OutputStream stream) {
        Debug.setOutput(new OutputStreamWriter(stream));
    }

    private static void setOutput(Writer w) {
        if (writer != null) {
            writer.close();
        }
        writer = new PrintWriter((Writer)new BufferedWriter(w), true);
    }

    private static void setFlags(int f, boolean set) {
        flags = set ? (flags |= f) : (flags &= ~f);
    }

    public static boolean isFlagSet(int f) {
        return (flags & f) != 0;
    }

    public static void log(int flag, String msg) {
        if (Debug.isFlagSet(flag) && writer != null) {
            writer.println(msg);
        }
    }

    public static void log(int flag, String msg, Throwable e) {
        if (Debug.isFlagSet(flag) && writer != null) {
            writer.println(msg);
            if (e != null) {
                e.printStackTrace(writer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream is = null;
        try {
            try {
                is = Debug.class.getResourceAsStream("Debug.properties");
                Properties props = new Properties();
                props.load(is);
                String info = props.getProperty("debug.info", "false");
                info = info.toLowerCase();
                if (info.equals("true")) {
                    Debug.setFlags(1, true);
                }
                String trace = props.getProperty("debug.trace", "false");
                if ((trace = trace.toLowerCase()).equals("true")) {
                    Debug.setFlags(4, true);
                }
                String error = props.getProperty("debug.error", "false");
                if ((error = error.toLowerCase()).equals("true")) {
                    Debug.setFlags(2, true);
                }
                String w = props.getProperty("debug.output", "System.out");
                Debug.setOutput(w);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace(System.err);
        }
    }
}

