/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jfree.report.expressions.Expression;
import org.jfree.report.expressions.FormulaExpression;
import org.jfree.report.flow.DefaultReportJob;
import org.jfree.report.flow.ReportProcessor;
import org.jfree.report.flow.ReportStructureRoot;
import org.jfree.report.flow.raw.XmlPrintReportProcessor;
import org.jfree.report.structure.Node;
import org.jfree.report.structure.Section;
import org.jfree.report.util.ReportParameters;
import org.libreoffice.report.DataSourceFactory;
import org.libreoffice.report.ImageService;
import org.libreoffice.report.InputRepository;
import org.libreoffice.report.JobDefinitionException;
import org.libreoffice.report.JobProperties;
import org.libreoffice.report.OutputRepository;
import org.libreoffice.report.ParameterMap;
import org.libreoffice.report.ReportExecutionException;
import org.libreoffice.report.ReportJob;
import org.libreoffice.report.ReportJobDefinition;
import org.libreoffice.report.pentaho.StarReportDataFactory;
import org.libreoffice.report.pentaho.loader.InputRepositoryLoader;
import org.libreoffice.report.pentaho.model.OfficeDetailSection;
import org.libreoffice.report.pentaho.model.OfficeDocument;
import org.libreoffice.report.pentaho.model.OfficeGroup;
import org.libreoffice.report.pentaho.model.OfficeReport;
import org.libreoffice.report.pentaho.output.chart.ChartRawReportProcessor;
import org.libreoffice.report.pentaho.output.spreadsheet.SpreadsheetRawReportProcessor;
import org.libreoffice.report.pentaho.output.text.TextRawReportProcessor;
import org.pentaho.reporting.libraries.formula.lvalues.ContextLookup;
import org.pentaho.reporting.libraries.formula.lvalues.FormulaFunction;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.lvalues.Term;
import org.pentaho.reporting.libraries.formula.parser.FormulaParser;
import org.pentaho.reporting.libraries.formula.parser.ParseException;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class PentahoReportJob
implements ReportJob {
    private static final Logger LOGGER = Logger.getLogger(PentahoReportJob.class.getName());
    private final DataSourceFactory dataSourceFactory;
    private final OutputRepository outputRepository;
    private final JobProperties jobProperties;
    private OfficeDocument report;
    private final ResourceManager resourceManager;
    private final String outputName;
    private final ImageService imageService;
    private final InputRepository inputRepository;
    private final List masterValues;
    private final List detailColumns;

    public PentahoReportJob(ReportJobDefinition definition) throws JobDefinitionException {
        if (definition == null) {
            throw new NullPointerException();
        }
        this.jobProperties = definition.getProcessingParameters().copy();
        this.dataSourceFactory = (DataSourceFactory)this.jobProperties.getProperty("input.datasource-factory");
        if (this.dataSourceFactory == null) {
            throw new JobDefinitionException("DataSourceFactory must not be null.");
        }
        this.outputRepository = (OutputRepository)this.jobProperties.getProperty("output.repository");
        if (this.outputRepository == null) {
            throw new JobDefinitionException("OutputRepository must not be null.");
        }
        this.inputRepository = (InputRepository)this.jobProperties.getProperty("input.repository");
        if (this.inputRepository == null) {
            throw new JobDefinitionException("InputRepository must not be null.");
        }
        this.outputName = (String)this.jobProperties.getProperty("output.name");
        if (this.outputName == null) {
            throw new JobDefinitionException("OutputName must not be null");
        }
        this.imageService = (ImageService)this.jobProperties.getProperty("ImageService");
        if (this.imageService == null) {
            throw new JobDefinitionException("A valid image-service implementation must be given.");
        }
        this.masterValues = (ArrayList)this.jobProperties.getProperty("input.master-values");
        this.detailColumns = (ArrayList)this.jobProperties.getProperty("input.detail-columns");
        this.resourceManager = new ResourceManager();
        this.resourceManager.registerDefaults();
        this.resourceManager.registerLoader((ResourceLoader)new InputRepositoryLoader(this.inputRepository));
        try {
            this.report = this.parseReport(definition);
        }
        catch (ResourceException e) {
            throw new JobDefinitionException("Failed to parse the report.", (Exception)((Object)e));
        }
    }

    private OfficeDocument parseReport(ReportJobDefinition definition) throws ResourceException, JobDefinitionException {
        String reportResource = (String)this.jobProperties.getProperty("input.name");
        if (reportResource == null) {
            throw new JobDefinitionException("Report definition name must be given");
        }
        Resource res = this.resourceManager.createDirectly((Object)("sun:oo://" + reportResource), OfficeDocument.class);
        OfficeDocument tempReport = (OfficeDocument)((Object)res.getResource());
        tempReport.setDataFactory(new StarReportDataFactory(this.dataSourceFactory));
        tempReport.setJobProperties(definition.getProcessingParameters().copy());
        ReportParameters inputParameters = tempReport.getInputParameters();
        ParameterMap queryParameters = definition.getQueryParameters();
        String[] paramKeys = queryParameters.keys();
        for (int i = 0; i < paramKeys.length; ++i) {
            String key = paramKeys[i];
            inputParameters.put(key, queryParameters.get(key));
        }
        return tempReport;
    }

    private void collectGroupExpressions(Node[] nodes, List<Object[]> expressions, FormulaParser parser, Expression[] reportFunctions) {
        for (int i = 0; i < nodes.length; ++i) {
            Node node = nodes[i];
            if (node instanceof OfficeGroup) {
                OfficeGroup group = (OfficeGroup)node;
                FormulaExpression exp = (FormulaExpression)group.getGroupingExpression();
                if (exp == null) continue;
                try {
                    String expression = exp.getFormulaExpression();
                    if (expression == null) continue;
                    FormulaFunction function = (FormulaFunction)parser.parse(expression);
                    LValue[] parameters = function.getChildValues();
                    if (parameters.length > 0) {
                        String name = parameters[0].toString();
                        if (parameters[0] instanceof ContextLookup) {
                            ContextLookup context = (ContextLookup)parameters[0];
                            name = context.getName();
                        }
                        for (int j = 0; j < reportFunctions.length; ++j) {
                            FormulaExpression reportExp;
                            if (!(reportFunctions[j] instanceof FormulaExpression) || !(reportExp = (FormulaExpression)reportFunctions[j]).getName().equals(name)) continue;
                            LValue val = parser.parse(reportExp.getFormulaExpression());
                            while (!(val instanceof ContextLookup)) {
                                if (val instanceof Term) {
                                    val = ((Term)val).getHeadValue();
                                    continue;
                                }
                                if (!(val instanceof FormulaFunction)) continue;
                                FormulaFunction reportFunction = (FormulaFunction)val;
                                val = reportFunction.getChildValues()[0];
                            }
                            ContextLookup context = (ContextLookup)val;
                            name = context.getName();
                            break;
                        }
                        Object[] pair = new Object[]{name, group.getAttribute("http://openoffice.org/2005/report", "sort-ascending")};
                        expressions.add(pair);
                    }
                }
                catch (ParseException ex) {
                    LOGGER.severe("ReportProcessing failed: " + (Object)((Object)ex));
                }
            } else if (node instanceof OfficeDetailSection) {
                return;
            }
            if (!(node instanceof Section)) continue;
            Section section = (Section)node;
            this.collectGroupExpressions(section.getNodeArray(), expressions, parser, reportFunctions);
        }
    }

    private void collectSortExpressions(Node[] nodes, List<Object[]> expressions, FormulaParser parser, Expression[] reportFunctions) {
        for (int i = 0; i < nodes.length; ++i) {
            Node node = nodes[i];
            if (node instanceof OfficeGroup) {
                OfficeGroup group = (OfficeGroup)node;
                String exp = group.getSortingExpression();
                if (exp == null) continue;
                Object[] pair = new Object[]{exp, group.getAttribute("http://openoffice.org/2005/report", "sort-ascending")};
                expressions.add(pair);
            } else if (node instanceof OfficeDetailSection) {
                return;
            }
            if (!(node instanceof Section)) continue;
            Section section = (Section)node;
            this.collectSortExpressions(section.getNodeArray(), expressions, parser, reportFunctions);
        }
    }

    private void setMetaDataProperties(DefaultReportJob job) {
        job.getConfiguration().setConfigProperty("Author", (String)this.jobProperties.getProperty("Author"));
        job.getConfiguration().setConfigProperty("Title", (String)this.jobProperties.getProperty("Title"));
    }

    @Override
    public void execute() throws ReportExecutionException, IOException {
        DefaultReportJob job = new DefaultReportJob((ReportStructureRoot)this.report);
        this.setMetaDataProperties(job);
        String contentType = (String)this.jobProperties.getProperty("content-type");
        try {
            ReportParameters parameters = job.getParameters();
            if (this.masterValues != null && this.detailColumns != null) {
                parameters.put("master-values", (Object)this.masterValues);
                parameters.put("detail-columns", (Object)this.detailColumns);
            }
            Node[] nodes = this.report.getNodeArray();
            FormulaParser parser = new FormulaParser();
            OfficeReport officeReport = (OfficeReport)((Section)nodes[0]).getNode(0);
            Section reportBody = (Section)officeReport.getBodySection();
            ArrayList<Object[]> sortExpressions = new ArrayList<Object[]>();
            this.collectSortExpressions(reportBody.getNodeArray(), sortExpressions, parser, officeReport.getExpressions());
            parameters.put("sort-expressions", sortExpressions);
            ArrayList<Object[]> groupExpressions = new ArrayList<Object[]>();
            this.collectGroupExpressions(reportBody.getNodeArray(), groupExpressions, parser, officeReport.getExpressions());
            parameters.put("group-expressions", groupExpressions);
            String command = (String)officeReport.getAttribute("http://openoffice.org/2005/report", "command");
            String commandType = (String)officeReport.getAttribute("http://openoffice.org/2005/report", "command-type");
            String escapeProcessing = (String)officeReport.getAttribute("http://openoffice.org/2005/report", "escape-processing");
            this.report.setQuery(command);
            parameters.put("command-type", (Object)commandType);
            parameters.put("escape-processing", (Object)(!"false".equals(escapeProcessing) ? 1 : 0));
            String filter = (String)officeReport.getAttribute("http://openoffice.org/2005/report", "filter");
            parameters.put("Filter", (Object)filter);
            parameters.put("MaxRows", this.report.getJobProperties().getProperty("MaxRows"));
            long startTime = System.currentTimeMillis();
            ReportProcessor rp = this.getProcessorForContentType(contentType);
            rp.processReport((org.jfree.report.flow.ReportJob)job);
            job.close();
            long endTime = System.currentTimeMillis();
            LOGGER.config("Report processing time: " + (endTime - startTime));
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null || message.length() == 0) {
                message = "Failed to process the report";
            }
            throw new ReportExecutionException(message, e);
        }
    }

    private ReportProcessor getProcessorForContentType(String mimeType) throws ReportExecutionException {
        Object ret;
        if ("application/vnd.oasis.opendocument.spreadsheet".equals(mimeType)) {
            ret = new SpreadsheetRawReportProcessor(this.inputRepository, this.outputRepository, this.outputName, this.imageService, this.dataSourceFactory);
        } else if ("application/vnd.oasis.opendocument.text".equals(mimeType)) {
            ret = new TextRawReportProcessor(this.inputRepository, this.outputRepository, this.outputName, this.imageService, this.dataSourceFactory);
        } else if ("application/vnd.oasis.opendocument.chart".equals(mimeType)) {
            ret = new ChartRawReportProcessor(this.inputRepository, this.outputRepository, this.outputName, this.imageService, this.dataSourceFactory);
        } else if ("raw/text+xml".equals(mimeType)) {
            ret = new XmlPrintReportProcessor((OutputStream)System.out, "ISO-8859-1");
        } else {
            throw new ReportExecutionException("Invalid mime-type");
        }
        return ret;
    }
}

