/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.provider.javascript;

import com.sun.star.document.XScriptInvocationContext;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.reflection.InvocationTargetException;
import com.sun.star.script.framework.container.ScriptMetaData;
import com.sun.star.script.framework.log.LogUtils;
import com.sun.star.script.framework.provider.ClassLoaderFactory;
import com.sun.star.script.framework.provider.ScriptContext;
import com.sun.star.script.framework.provider.javascript.ScriptEditorForJavaScript;
import com.sun.star.script.provider.ScriptExceptionRaisedException;
import com.sun.star.script.provider.ScriptFrameworkErrorException;
import com.sun.star.script.provider.XScript;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.XComponentContext;
import java.net.MalformedURLException;
import java.net.URL;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;

class ScriptImpl
implements XScript {
    private final ScriptMetaData metaData;
    private final XComponentContext m_xContext;
    private XMultiComponentFactory m_xMultiComponentFactory;
    private final XModel m_xModel;
    private final XScriptInvocationContext m_xInvocContext;

    ScriptImpl(XComponentContext ctx, ScriptMetaData metaData, XModel xModel, XScriptInvocationContext xInvocContext) throws RuntimeException {
        this.metaData = metaData;
        this.m_xContext = ctx;
        this.m_xModel = xModel;
        this.m_xInvocContext = xInvocContext;
        try {
            this.m_xMultiComponentFactory = this.m_xContext.getServiceManager();
        }
        catch (Exception e) {
            throw new RuntimeException((Throwable)e);
        }
        LogUtils.DEBUG((String)("ScriptImpl [javascript] script data = " + metaData));
    }

    public Object invoke(Object[] params, short[][] aOutParamIndex, Object[][] aOutParam) throws ScriptFrameworkErrorException, InvocationTargetException {
        aOutParamIndex[0] = new short[0];
        aOutParam[0] = new Object[0];
        ClassLoader cl = null;
        try {
            cl = ClassLoaderFactory.getURLClassLoader((ScriptMetaData)this.metaData);
            this.metaData.getSourceURL();
        }
        catch (MalformedURLException mfu) {
            throw new ScriptFrameworkErrorException(mfu.getMessage(), null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 3);
        }
        Context ctxt = null;
        try {
            String source;
            Object result = null;
            ScriptEditorForJavaScript editor = ScriptEditorForJavaScript.getEditor(this.metaData.getSourceURL());
            if (editor != null && (result = editor.execute()) != null && result.getClass().getName().equals("org.mozilla.javascript.Undefined")) {
                String string = Context.toString((Object)result);
                return string;
            }
            if (editor != null && editor.isModified()) {
                LogUtils.DEBUG((String)"GOT A MODIFIED SOURCE");
                source = editor.getText();
            } else {
                this.metaData.loadSource();
                source = this.metaData.getSource();
            }
            if (source == null || source.length() == 0) {
                throw new ScriptFrameworkErrorException("Failed to read source data for script", null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 0);
            }
            if (cl != null) {
                Thread.currentThread().setContextClassLoader(cl);
            }
            ctxt = Context.enter();
            ImporterTopLevel scope = new ImporterTopLevel(ctxt);
            Scriptable jsCtxt = Context.toObject((Object)ScriptContext.createContext((XModel)this.m_xModel, (XScriptInvocationContext)this.m_xInvocContext, (XComponentContext)this.m_xContext, (XMultiComponentFactory)this.m_xMultiComponentFactory), (Scriptable)scope);
            scope.put("XSCRIPTCONTEXT", (Scriptable)scope, (Object)jsCtxt);
            Scriptable jsArgs = Context.toObject((Object)params, (Scriptable)scope);
            scope.put("ARGUMENTS", (Scriptable)scope, (Object)jsArgs);
            result = ctxt.evaluateString((Scriptable)scope, source, "<stdin>", 1, null);
            Object object = result = Context.toString((Object)result);
            return object;
        }
        catch (JavaScriptException jse) {
            LogUtils.DEBUG((String)("Caught JavaScriptException exception for JavaScript type = " + ((Object)((Object)jse)).getClass()));
            String message = jse.getMessage();
            Object wrap = jse.getValue();
            LogUtils.DEBUG((String)("\t message  " + message));
            LogUtils.DEBUG((String)("\t wrapped type " + wrap.getClass()));
            LogUtils.DEBUG((String)("\t wrapped toString  " + wrap.toString()));
            ScriptExceptionRaisedException se = new ScriptExceptionRaisedException(message);
            se.lineNum = -1;
            se.language = "JavaScript";
            se.scriptName = this.metaData.getLanguageName();
            se.exceptionType = wrap.getClass().getName();
            se.language = this.metaData.getLanguage();
            LogUtils.DEBUG((String)"ExceptionRaised exception  ");
            LogUtils.DEBUG((String)("\t message  " + se.getMessage()));
            LogUtils.DEBUG((String)("\t lineNum  " + se.lineNum));
            LogUtils.DEBUG((String)("\t language  " + se.language));
            LogUtils.DEBUG((String)("\t scriptName  " + se.scriptName));
            this.raiseEditor(se.lineNum);
            throw new InvocationTargetException("JavaScript uncaught exception" + this.metaData.getLanguageName(), null, (Object)se);
        }
        catch (Exception ex) {
            LogUtils.DEBUG((String)("Caught Exception " + ex));
            LogUtils.DEBUG((String)"rethrowing as ScriptFramework error");
            throw new ScriptFrameworkErrorException(ex.getMessage(), null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 0);
        }
        finally {
            if (ctxt != null) {
                Context.exit();
            }
        }
    }

    private void raiseEditor(int lineNum) {
        try {
            URL sourceUrl = this.metaData.getSourceURL();
            ScriptEditorForJavaScript editor = ScriptEditorForJavaScript.getEditor(sourceUrl);
            if (editor == null) {
                editor = ScriptEditorForJavaScript.getEditor();
                editor.edit(ScriptContext.createContext((XModel)this.m_xModel, (XScriptInvocationContext)this.m_xInvocContext, (XComponentContext)this.m_xContext, (XMultiComponentFactory)this.m_xMultiComponentFactory), this.metaData);
                editor = ScriptEditorForJavaScript.getEditor(sourceUrl);
            }
            if (editor != null) {
                System.out.println("** Have raised IDE for JavaScript, calling indicateErrorLine for line " + lineNum);
                editor.indicateErrorLine(lineNum);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }
}

