/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.output.text;

import org.jfree.report.ReportProcessingException;
import org.jfree.report.data.ReportContextImpl;
import org.jfree.report.flow.ReportContext;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.flow.ReportStructureRoot;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.SinglePassReportProcessor;
import org.libreoffice.report.DataSourceFactory;
import org.libreoffice.report.ImageService;
import org.libreoffice.report.InputRepository;
import org.libreoffice.report.OutputRepository;
import org.libreoffice.report.pentaho.PentahoFormulaContext;
import org.libreoffice.report.pentaho.output.text.TextRawReportTarget;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class TextRawReportProcessor
extends SinglePassReportProcessor {
    private final OutputRepository outputRepository;
    private final String targetName;
    private final InputRepository inputRepository;
    private final ImageService imageService;
    private final DataSourceFactory dataSourceFactory;

    public TextRawReportProcessor(InputRepository inputRepository, OutputRepository outputRepository, String targetName, ImageService imageService, DataSourceFactory dataSourceFactory) {
        if (inputRepository == null) {
            throw new NullPointerException();
        }
        if (outputRepository == null) {
            throw new NullPointerException();
        }
        if (targetName == null) {
            throw new NullPointerException();
        }
        if (imageService == null) {
            throw new NullPointerException();
        }
        if (dataSourceFactory == null) {
            throw new NullPointerException();
        }
        this.targetName = targetName;
        this.inputRepository = inputRepository;
        this.outputRepository = outputRepository;
        this.imageService = imageService;
        this.dataSourceFactory = dataSourceFactory;
    }

    protected ReportTarget createReportTarget(ReportJob job) throws ReportProcessingException {
        ReportStructureRoot report = job.getReportStructureRoot();
        ResourceManager resourceManager = report.getResourceManager();
        return new TextRawReportTarget(job, resourceManager, report.getBaseResource(), this.inputRepository, this.outputRepository, this.targetName, this.imageService, this.dataSourceFactory);
    }

    protected ReportContext createReportContext(ReportJob job, ReportTarget target) {
        ReportContext context = super.createReportContext(job, target);
        if (context instanceof ReportContextImpl) {
            ReportContextImpl impl = (ReportContextImpl)context;
            impl.setFormulaContext((FormulaContext)new PentahoFormulaContext(impl.getFormulaContext(), (Configuration)job.getConfiguration()));
        }
        return context;
    }
}

