/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.output.text;

import java.util.HashMap;
import java.util.Map;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Node;
import org.jfree.report.structure.Section;
import org.jfree.report.util.AttributeNameGenerator;
import org.libreoffice.report.pentaho.model.OfficeMasterPage;
import org.libreoffice.report.pentaho.model.OfficeMasterStyles;
import org.libreoffice.report.pentaho.model.OfficeStyles;
import org.libreoffice.report.pentaho.model.PageLayout;
import org.libreoffice.report.pentaho.model.RawText;

public class MasterPageFactory {
    private static final String DEFAULT_PAGE_NAME = "Default";
    private final OfficeMasterStyles predefinedStyles;
    private final AttributeNameGenerator masterPageNameGenerator;
    private final Map<MasterPageFactoryKey, OfficeMasterPage> masterPages;
    private final AttributeNameGenerator pageLayoutNameGenerator;
    private final Map<PageLayoutKey, String> pageLayouts;

    public MasterPageFactory(OfficeMasterStyles predefinedStyles) {
        this.predefinedStyles = predefinedStyles;
        this.masterPages = new HashMap<MasterPageFactoryKey, OfficeMasterPage>();
        this.masterPageNameGenerator = new AttributeNameGenerator();
        this.pageLayouts = new HashMap<PageLayoutKey, String>();
        this.pageLayoutNameGenerator = new AttributeNameGenerator();
    }

    public OfficeMasterPage getMasterPage(String template, String pageHeader, String pageFooter) {
        MasterPageFactoryKey key = new MasterPageFactoryKey(template, pageHeader, pageFooter);
        return this.masterPages.get(key);
    }

    public boolean containsMasterPage(String template, String pageHeader, String pageFooter) {
        MasterPageFactoryKey key = new MasterPageFactoryKey(template, pageHeader, pageFooter);
        return this.masterPages.containsKey(key);
    }

    public OfficeMasterPage createMasterPage(String template, String pageHeader, String pageFooter) {
        MasterPageFactoryKey key = new MasterPageFactoryKey(template, pageHeader, pageFooter);
        OfficeMasterPage cached = this.masterPages.get(key);
        if (cached != null) {
            return cached;
        }
        String targetName = this.masterPages.isEmpty() ? "Standard" : template;
        OfficeMasterPage predef = this.predefinedStyles.getMasterPage(template);
        if (predef == null) {
            predef = this.predefinedStyles.getMasterPage(DEFAULT_PAGE_NAME);
        }
        if (predef != null) {
            try {
                OfficeMasterPage derived = (OfficeMasterPage)((Object)predef.clone());
                return this.setupMasterPage(derived, targetName, pageHeader, pageFooter, key);
            }
            catch (CloneNotSupportedException cne) {
                throw new IllegalStateException("Implementation error: unable to derive page", cne);
            }
        }
        OfficeMasterPage masterPage = new OfficeMasterPage();
        masterPage.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
        masterPage.setType("master-page");
        return this.setupMasterPage(masterPage, targetName, pageHeader, pageFooter, key);
    }

    private OfficeMasterPage setupMasterPage(OfficeMasterPage derived, String targetName, String pageHeader, String pageFooter, MasterPageFactoryKey key) {
        derived.setStyleName(this.masterPageNameGenerator.generateName(targetName));
        this.masterPages.put(key, derived);
        if (pageHeader != null) {
            Section header = new Section();
            header.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
            header.setType("header");
            header.addNode((Node)new RawText(pageHeader));
            derived.addNode((Node)header);
        }
        if (pageFooter != null) {
            Section footer = new Section();
            footer.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
            footer.setType("footer");
            footer.addNode((Node)new RawText(pageFooter));
            derived.addNode((Node)footer);
        }
        return derived;
    }

    public String createPageStyle(OfficeStyles commonStyles, CSSNumericValue headerHeight, CSSNumericValue footerHeight) {
        PageLayoutKey key = new PageLayoutKey(null, headerHeight, footerHeight);
        PageLayout derived = new PageLayout();
        String name = this.pageLayoutNameGenerator.generateName("autogenerated");
        derived.setStyleName(name);
        commonStyles.addPageStyle(derived);
        if (headerHeight != null) {
            Section headerStyle = new Section();
            headerStyle.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
            headerStyle.setType("header-style");
            derived.addNode((Node)headerStyle);
            MasterPageFactory.applyHeaderFooterHeight(headerStyle, headerHeight);
        }
        if (footerHeight != null) {
            Section footerStyle = new Section();
            footerStyle.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
            footerStyle.setType("footer-style");
            derived.addNode((Node)footerStyle);
            MasterPageFactory.applyHeaderFooterHeight(footerStyle, footerHeight);
        }
        this.pageLayouts.put(key, name);
        return name;
    }

    public String derivePageStyle(String pageStyleTemplate, OfficeStyles predefined, OfficeStyles commonStyles, CSSNumericValue headerHeight, CSSNumericValue footerHeight) throws ReportProcessingException {
        if (pageStyleTemplate == null) {
            throw new NullPointerException("A style-name must be given");
        }
        PageLayoutKey key = new PageLayoutKey(pageStyleTemplate, headerHeight, footerHeight);
        String pageLayoutName = this.pageLayouts.get(key);
        if (pageLayoutName != null) {
            return pageLayoutName;
        }
        PageLayout original = predefined.getPageStyle(pageStyleTemplate);
        if (original == null) {
            throw new ReportProcessingException("Invalid page-layout '" + pageStyleTemplate + "', will not continue.");
        }
        try {
            PageLayout derived = (PageLayout)((Object)original.clone());
            String name = this.pageLayoutNameGenerator.generateName(pageStyleTemplate);
            derived.setStyleName(name);
            commonStyles.addPageStyle(derived);
            if (headerHeight != null) {
                Section headerStyle = derived.getHeaderStyle();
                if (headerStyle == null) {
                    headerStyle = new Section();
                    headerStyle.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
                    headerStyle.setType("header-style");
                    derived.addNode((Node)headerStyle);
                }
                MasterPageFactory.applyHeaderFooterHeight(headerStyle, headerHeight);
            }
            if (footerHeight != null) {
                Section footerStyle = derived.getFooterStyle();
                if (footerStyle == null) {
                    footerStyle = new Section();
                    footerStyle.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
                    footerStyle.setType("footer-style");
                    derived.addNode((Node)footerStyle);
                }
                MasterPageFactory.applyHeaderFooterHeight(footerStyle, footerHeight);
            }
            this.pageLayouts.put(key, name);
            return name;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Clone failed.", e);
        }
    }

    private static void applyHeaderFooterHeight(Section headerFooterStyle, CSSNumericValue style) {
        Element headerFooterProps = headerFooterStyle.findFirstChild("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "header-footer-properties");
        if (headerFooterProps == null) {
            headerFooterProps = new Section();
            headerFooterProps.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
            headerFooterProps.setType("header-footer-properties");
            headerFooterStyle.addNode((Node)headerFooterProps);
        }
        headerFooterProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "height", (Object)(style.getValue() + style.getType().getType()));
    }

    private static class PageLayoutKey {
        private final String templateName;
        private final CSSNumericValue headerHeight;
        private final CSSNumericValue footerHeight;

        public PageLayoutKey(String templateName, CSSNumericValue headerHeight, CSSNumericValue footerHeight) {
            this.templateName = templateName;
            this.headerHeight = headerHeight;
            this.footerHeight = footerHeight;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PageLayoutKey key = (PageLayoutKey)o;
            if (this.footerHeight != null ? !this.footerHeight.equals(key.footerHeight) : key.footerHeight != null) {
                return false;
            }
            if (this.headerHeight != null ? !this.headerHeight.equals(key.headerHeight) : key.headerHeight != null) {
                return false;
            }
            return !(this.templateName == null ? key.templateName != null : !this.templateName.equals(key.templateName));
        }

        public int hashCode() {
            int result = this.templateName != null ? this.templateName.hashCode() : 0;
            result = 31 * result + (this.headerHeight != null ? this.headerHeight.hashCode() : 0);
            result = 31 * result + (this.footerHeight != null ? this.footerHeight.hashCode() : 0);
            return result;
        }
    }

    private static class MasterPageFactoryKey {
        private final String template;
        private final String pageHeader;
        private final String pageFooter;

        public MasterPageFactoryKey(String template, String pageHeader, String pageFooter) {
            this.template = template;
            this.pageHeader = pageHeader;
            this.pageFooter = pageFooter;
        }

        public boolean equals(Object o) {
            if (this != o) {
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                MasterPageFactoryKey that = (MasterPageFactoryKey)o;
                if (this.pageFooter != null ? !this.pageFooter.equals(that.pageFooter) : that.pageFooter != null) {
                    return false;
                }
                if (this.pageHeader != null ? !this.pageHeader.equals(that.pageHeader) : that.pageHeader != null) {
                    return false;
                }
                if (this.template != null ? !this.template.equals(that.template) : that.template != null) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            int result = this.template != null ? this.template.hashCode() : 0;
            result = 31 * result + (this.pageHeader != null ? this.pageHeader.hashCode() : 0);
            result = 31 * result + (this.pageFooter != null ? this.pageFooter.hashCode() : 0);
            return result;
        }
    }
}

