/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.output;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Section;
import org.jfree.report.util.AttributeNameGenerator;
import org.libreoffice.report.pentaho.model.DataStyle;
import org.libreoffice.report.pentaho.model.FontFaceDeclsSection;
import org.libreoffice.report.pentaho.model.FontFaceElement;
import org.libreoffice.report.pentaho.model.OfficeStyle;
import org.libreoffice.report.pentaho.model.OfficeStyles;
import org.libreoffice.report.pentaho.model.OfficeStylesCollection;

public class StyleUtilities {
    private static final Logger LOGGER = Logger.getLogger(StyleUtilities.class.getName());
    private static final String STYLE = "style";

    private StyleUtilities() {
    }

    public static void copyStyle(String styleFamily, String styleName, OfficeStylesCollection stylesCollection, OfficeStylesCollection commonCollection, OfficeStylesCollection predefCollection) throws ReportProcessingException {
        StyleUtilities.copyStyle(styleFamily, styleName, stylesCollection, commonCollection, predefCollection, new HashSet<String>());
    }

    private static void copyStyle(String styleFamily, String styleName, OfficeStylesCollection stylesCollection, OfficeStylesCollection commonCollection, OfficeStylesCollection predefCollection, Set<String> inheritanceTracker) throws ReportProcessingException {
        if (inheritanceTracker.contains(styleName)) {
            return;
        }
        inheritanceTracker.add(styleName);
        if (stylesCollection.containsStyle(styleFamily, styleName) || commonCollection.getCommonStyles().containsStyle(styleFamily, styleName)) {
            return;
        }
        OfficeStyle predefCommonStyle = predefCollection.getCommonStyles().getStyle(styleFamily, styleName);
        if (predefCommonStyle != null) {
            OfficeStyles commonStyles = commonCollection.getCommonStyles();
            StyleUtilities.copyStyleInternal(predefCommonStyle, commonStyles, stylesCollection, commonCollection, predefCollection, styleFamily, inheritanceTracker);
            return;
        }
        OfficeStyle predefAutoStyle = predefCollection.getAutomaticStyles().getStyle(styleFamily, styleName);
        if (predefAutoStyle != null) {
            OfficeStyles autoStyles = stylesCollection.getAutomaticStyles();
            StyleUtilities.copyStyleInternal(predefAutoStyle, autoStyles, stylesCollection, commonCollection, predefCollection, styleFamily, inheritanceTracker);
            return;
        }
        OfficeStyle autostyle = new OfficeStyle();
        autostyle.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
        autostyle.setType(STYLE);
        autostyle.setStyleFamily(styleFamily);
        autostyle.setStyleName(styleName);
        OfficeStyles autoStyles = stylesCollection.getAutomaticStyles();
        autoStyles.addStyle(autostyle);
    }

    private static OfficeStyle copyStyleInternal(OfficeStyle predefCommonStyle, OfficeStyles styles, OfficeStylesCollection stylesCollection, OfficeStylesCollection commonCollection, OfficeStylesCollection predefCollection, String styleFamily, Set<String> inheritanceTracker) throws ReportProcessingException {
        try {
            OfficeStyle preStyle = (OfficeStyle)((Object)predefCommonStyle.clone());
            styles.addStyle(preStyle);
            StyleUtilities.performFontFaceProcessing(preStyle, stylesCollection, predefCollection);
            StyleUtilities.performDataStyleProcessing(preStyle, stylesCollection, predefCollection);
            String styleParent = preStyle.getStyleParent();
            OfficeStyle inherited = stylesCollection.getStyle(styleFamily, styleParent);
            if (inherited != null) {
                StyleUtilities.copyStyle(styleFamily, styleParent, stylesCollection, commonCollection, predefCollection, inheritanceTracker);
            } else if (styleParent != null) {
                LOGGER.warning("Inconsistent styles: " + styleFamily + ":" + styleParent + " does not exist.");
            }
            return preStyle;
        }
        catch (CloneNotSupportedException e) {
            throw new ReportProcessingException("Failed to derive a stylesheet", (Exception)e);
        }
    }

    private static void performFontFaceProcessing(OfficeStyle style, OfficeStylesCollection stylesCollection, OfficeStylesCollection predefCollection) throws ReportProcessingException {
        Element textProperties = style.getTextProperties();
        if (textProperties == null) {
            return;
        }
        try {
            FontFaceElement element;
            String fontNameComplex;
            FontFaceElement element2;
            String fontNameAsian;
            FontFaceElement element3;
            FontFaceDeclsSection currentFonts = stylesCollection.getFontFaceDecls();
            FontFaceDeclsSection predefFonts = predefCollection.getFontFaceDecls();
            String fontName = (String)textProperties.getAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "font-name");
            if (fontName != null && !currentFonts.containsFont(fontName) && (element3 = predefFonts.getFontFace(fontName)) != null) {
                currentFonts.addFontFace((FontFaceElement)((Object)element3.clone()));
            }
            if ((fontNameAsian = (String)textProperties.getAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "font-name-asian")) != null && !currentFonts.containsFont(fontNameAsian) && (element2 = predefFonts.getFontFace(fontNameAsian)) != null) {
                currentFonts.addFontFace((FontFaceElement)((Object)element2.clone()));
            }
            if ((fontNameComplex = (String)textProperties.getAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "font-name-complex")) != null && !currentFonts.containsFont(fontNameComplex) && (element = predefFonts.getFontFace(fontNameComplex)) != null) {
                currentFonts.addFontFace((FontFaceElement)((Object)element.clone()));
            }
        }
        catch (CloneNotSupportedException e) {
            throw new ReportProcessingException("Failed to clone font-face element", (Exception)e);
        }
    }

    private static void performDataStyleProcessing(OfficeStyle style, OfficeStylesCollection stylesCollection, OfficeStylesCollection predefCollection) throws ReportProcessingException {
        Section derivedStyle = StyleUtilities.performDataStyleProcessing(style, stylesCollection, predefCollection, "data-style-name");
        if (derivedStyle != null) {
            try {
                Section styleMap = (Section)derivedStyle.findFirstChild("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "map");
                if (styleMap != null) {
                    StyleUtilities.performDataStyleProcessing(styleMap, stylesCollection, predefCollection, "apply-style-name");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static Section performDataStyleProcessing(Section style, OfficeStylesCollection stylesCollection, OfficeStylesCollection predefCollection, String attributeName) throws ReportProcessingException {
        DataStyle derivedStyle;
        Object attribute = style.getAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", attributeName);
        if (attribute != null) {
            String styleName = String.valueOf(attribute);
            if (!stylesCollection.getAutomaticStyles().containsDataStyle(styleName) && !stylesCollection.getCommonStyles().containsDataStyle(styleName)) {
                try {
                    OfficeStyles automaticStyles = predefCollection.getAutomaticStyles();
                    DataStyle autoDataStyle = automaticStyles.getDataStyle(styleName);
                    if (autoDataStyle != null) {
                        derivedStyle = (DataStyle)((Object)autoDataStyle.clone());
                        stylesCollection.getAutomaticStyles().addDataStyle(derivedStyle);
                    }
                    OfficeStyles commonStyles = predefCollection.getCommonStyles();
                    DataStyle commonDataStyle = commonStyles.getDataStyle(styleName);
                    if (commonDataStyle != null) {
                        derivedStyle = (DataStyle)((Object)commonDataStyle.clone());
                        stylesCollection.getCommonStyles().addDataStyle(derivedStyle);
                    }
                    LOGGER.warning("Dangling data style: " + styleName);
                    derivedStyle = null;
                }
                catch (CloneNotSupportedException e) {
                    throw new ReportProcessingException("Failed to copy style. This should not have happened.", (Exception)e);
                }
            } else {
                derivedStyle = null;
            }
        } else {
            derivedStyle = null;
        }
        return derivedStyle;
    }

    public static OfficeStyle deriveStyle(String styleFamily, String styleName, OfficeStylesCollection stylesCollection, OfficeStylesCollection commonCollection, OfficeStylesCollection predefCollection, AttributeNameGenerator generator) throws ReportProcessingException {
        if (styleFamily == null) {
            throw new NullPointerException("StyleFamily must not be null");
        }
        if (styleName != null) {
            OfficeStyle currentAuto = stylesCollection.getAutomaticStyles().getStyle(styleFamily, styleName);
            if (currentAuto != null) {
                OfficeStyle derivedStyle = StyleUtilities.deriveAutomaticStyle(currentAuto, styleFamily, styleName, generator, commonCollection, predefCollection);
                stylesCollection.getAutomaticStyles().addStyle(derivedStyle);
                return derivedStyle;
            }
            OfficeStyle currentCommon = stylesCollection.getCommonStyles().getStyle(styleFamily, styleName);
            if (currentCommon != null) {
                OfficeStyle derivedStyle = StyleUtilities.deriveCommonStyle(currentCommon, styleFamily, styleName, generator, commonCollection, predefCollection);
                stylesCollection.getAutomaticStyles().addStyle(derivedStyle);
                return derivedStyle;
            }
            OfficeStyle commonCommon = commonCollection.getCommonStyles().getStyle(styleFamily, styleName);
            if (commonCommon != null) {
                OfficeStyle derivedStyle = StyleUtilities.deriveCommonStyle(commonCommon, styleFamily, styleName, generator, commonCollection, predefCollection);
                stylesCollection.getAutomaticStyles().addStyle(derivedStyle);
                return derivedStyle;
            }
            OfficeStyle predefAuto = predefCollection.getAutomaticStyles().getStyle(styleFamily, styleName);
            if (predefAuto != null) {
                OfficeStyle derivedStyle = StyleUtilities.deriveAutomaticStyle(predefAuto, styleFamily, styleName, generator, commonCollection, predefCollection);
                stylesCollection.getAutomaticStyles().addStyle(derivedStyle);
                return derivedStyle;
            }
            OfficeStyle predefCommon = predefCollection.getCommonStyles().getStyle(styleFamily, styleName);
            if (predefCommon != null) {
                OfficeStyle derivedStyle = StyleUtilities.deriveCommonStyle(predefCommon, styleFamily, styleName, generator, commonCollection, predefCollection);
                stylesCollection.getAutomaticStyles().addStyle(derivedStyle);
                return derivedStyle;
            }
        }
        OfficeStyle autostyle = new OfficeStyle();
        autostyle.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
        autostyle.setType(STYLE);
        autostyle.setStyleFamily(styleFamily);
        if (styleName != null) {
            autostyle.setStyleName(styleName);
        } else {
            autostyle.setStyleName(generator.generateName("derived_anonymous"));
        }
        OfficeStyles autoStyles = stylesCollection.getAutomaticStyles();
        autoStyles.addStyle(autostyle);
        return autostyle;
    }

    private static OfficeStyle deriveCommonStyle(OfficeStyle commonStyle, String styleFamily, String styleName, AttributeNameGenerator nameGenerator, OfficeStylesCollection commonCollection, OfficeStylesCollection predefCollection) throws ReportProcessingException {
        OfficeStyle autostyle = new OfficeStyle();
        autostyle.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
        autostyle.setType(STYLE);
        autostyle.setStyleFamily(styleFamily);
        autostyle.setStyleName(nameGenerator.generateName("derived_" + styleName));
        autostyle.setStyleParent(styleName);
        OfficeStyles commonStyles = commonCollection.getCommonStyles();
        if (!commonStyles.containsStyle(styleFamily, styleName)) {
            StyleUtilities.copyStyleInternal(commonStyle, commonStyles, commonCollection, commonCollection, predefCollection, styleFamily, new HashSet<String>());
        }
        return autostyle;
    }

    private static OfficeStyle deriveAutomaticStyle(OfficeStyle commonStyle, String styleFamily, String styleName, AttributeNameGenerator nameGenerator, OfficeStylesCollection commonCollection, OfficeStylesCollection predefCollection) throws ReportProcessingException {
        try {
            OfficeStyle autostyle = (OfficeStyle)((Object)commonStyle.clone());
            autostyle.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
            autostyle.setType(STYLE);
            autostyle.setStyleFamily(styleFamily);
            autostyle.setStyleName(nameGenerator.generateName("derived_auto_" + styleName));
            String parent = autostyle.getStyleParent();
            if (parent != null) {
                StyleUtilities.copyStyle(styleFamily, parent, commonCollection, commonCollection, predefCollection);
            }
            return autostyle;
        }
        catch (CloneNotSupportedException e) {
            throw new ReportProcessingException("Deriving the style failed. Clone error: ", (Exception)e);
        }
    }

    public static String queryStyle(OfficeStylesCollection predefCollection, String styleFamily, String styleName, String sectionName, String propertyNamespace, String propertyName) {
        return StyleUtilities.queryStyle(predefCollection, styleFamily, styleName, sectionName, propertyNamespace, propertyName, new HashSet<String>());
    }

    public static OfficeStyle queryStyleByProperties(OfficeStylesCollection predefCollection, String styleFamily, String sectionName, ArrayList<?> propertyNamespace, ArrayList<?> propertyName, ArrayList<?> propertyValues) {
        if (propertyNamespace.size() != propertyName.size()) {
            return null;
        }
        OfficeStyle[] styles = predefCollection.getAutomaticStyles().getAllStyles();
        for (int i = 0; i < styles.length; ++i) {
            int j;
            Element section;
            OfficeStyle officeStyle = styles[i];
            if (!officeStyle.getStyleFamily().equals(styleFamily) || (section = officeStyle.findFirstChild("urn:oasis:names:tc:opendocument:xmlns:style:1.0", sectionName)) == null) continue;
            for (j = 0; j < propertyNamespace.size(); ++j) {
                String ns = (String)propertyNamespace.get(j);
                String prop = (String)propertyName.get(j);
                Object obj = section.getAttribute(ns, prop);
                Object value = propertyValues.get(j);
                if (obj != null && value != null && !propertyValues.get(j).equals(obj)) break;
            }
            if (j != propertyName.size()) continue;
            return officeStyle;
        }
        return null;
    }

    private static String queryStyle(OfficeStylesCollection predefCollection, String styleFamily, String styleName, String sectionName, String propertyNamespace, String propertyName, Set<String> seenStyles) {
        Object attribute;
        if (seenStyles.contains(styleName)) {
            return null;
        }
        seenStyles.add(styleName);
        OfficeStyle style = predefCollection.getStyle(styleFamily, styleName);
        if (style == null) {
            return null;
        }
        Element section = style.findFirstChild("urn:oasis:names:tc:opendocument:xmlns:style:1.0", sectionName);
        if (section != null && (attribute = section.getAttribute(propertyNamespace, propertyName)) != null) {
            return String.valueOf(attribute);
        }
        String parent = style.getStyleParent();
        if (parent == null) {
            return null;
        }
        return StyleUtilities.queryStyle(predefCollection, styleFamily, parent, sectionName, propertyNamespace, propertyName, seenStyles);
    }
}

