/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho;

import com.sun.star.beans.NamedValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertyChangeListener;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.beans.XVetoableChangeListener;
import com.sun.star.container.XChild;
import com.sun.star.embed.XStorage;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XSingleComponentFactory;
import com.sun.star.lib.uno.helper.Factory;
import com.sun.star.lib.uno.helper.PropertySetMixin;
import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.registry.InvalidRegistryException;
import com.sun.star.registry.InvalidValueException;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.registry.XSimpleRegistry;
import com.sun.star.report.XReportDefinition;
import com.sun.star.sdb.XDocumentDataSource;
import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbc.XConnection;
import com.sun.star.sdbc.XRowSet;
import com.sun.star.task.XJob;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jfree.report.ReportDataFactoryException;
import org.libreoffice.report.DataSourceException;
import org.libreoffice.report.JobProperties;
import org.libreoffice.report.ReportExecutionException;
import org.libreoffice.report.ReportJob;
import org.libreoffice.report.ReportJobDefinition;
import org.libreoffice.report.ReportJobFactory;
import org.libreoffice.report.SDBCReportDataFactory;
import org.libreoffice.report.SOImageService;
import org.libreoffice.report.StorageRepository;
import org.libreoffice.report.pentaho.PentahoReportEngine;
import org.libreoffice.report.pentaho.SOFormulaParser;
import org.libreoffice.report.pentaho.SOFunctionManager;

public class SOReportJobFactory {
    private SOReportJobFactory() {
    }

    public static XSingleComponentFactory __getComponentFactory(String sImplName) {
        XSingleComponentFactory xFactory = null;
        try {
            if (sImplName.equals(_SOReportJobFactory.class.getName())) {
                xFactory = Factory.createComponentFactory(_SOReportJobFactory.class, (String[])_SOReportJobFactory.getServiceNames());
            } else if (sImplName.equals(SOFunctionManager.class.getName())) {
                xFactory = Factory.createComponentFactory(SOFunctionManager.class, (String[])SOFunctionManager.getServiceNames());
            } else if (sImplName.equals(SOFormulaParser.class.getName())) {
                xFactory = Factory.createComponentFactory(SOFormulaParser.class, (String[])SOFormulaParser.getServiceNames());
            }
        }
        catch (IncompatibleClassChangeError incompatibleClassChangeError) {
            // empty catch block
        }
        return xFactory;
    }

    public static class _SOReportJobFactory
    extends WeakBase
    implements XInitialization,
    XServiceInfo,
    XJob,
    XPropertySet,
    ReportJobFactory {
        private static final Logger LOGGER = Logger.getLogger(_SOReportJobFactory.class.getName());
        private static final String __serviceName = "org.libreoffice.report.pentaho.SOReportJobFactory";
        private final PropertySetMixin m_prophlp;
        private final XComponentContext m_cmpCtx;
        private XConnection activeConnection;
        private XReportDefinition report;

        public _SOReportJobFactory(XComponentContext xCompContext) {
            this.m_cmpCtx = xCompContext;
            this.m_prophlp = new PropertySetMixin(this.m_cmpCtx, (XInterface)this, new Type(XJob.class), null);
        }

        public void initialize(Object[] object) throws com.sun.star.uno.Exception {
        }

        public String[] getSupportedServiceNames() {
            return _SOReportJobFactory.getServiceNames();
        }

        private static String[] getServiceNames() {
            return new String[]{__serviceName};
        }

        public boolean supportsService(String sServiceName) {
            return sServiceName.equals(__serviceName);
        }

        public String getImplementationName() {
            return SOReportJobFactory.class.getName();
        }

        private String getLocaleFromRegistry(XSimpleRegistry simpleReg, String path, String value) {
            String currentLocale = null;
            try {
                String newLocale;
                simpleReg.open(path, true, false);
                XRegistryKey xRegistryRootKey = simpleReg.getRootKey();
                XRegistryKey locale = xRegistryRootKey.openKey(value);
                if (locale != null && (newLocale = locale.getStringValue()) != null) {
                    currentLocale = newLocale.replace('-', '_');
                }
            }
            catch (InvalidValueException ex) {
                Logger.getLogger(SOReportJobFactory.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InvalidRegistryException ex) {
                Logger.getLogger(SOReportJobFactory.class.getName()).log(Level.SEVERE, null, ex);
            }
            return currentLocale;
        }

        public void rethrow_sql_exception(Throwable exception) throws SQLException {
            if (!(exception instanceof ReportDataFactoryException)) {
                return;
            }
            if (!((exception = ((ReportDataFactoryException)exception).getCause()) instanceof DataSourceException)) {
                return;
            }
            if (!((exception = ((DataSourceException)exception).getCause()) instanceof SQLException)) {
                return;
            }
            throw (SQLException)exception;
        }

        public Object execute(NamedValue[] namedValue) throws IllegalArgumentException, com.sun.star.uno.Exception {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                XSimpleRegistry simpleReg = (XSimpleRegistry)UnoRuntime.queryInterface(XSimpleRegistry.class, (Object)this.m_cmpCtx.getServiceManager().createInstanceWithContext("com.sun.star.configuration.ConfigurationRegistry", this.m_cmpCtx));
                String currentLocale = this.getLocaleFromRegistry(simpleReg, "org.openoffice.Setup", "L10N/ooSetupSystemLocale");
                if (currentLocale == null || "".equals(currentLocale)) {
                    currentLocale = this.getLocaleFromRegistry(simpleReg, "org.openoffice.Office.Linguistic", "General/DefaultLocale");
                }
                if (currentLocale != null && !"".equals(currentLocale)) {
                    System.setProperty("org.pentaho.reporting.libraries.formula.locale", currentLocale);
                }
                ReportJob job = this.createReportJob(namedValue);
                job.execute();
            }
            catch (Exception e) {
                LOGGER.severe("ReportProcessing failed: " + e);
                StringWriter result = new StringWriter();
                PrintWriter printWriter = new PrintWriter(result);
                e.printStackTrace(printWriter);
                this.rethrow_sql_exception(e.getCause());
                throw new WrappedTargetException((Throwable)e, e.toString() + '\n' + ((Object)result).toString(), (Object)this, null);
            }
            catch (IncompatibleClassChangeError e) {
                LOGGER.severe("Detected an IncompatibleClassChangeError");
                StringWriter result = new StringWriter();
                PrintWriter printWriter = new PrintWriter(result);
                e.printStackTrace(printWriter);
                throw new WrappedTargetException((Throwable)e, e.toString() + '\n' + ((Object)result).toString(), (Object)this, null);
            }
            Thread.currentThread().setContextClassLoader(cl);
            return null;
        }

        @Override
        public ReportJob createReportJob(NamedValue[] namedValue) throws IllegalArgumentException, ReportExecutionException, com.sun.star.uno.Exception {
            XStorage input = null;
            XStorage output = null;
            XRowSet rowSet = null;
            String mimetype = null;
            String author = null;
            String title = null;
            Integer maxRows = null;
            for (int i = 0; i < namedValue.length; ++i) {
                NamedValue aProps = namedValue[i];
                if ("ActiveConnection".equalsIgnoreCase(aProps.Name)) {
                    this.activeConnection = (XConnection)UnoRuntime.queryInterface(XConnection.class, (Object)aProps.Value);
                    continue;
                }
                if ("ReportDefinition".equalsIgnoreCase(aProps.Name)) {
                    this.report = (XReportDefinition)UnoRuntime.queryInterface(XReportDefinition.class, (Object)aProps.Value);
                    continue;
                }
                if ("InputStorage".equalsIgnoreCase(aProps.Name)) {
                    input = (XStorage)UnoRuntime.queryInterface(XStorage.class, (Object)aProps.Value);
                    continue;
                }
                if ("OutputStorage".equalsIgnoreCase(aProps.Name)) {
                    output = (XStorage)UnoRuntime.queryInterface(XStorage.class, (Object)aProps.Value);
                    continue;
                }
                if ("RowSet".equalsIgnoreCase(aProps.Name)) {
                    rowSet = (XRowSet)UnoRuntime.queryInterface(XRowSet.class, (Object)aProps.Value);
                    continue;
                }
                if ("mimetype".equalsIgnoreCase(aProps.Name)) {
                    mimetype = (String)aProps.Value;
                    continue;
                }
                if ("MaxRows".equalsIgnoreCase(aProps.Name)) {
                    maxRows = (Integer)aProps.Value;
                    continue;
                }
                if ("Author".equalsIgnoreCase(aProps.Name)) {
                    author = (String)aProps.Value;
                    continue;
                }
                if (!"Title".equalsIgnoreCase(aProps.Name)) continue;
                title = (String)aProps.Value;
            }
            if (input == null || output == null) {
                throw new IllegalArgumentException();
            }
            if (rowSet == null) {
                if (this.report == null || this.activeConnection == null) {
                    throw new IllegalArgumentException();
                }
                mimetype = this.report.getMimeType();
            } else {
                XPropertySet set = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, rowSet);
                if (set == null) {
                    throw new IllegalArgumentException();
                }
                this.activeConnection = (XConnection)UnoRuntime.queryInterface(XConnection.class, (Object)set.getPropertyValue("ActiveConnection"));
            }
            if (mimetype == null) {
                mimetype = "application/vnd.oasis.opendocument.text";
            }
            XChild child = (XChild)UnoRuntime.queryInterface(XChild.class, (Object)this.activeConnection);
            XDocumentDataSource docSource = (XDocumentDataSource)UnoRuntime.queryInterface(XDocumentDataSource.class, (Object)child.getParent());
            XModel model = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)docSource.getDatabaseDocument());
            SDBCReportDataFactory dataFactory = new SDBCReportDataFactory(this.m_cmpCtx, this.activeConnection);
            StorageRepository storageRepository = new StorageRepository(input, output, model.getURL());
            String inputName = "content.xml";
            String outputName = "content.xml";
            PentahoReportEngine engine = new PentahoReportEngine();
            ReportJobDefinition definition = engine.createJobDefinition();
            JobProperties procParms = definition.getProcessingParameters();
            procParms.setProperty("input.repository", storageRepository);
            procParms.setProperty("output.repository", storageRepository);
            procParms.setProperty("input.name", "content.xml");
            procParms.setProperty("output.name", "content.xml");
            procParms.setProperty("content-type", mimetype);
            procParms.setProperty("input.datasource-factory", dataFactory);
            procParms.setProperty("ImageService", new SOImageService(this.m_cmpCtx));
            procParms.setProperty("input.reportjob-factory", this);
            procParms.setProperty("MaxRows", maxRows);
            if (author != null) {
                procParms.setProperty("Author", author);
            }
            if (title != null) {
                procParms.setProperty("Title", title);
            }
            return engine.createJob(definition);
        }

        public XPropertySetInfo getPropertySetInfo() {
            return this.m_prophlp.getPropertySetInfo();
        }

        public void setPropertyValue(String aPropertyName, Object aValue) throws UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException {
            this.m_prophlp.setPropertyValue(aPropertyName, aValue);
        }

        public Object getPropertyValue(String aPropertyName) throws UnknownPropertyException, WrappedTargetException {
            return this.m_prophlp.getPropertyValue(aPropertyName);
        }

        public void addPropertyChangeListener(String aPropertyName, XPropertyChangeListener xListener) throws UnknownPropertyException, WrappedTargetException {
            this.m_prophlp.addPropertyChangeListener(aPropertyName, xListener);
        }

        public void removePropertyChangeListener(String aPropertyName, XPropertyChangeListener xListener) throws UnknownPropertyException, WrappedTargetException {
            this.m_prophlp.removePropertyChangeListener(aPropertyName, xListener);
        }

        public void addVetoableChangeListener(String aPropertyName, XVetoableChangeListener xListener) throws UnknownPropertyException, WrappedTargetException {
            this.m_prophlp.addVetoableChangeListener(aPropertyName, xListener);
        }

        public void removeVetoableChangeListener(String aPropertyName, XVetoableChangeListener xListener) throws UnknownPropertyException, WrappedTargetException {
            this.m_prophlp.removeVetoableChangeListener(aPropertyName, xListener);
        }
    }
}

