/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.connections.pipe;

import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnectionBroadcaster;
import com.sun.star.io.XStreamListener;
import com.sun.star.lib.util.NativeLibraryLoader;
import com.sun.star.uno.RuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class PipeConnection
implements XConnection,
XConnectionBroadcaster {
    public static final boolean DEBUG = false;
    protected String _aDescription;
    protected long _nPipeHandle;
    protected ArrayList<XStreamListener> _aListeners = new ArrayList();
    protected boolean _bFirstRead = true;

    public PipeConnection(String description) throws IOException {
        String aPipeNameParam;
        StringTokenizer aTokenizer = new StringTokenizer(description, ",");
        if (aTokenizer.hasMoreTokens()) {
            String aConnType = aTokenizer.nextToken();
            if (!aConnType.equals("pipe")) {
                throw new java.lang.RuntimeException("invalid pipe descriptor: does not start with 'pipe,'");
            }
            aPipeNameParam = aTokenizer.nextToken();
            if (!aPipeNameParam.substring(0, 5).equals("name=")) {
                throw new java.lang.RuntimeException("invalid pipe descriptor: no 'name=' parameter found");
            }
        } else {
            throw new java.lang.RuntimeException("invalid or empty pipe descriptor");
        }
        String aPipeName = aPipeNameParam.substring(5);
        try {
            this.createJNI(aPipeName);
        }
        catch (Exception ex1) {
            IOException ex2 = new IOException();
            ex2.initCause(ex1);
            throw ex2;
        }
    }

    @Override
    public void addStreamListener(XStreamListener aListener) throws RuntimeException {
        this._aListeners.add(aListener);
    }

    @Override
    public void removeStreamListener(XStreamListener aListener) throws RuntimeException {
        this._aListeners.remove(aListener);
    }

    private void notifyListeners_open() {
        for (XStreamListener xStreamListener : this._aListeners) {
            xStreamListener.started();
        }
    }

    private void notifyListeners_close() {
        for (XStreamListener xStreamListener : this._aListeners) {
            xStreamListener.closed();
        }
    }

    private void notifyListeners_error(com.sun.star.uno.Exception exception) {
        for (XStreamListener xStreamListener : this._aListeners) {
            xStreamListener.error(exception);
        }
    }

    private native int createJNI(String var1) throws com.sun.star.io.IOException, RuntimeException;

    private native int readJNI(byte[][] var1, int var2) throws com.sun.star.io.IOException, RuntimeException;

    private native void writeJNI(byte[] var1) throws com.sun.star.io.IOException, RuntimeException;

    private native void flushJNI() throws com.sun.star.io.IOException, RuntimeException;

    private native void closeJNI() throws com.sun.star.io.IOException, RuntimeException;

    @Override
    public int read(byte[][] bytes, int nBytesToRead) throws com.sun.star.io.IOException, RuntimeException {
        if (this._bFirstRead) {
            this._bFirstRead = false;
            this.notifyListeners_open();
        }
        return this.readJNI(bytes, nBytesToRead);
    }

    @Override
    public void write(byte[] aData) throws com.sun.star.io.IOException, RuntimeException {
        this.writeJNI(aData);
    }

    @Override
    public void flush() throws com.sun.star.io.IOException, RuntimeException {
        this.flushJNI();
    }

    @Override
    public void close() throws com.sun.star.io.IOException, RuntimeException {
        this.closeJNI();
        this.notifyListeners_close();
    }

    @Override
    public String getDescription() throws RuntimeException {
        return this._aDescription;
    }

    static {
        NativeLibraryLoader.loadLibrary(PipeConnection.class.getClassLoader(), "jpipe");
    }
}

