/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.upload;

import java.util.concurrent.CopyOnWriteArrayList;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.FileStorageService;
import org.dromara.x.file.storage.core.aspect.FileStorageAspect;
import org.dromara.x.file.storage.core.aspect.UploadPartAspectChain;
import org.dromara.x.file.storage.core.exception.Check;
import org.dromara.x.file.storage.core.platform.FileStorage;
import org.dromara.x.file.storage.core.recorder.FileRecorder;
import org.dromara.x.file.storage.core.upload.FilePartInfo;
import org.dromara.x.file.storage.core.upload.UploadPartPretreatment;

public class UploadPartActuator {
    private final FileStorageService fileStorageService;
    private final UploadPartPretreatment pre;

    public UploadPartActuator(UploadPartPretreatment pre) {
        this.pre = pre;
        this.fileStorageService = pre.getFileStorageService();
    }

    public FilePartInfo execute() {
        FileInfo fileInfo = this.pre.getFileInfo();
        Check.uploadPart(fileInfo);
        Object fileStorage = this.fileStorageService.getFileStorageVerify(fileInfo.getPlatform());
        CopyOnWriteArrayList<FileStorageAspect> aspectList = this.fileStorageService.getAspectList();
        FileRecorder fileRecorder = this.fileStorageService.getFileRecorder();
        return new UploadPartAspectChain(aspectList, (_pre, _fileStorage, _fileRecorder) -> {
            FilePartInfo filePartInfo = _fileStorage.uploadPart(_pre);
            filePartInfo.setHashInfo(_pre.getHashCalculatorManager().getHashInfo());
            _fileRecorder.saveFilePart(filePartInfo);
            return filePartInfo;
        }).next(this.pre, (FileStorage)fileStorage, fileRecorder);
    }
}

