/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.upload;

import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import java.util.Date;
import java.util.List;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.FileStorageService;
import org.dromara.x.file.storage.core.UploadPretreatment;
import org.dromara.x.file.storage.core.aspect.FileStorageAspect;
import org.dromara.x.file.storage.core.aspect.UploadAspectChain;
import org.dromara.x.file.storage.core.exception.FileStorageRuntimeException;
import org.dromara.x.file.storage.core.file.FileWrapper;
import org.dromara.x.file.storage.core.platform.FileStorage;
import org.dromara.x.file.storage.core.recorder.FileRecorder;

public class UploadActuator {
    private final FileStorageService fileStorageService;
    private final org.dromara.x.file.storage.core.upload.UploadPretreatment pre;

    @Deprecated
    public UploadActuator(UploadPretreatment pre) {
        this(new org.dromara.x.file.storage.core.upload.UploadPretreatment(pre));
    }

    public UploadActuator(org.dromara.x.file.storage.core.upload.UploadPretreatment pre) {
        this.pre = pre;
        this.fileStorageService = pre.getFileStorageService();
    }

    public FileInfo execute() {
        return this.execute((FileStorage)this.fileStorageService.getFileStorage(this.pre.getPlatform()), this.fileStorageService.getFileRecorder(), (List<FileStorageAspect>)this.fileStorageService.getAspectList());
    }

    public FileInfo execute(FileStorage fileStorage, FileRecorder fileRecorder, List<FileStorageAspect> aspectList) {
        if (fileStorage == null) {
            throw new FileStorageRuntimeException(StrUtil.format((CharSequence)"\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5b58\u50a8\u5e73\u53f0\uff01platform:{}", (Object[])new Object[]{this.pre.getPlatform()}));
        }
        FileWrapper file = this.pre.getFileWrapper();
        if (file == null) {
            throw new FileStorageRuntimeException("\u6587\u4ef6\u4e0d\u5141\u8bb8\u4e3a null \uff01");
        }
        if (this.pre.getPlatform() == null) {
            throw new FileStorageRuntimeException("platform \u4e0d\u5141\u8bb8\u4e3a null \uff01");
        }
        FileInfo fileInfo = new FileInfo();
        fileInfo.setCreateTime(new Date());
        fileInfo.setSize(file.getSize());
        fileInfo.setOriginalFilename(file.getName());
        fileInfo.setExt(FileNameUtil.getSuffix((String)file.getName()));
        fileInfo.setObjectId(this.pre.getObjectId());
        fileInfo.setObjectType(this.pre.getObjectType());
        fileInfo.setPath(this.pre.getPath());
        fileInfo.setPlatform(this.pre.getPlatform());
        fileInfo.setMetadata(this.pre.getMetadata());
        fileInfo.setUserMetadata(this.pre.getUserMetadata());
        fileInfo.setThMetadata(this.pre.getThMetadata());
        fileInfo.setThUserMetadata(this.pre.getThUserMetadata());
        fileInfo.setAttr(this.pre.getAttr());
        fileInfo.setFileAcl(this.pre.getFileAcl());
        fileInfo.setThFileAcl(this.pre.getThFileAcl());
        if (StrUtil.isNotBlank((CharSequence)this.pre.getSaveFilename())) {
            fileInfo.setFilename(this.pre.getSaveFilename());
        } else {
            fileInfo.setFilename(IdUtil.objectId() + (StrUtil.isEmpty((CharSequence)fileInfo.getExt()) ? "" : "." + fileInfo.getExt()));
        }
        fileInfo.setContentType(file.getContentType());
        byte[] thumbnailBytes = this.pre.getThumbnailBytes();
        if (thumbnailBytes != null) {
            fileInfo.setThSize(Long.valueOf(thumbnailBytes.length));
            if (StrUtil.isNotBlank((CharSequence)this.pre.getSaveThFilename())) {
                fileInfo.setThFilename(this.pre.getSaveThFilename() + this.pre.getThumbnailSuffix());
            } else {
                fileInfo.setThFilename(fileInfo.getFilename() + this.pre.getThumbnailSuffix());
            }
            if (StrUtil.isNotBlank((CharSequence)this.pre.getThContentType())) {
                fileInfo.setThContentType(this.pre.getThContentType());
            } else {
                fileInfo.setThContentType(this.fileStorageService.getContentTypeDetect().detect(thumbnailBytes, fileInfo.getThFilename()));
            }
        }
        return new UploadAspectChain(aspectList, (_fileInfo, _pre, _fileStorage, _fileRecorder) -> {
            if (_fileStorage.save(_fileInfo, _pre)) {
                _fileInfo.setHashInfo(_pre.getHashCalculatorManager().getHashInfo());
                if (_fileRecorder.save(_fileInfo)) {
                    return _fileInfo;
                }
            }
            return null;
        }).next(fileInfo, this.pre, fileStorage, fileRecorder);
    }
}

